/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.security.impl;

import in.gov.uidai.ec.security.sapi.IDistributionKeyProvider;
import java.nio.ByteBuffer;
import java.util.Base64;

public class DistributionKeyProviderImpl
implements IDistributionKeyProvider {
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();

    @Override
    public String getKey() {
        byte[] encryptedDistributionKey = DistributionKeyProviderImpl.externGetEncryptedDistributionKey();
        return this.decryptWithLib(DistributionKeyProviderImpl.bytesToHex(encryptedDistributionKey));
    }

    private String decryptWithLib(String strToDecrypt) {
        byte[] decoded = DistributionKeyProviderImpl.hexStringToByteArray(strToDecrypt);
        byte[] iv = new byte[16];
        int contentLen = decoded.length - 16;
        byte[] content = new byte[contentLen];
        System.arraycopy(decoded, 0, iv, 0, 16);
        System.arraycopy(decoded, 16, content, 0, contentLen);
        ByteBuffer ivbb = ByteBuffer.allocateDirect(iv.length);
        ByteBuffer msgbb = ByteBuffer.allocateDirect(contentLen);
        ByteBuffer ivbbFinal = ivbb.put(iv);
        ByteBuffer msgbbFinal = msgbb.put(content);
        byte[] decodedStrBytes = DistributionKeyProviderImpl.externDecrypt(ivbbFinal, msgbbFinal);
        return Base64.getEncoder().encodeToString(decodedStrBytes);
    }

    private static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    private static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    private static native byte[] externDecrypt(ByteBuffer var0, ByteBuffer var1);

    private static native byte[] externEncrypt(ByteBuffer var0, ByteBuffer var1);

    private static native byte[] externGetEncryptedDistributionKey();
}

