/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.security.impl;

import in.gov.uidai.ec.security.error.SecurityRuntimeException;
import in.gov.uidai.ec.security.impl.CryptoUtility;
import in.gov.uidai.ec.security.impl.SecurityConstants;
import in.gov.uidai.ec.security.sapi.IHashGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.Base64;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HashGeneratorImpl
implements IHashGenerator,
SecurityConstants {
    private String algorithm = "SHA-256";
    private int hmacSize = 32;
    private static final Logger LOGGER = LoggerFactory.getLogger(HashGeneratorImpl.class);

    @Override
    public String encrypt(String data, String key) throws Exception {
        String hmacSha256;
        try {
            byte[] decodedKey = Base64.getDecoder().decode(key);
            Mac sha256_hmac = Mac.getInstance("HmacSHA256");
            SecretKeySpec secret_key = new SecretKeySpec(decodedKey, "HmacSHA256");
            sha256_hmac.init(secret_key);
            byte[] encryptedData = sha256_hmac.doFinal(data.getBytes(StandardCharsets.UTF_8));
            hmacSha256 = new String(Base64.getEncoder().encode(encryptedData));
        }
        catch (Exception e) {
            throw new Exception("Failed to calculate hmac-sha256", e);
        }
        return hmacSha256;
    }

    @Override
    public byte[] generateHash(byte[] message) {
        try {
            MessageDigest digest = MessageDigest.getInstance(this.algorithm, "BC");
            digest.reset();
            this.hmacSize = digest.getDigestLength();
            return digest.digest(message);
        }
        catch (GeneralSecurityException e) {
            throw new SecurityRuntimeException("security-errors:hash.noSHA256");
        }
    }

    @Override
    public byte[] generateHash(InputStream stream) {
        try {
            byte[] streamByteArray = new byte[stream.available()];
            int res = stream.read(streamByteArray, 0, stream.available());
            if (res > 0) {
                LOGGER.info("Read completed");
            } else {
                LOGGER.info("No more data present");
            }
            MessageDigest digest = MessageDigest.getInstance(this.algorithm, "BC");
            digest.reset();
            this.hmacSize = digest.getDigestLength();
            return digest.digest(streamByteArray);
        }
        catch (GeneralSecurityException e) {
            throw new SecurityRuntimeException("security-errors:hash.noSHA256");
        }
        catch (IOException e) {
            throw new SecurityRuntimeException("security-errors:hash.ioError:" + e.getMessage());
        }
    }

    @Override
    public String generateHashHexString(byte[] message) {
        return CryptoUtility.byteArrayToHexString(this.generateHash(message));
    }

    @Override
    public boolean validatePacketIntegrity(byte[] encryptedText) throws SecurityRuntimeException {
        int headerLen = SecurityConstants.HEADER_DATA.length;
        byte[][] headers = CryptoUtility.split(encryptedText, headerLen);
        byte[] header = headers[0];
        byte[] fullPacket = headers[1];
        if (!Arrays.equals(header, SecurityConstants.HEADER1_DATA)) {
            return this.validatePublicKeyInPacket(encryptedText);
        }
        byte[][] hashData = CryptoUtility.split(fullPacket, this.hmacSize);
        byte[] hash = hashData[0];
        byte[] actualEncryptedPacket = hashData[1];
        byte[] actualHash = this.generateHash(actualEncryptedPacket);
        return new String(hash, StandardCharsets.UTF_8).equals(new String(actualHash, StandardCharsets.UTF_8));
    }

    @Override
    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    private boolean validatePublicKeyInPacket(byte[] encryptedPacket) throws SecurityRuntimeException {
        try {
            byte[] publicKeyData = new byte[162];
            KeyFactory kf = KeyFactory.getInstance("RSA", "BC");
            System.arraycopy(encryptedPacket, 0, publicKeyData, 0, 162);
            X509EncodedKeySpec pubSpec = new X509EncodedKeySpec(publicKeyData);
            RSAPublicKey rSAPublicKey = (RSAPublicKey)kf.generatePublic(pubSpec);
        }
        catch (Exception e) {
            throw new SecurityRuntimeException("Unable to form a valid public key for 1K packets " + e);
        }
        return true;
    }
}

