/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.security.impl;

import in.gov.uidai.ec.security.impl.JarVerifierService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JarIntegrityCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(JarIntegrityCheck.class);
    String currWorkDir = System.getProperty("user.dir");
    String fname = this.currWorkDir + File.separator + "lib";
    File[] files = new File(this.fname).listFiles((dir, name) -> name.startsWith("in.gov.uidai"));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verifyJar(String applicationVersion) {
        HashMap<String, String> results = new HashMap<String, String>();
        HashMap<String, File> uidaiJars = new HashMap<String, File>();
        boolean jarVerificationStatus = true;
        for (File file : this.files) {
            if (!file.isFile()) continue;
            JarFile file2 = null;
            try {
                file2 = new JarFile(file);
                Manifest manifest = file2.getManifest();
                Attributes attributes = manifest.getMainAttributes();
                String jarVersion = attributes.getValue("Jar-Version");
                String jarArtifactId = attributes.getValue("Artifact-Id");
                results.put(jarArtifactId, jarVersion);
                uidaiJars.put(jarArtifactId, file);
            }
            catch (IOException e) {
                LOGGER.error("Error while reading the UIDAi related JAR files.", (Throwable)e);
            }
            finally {
                try {
                    if (file2 != null) {
                        file2.close();
                    }
                }
                catch (IOException e) {
                    LOGGER.error("Error in closing the file");
                }
            }
        }
        LOGGER.info("DependentModuleVersion.getVersionDetail()" + results);
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = JarIntegrityCheck.class.getClassLoader();
        }
        try {
            InputStream input = cl.getResourceAsStream("conf/dependent_module_version.xml");
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            dbFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            dbFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            dbFactory.setValidating(true);
            Document doc = dbFactory.newDocumentBuilder().parse(input);
            doc.getDocumentElement().normalize();
            NodeList nList = doc.getElementsByTagName("version");
            for (int temp = 0; temp < nList.getLength(); ++temp) {
                Node nNode = nList.item(temp);
                String clientVer = "";
                if (nNode.getNodeType() == 1) {
                    clientVer = ((Element)nNode).getAttribute("no");
                }
                if (applicationVersion.equalsIgnoreCase(clientVer)) {
                    NodeList nList1 = doc.getElementsByTagName("module");
                    for (int temp1 = 0; temp1 < nList1.getLength(); ++temp1) {
                        String jarVer;
                        Node nNode1 = nList1.item(temp1);
                        if (nNode1.getNodeType() != 1) continue;
                        Element eElement = (Element)nNode1;
                        String moduleName = eElement.getAttribute("name");
                        String moduleVer = eElement.getAttribute("minVer");
                        if (!moduleVer.equalsIgnoreCase(jarVer = (String)results.get(moduleName))) {
                            LOGGER.info("Version mismatch for Module name :: " + moduleName + "::Module Version:: " + moduleVer);
                            return false;
                        }
                        File jarFile = (File)uidaiJars.get(moduleName);
                        jarVerificationStatus = JarVerifierService.selfIntegrityChecking(jarFile, false);
                        if (jarVerificationStatus) continue;
                        LOGGER.info("Jar verification failed  for Module name :: " + moduleName + "::Module Version:: " + moduleVer);
                        return false;
                    }
                    continue;
                }
                LOGGER.info("The ApplicationVersion VERSION and the version in the xml are not same");
                jarVerificationStatus = false;
            }
            return jarVerificationStatus;
        }
        catch (Exception exep) {
            throw new RuntimeException("Jar Validation could not be performed.");
        }
    }
}

