/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.security.impl;

import in.gov.uidai.ec.security.error.SecurityRuntimeException;
import in.gov.uidai.ec.security.impl.JarIntegrityCheck;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarVerifierService {
    private static final Logger LOGGER = LoggerFactory.getLogger(JarIntegrityCheck.class);
    private static X509Certificate providerCert = null;
    private static final String INTEGRITY_PUBLIC_KEY_FILE = "integrity/uidai.gov.in.cer";

    protected static synchronized boolean selfIntegrityChecking(File jar, boolean verifiedSelfIntegrity) {
        LOGGER.info("selfIntegrityChecking started");
        if (verifiedSelfIntegrity) {
            return true;
        }
        URL providerURL = AccessController.doPrivileged(() -> {
            CodeSource cs = JarVerifierService.class.getProtectionDomain().getCodeSource();
            return cs.getLocation();
        });
        if (providerURL == null) {
            return false;
        }
        JarVerifier jv = new JarVerifier();
        try {
            if (providerCert == null && (providerCert = JarVerifierService.setupProviderCert()) != null) {
                LOGGER.info("providerCert" + providerCert.getIssuerDN());
            }
            jv.verify(providerCert, jar);
        }
        catch (Exception e) {
            LOGGER.error("Error validating jar signature", (Throwable)e);
            return false;
        }
        return true;
    }

    private static X509Certificate setupProviderCert() throws CertificateException, SecurityRuntimeException {
        InputStream certStream = ClassLoader.getSystemResourceAsStream(INTEGRITY_PUBLIC_KEY_FILE);
        if (certStream == null) {
            throw new SecurityRuntimeException("IntegrityVerificationCertificateNotFound");
        }
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        return (X509Certificate)cf.generateCertificate(certStream);
    }

    static class JarVerifier {
        private JarFile jarFile = null;

        JarVerifier() {
        }

        private JarFile retrieveJarFileFromURL(File file) throws IOException {
            this.jarFile = new JarFile(file);
            return this.jarFile;
        }

        public void verify(X509Certificate targetCert, File jar) throws IOException {
            if (targetCert == null) {
                LOGGER.error("Provider certificate is invalid");
                throw new SecurityException("Provider certificate is invalid");
            }
            try {
                if (this.jarFile == null) {
                    this.jarFile = this.retrieveJarFileFromURL(jar);
                }
            }
            catch (Exception ex) {
                SecurityException se = new SecurityException();
                se.initCause(ex);
                LOGGER.error("Provider certificate initCause" + ex.getMessage());
                throw se;
            }
            Vector<JarEntry> entriesVec = new Vector<JarEntry>();
            Manifest man = this.jarFile.getManifest();
            if (man == null) {
                LOGGER.error("The provider is not signed if manifest is null");
                throw new SecurityException("The provider is not signed");
            }
            byte[] buffer = new byte[8192];
            Enumeration<JarEntry> entries = this.jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry je = entries.nextElement();
                if (je.isDirectory()) continue;
                entriesVec.addElement(je);
                InputStream is = this.jarFile.getInputStream(je);
                while (is.read(buffer, 0, buffer.length) != -1) {
                }
                is.close();
            }
            Enumeration e = entriesVec.elements();
            while (e.hasMoreElements()) {
                X509Certificate[] certChain;
                JarEntry je = (JarEntry)e.nextElement();
                Certificate[] certs = je.getCertificates();
                if (certs == null || certs.length == 0) {
                    if (je.getName().startsWith("META-INF")) continue;
                    LOGGER.error("The provider has unsigned class files.");
                    throw new SecurityException("The provider has unsigned class files.");
                }
                int startIndex = 0;
                boolean signedAsExpected = false;
                while ((certChain = JarVerifier.getAChain(certs, startIndex)) != null) {
                    if (certChain[0].equals(targetCert)) {
                        signedAsExpected = true;
                        break;
                    }
                    startIndex += certChain.length;
                }
                if (signedAsExpected) continue;
                LOGGER.error("The provider is not signed by a trusted signer");
                throw new SecurityException("The provider is not signed by a trusted signer");
            }
        }

        private static X509Certificate[] getAChain(Certificate[] certs, int startIndex) {
            int i;
            if (startIndex > certs.length - 1) {
                return null;
            }
            for (i = startIndex; i < certs.length - 1 && ((X509Certificate)certs[i + 1]).getSubjectDN().equals(((X509Certificate)certs[i]).getIssuerDN()); ++i) {
            }
            int certChainSize = i - startIndex + 1;
            X509Certificate[] ret = new X509Certificate[certChainSize];
            for (int j = 0; j < certChainSize; ++j) {
                ret[j] = (X509Certificate)certs[startIndex + j];
            }
            return ret;
        }

        protected void finalize() throws Throwable {
            this.jarFile.close();
        }
    }
}

