/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.security.impl;

import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.jasypt.encryption.pbe.StandardPBEByteEncryptor;
import org.jasypt.salt.RandomSaltGenerator;
import org.jasypt.salt.SaltGenerator;

public class PebEncryptionUtil {
    static final int ENCRYPT_KEY_LEN = 16;

    public static byte[] encrypt(byte[] data) {
        byte[] passBytes = PebEncryptionUtil.getEncryptionPasswordBytes();
        String password = PebEncryptionUtil.getPasswordForEncryption(passBytes);
        StandardPBEByteEncryptor pbe = new StandardPBEByteEncryptor();
        pbe.setPassword(password);
        pbe.setKeyObtentionIterations(1000);
        pbe.setSaltGenerator((SaltGenerator)new RandomSaltGenerator());
        byte[] encryptedData = pbe.encrypt(data);
        byte[] savedDatFileBytes = new byte[encryptedData.length + passBytes.length];
        System.arraycopy(passBytes, 0, savedDatFileBytes, 0, passBytes.length);
        System.arraycopy(encryptedData, 0, savedDatFileBytes, passBytes.length, encryptedData.length);
        return savedDatFileBytes;
    }

    private static String getPasswordForEncryption(byte[] passwordBytes) {
        return new BigInteger(passwordBytes).toString(36);
    }

    private static byte[] getEncryptionPasswordBytes() {
        byte[] passBytes = new byte[16];
        try {
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            random.setSeed(System.currentTimeMillis());
            random.nextBytes(passBytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Random Number Generation Error.");
        }
        return passBytes;
    }

    public static byte[] decrypt(byte[] fileContent) {
        if (fileContent.length < 16) {
            return null;
        }
        String password = PebEncryptionUtil.getPasswordForDecryption(fileContent);
        StandardPBEByteEncryptor pbe = new StandardPBEByteEncryptor();
        pbe.setPassword(password);
        pbe.setKeyObtentionIterations(1000);
        byte[] subContent = new byte[fileContent.length - 16];
        System.arraycopy(fileContent, 16, subContent, 0, fileContent.length - 16);
        return pbe.decrypt(subContent);
    }

    private static String getPasswordForDecryption(byte[] content) {
        byte[] passBytes = new byte[16];
        System.arraycopy(content, 0, passBytes, 0, 16);
        return new BigInteger(passBytes).toString(36);
    }
}

