/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.security.impl;

import in.gov.uidai.ec.security.impl.RecoverableFileException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecoverableFile {
    private static final Logger LOGGER = LoggerFactory.getLogger(RecoverableFile.class);
    protected String path;

    public RecoverableFile(String path) {
        this.path = path;
    }

    public synchronized void write(byte[] data) throws RecoverableFileException {
        this.writeToTempFile(data);
        this.createBackup();
        this.commit();
    }

    protected synchronized void createCopy(byte[] data) throws RecoverableFileException {
        File copyFile = this.getCopy();
        this.writeToFile(data, copyFile);
    }

    public synchronized byte[] readWithRecover() throws RecoverableFileException {
        File file = this.getFileToRead(true);
        return this.readFile(file);
    }

    public byte[] read() throws RecoverableFileException {
        File file = this.getFileToRead(false);
        return this.readFile(file);
    }

    protected byte[] readCopy() throws RecoverableFileException {
        File copyFile = this.getCopy();
        return this.readFile(copyFile);
    }

    private File getFileToRead(boolean rename) throws RecoverableFileException {
        File file = this.getCommitFile();
        if (file.exists()) {
            return file;
        }
        File backupFile = this.getBackupFile();
        if (backupFile.exists()) {
            if (rename) {
                LOGGER.warn(file + " not found. recovering from " + backupFile.getName());
                if (!backupFile.renameTo(file)) {
                    LOGGER.warn("error recovering file. failure renaming " + backupFile + " to " + file);
                }
                return file;
            }
            LOGGER.warn(file + " file not found. reading from backup file " + backupFile.getName());
            return backupFile;
        }
        throw new RecoverableFileException("no current or backup file " + file);
    }

    protected byte[] readFile(File file) throws RecoverableFileException {
        try {
            return Files.readAllBytes(file.toPath());
        }
        catch (Exception e) {
            LOGGER.error("error reading from recoverable file", (Throwable)e);
            throw new RecoverableFileException("error reading from recoverable file", e);
        }
    }

    public synchronized long lastModified() {
        File readFile;
        File backupFile = this.getBackupFile();
        File fileToReadFrom = readFile = new File(this.path);
        if (!readFile.exists()) {
            fileToReadFrom = backupFile;
        }
        return fileToReadFrom.lastModified();
    }

    public synchronized boolean exists() {
        return this.getCommitFile().exists() || this.getBackupFile().exists();
    }

    private void commit() throws RecoverableFileException {
        File commitFile;
        File tempFile = this.getTempFile();
        boolean rename = tempFile.renameTo(commitFile = this.getCommitFile());
        if (!rename) {
            throw new RecoverableFileException("failure renaming" + tempFile + " to " + commitFile);
        }
    }

    private void createBackup() throws RecoverableFileException {
        boolean rename;
        boolean deleteStatus;
        File backupFile = this.getBackupFile();
        File file = this.getCommitFile();
        if (!file.exists()) {
            return;
        }
        if (backupFile.exists() && !(deleteStatus = backupFile.delete())) {
            LOGGER.warn("failure deleting backup file: " + backupFile);
        }
        if (!(rename = file.renameTo(backupFile))) {
            throw new RecoverableFileException("failure renaming" + file + " to " + backupFile);
        }
    }

    protected void writeToTempFile(byte[] data) throws RecoverableFileException {
        File tempFile = this.getTempFile();
        this.writeToFile(data, tempFile);
    }

    protected void writeToFile(byte[] data, File file) throws RecoverableFileException {
        try (FileOutputStream fos = new FileOutputStream(file);){
            fos.write(data);
            fos.flush();
            fos.getFD().sync();
        }
        catch (IOException e) {
            throw new RecoverableFileException("error writing to " + file, e);
        }
    }

    private File getCommitFile() {
        return new File(this.path);
    }

    private File getTempFile() {
        return new File(this.path + ".tmp");
    }

    private File getCopy() {
        return new File(this.path + ".copy");
    }

    private File getBackupFile() {
        return new File(this.path + ".old");
    }
}

