/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.security.impl;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Pointer;

public class SecureCommunicationBridge {
    private static volatile SecureCommunicationBridge instance;
    private static CoreConnectLib coreConnectInstance;
    private String defaultHttpUrl;
    private String defaultGrpcUrl;
    private String proxyUrl;

    private SecureCommunicationBridge() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SecureCommunicationBridge getInstance() {
        if (instance != null) return instance;
        Class<SecureCommunicationBridge> clazz = SecureCommunicationBridge.class;
        synchronized (SecureCommunicationBridge.class) {
            if (instance != null) return instance;
            try {
                System.setProperty("jna.library.path", "bin");
                coreConnectInstance = (CoreConnectLib)Native.load((String)"core_connect", CoreConnectLib.class);
                instance = new SecureCommunicationBridge();
            }
            catch (UnsatisfiedLinkError e) {
                e.printStackTrace();
            }
            return instance;
        }
    }

    public String sendHttpRequestWithDefaultValues(String method, String body) {
        if (this.defaultHttpUrl == null) {
            throw new IllegalStateException("Default gRPC URL is not set");
        }
        return SecureCommunicationBridge.processAndFree(coreConnectInstance.MakeHttpRequest(method, this.defaultHttpUrl, body, this.proxyUrl));
    }

    public String sendGrpcRequestWithDefaultValues(String service, String method, byte[] requestData, String metadataJson) {
        if (this.defaultGrpcUrl == null) {
            throw new IllegalStateException("Default gRPC URL is not set");
        }
        return SecureCommunicationBridge.processAndFree(coreConnectInstance.MakeGrpcRequest(this.defaultGrpcUrl, service, method, metadataJson, this.proxyUrl, requestData, requestData.length));
    }

    public String sendGrpcRequestTo(String targetUrl, String service, String method, byte[] requestData, String metadataJson, String proxyUrl) {
        return SecureCommunicationBridge.processAndFree(coreConnectInstance.MakeGrpcRequest(targetUrl, service, method, metadataJson, proxyUrl, requestData, requestData.length));
    }

    public String initializeClient(String url, String clientHeader, String proxyUrl) {
        this.setProxyUrl(proxyUrl);
        return SecureCommunicationBridge.processAndFree(coreConnectInstance.InitClient(url, clientHeader, proxyUrl));
    }

    private static String processAndFree(Pointer ptr) {
        if (ptr == null) {
            return null;
        }
        try {
            String string = ptr.getString(0L);
            return string;
        }
        finally {
            coreConnectInstance.FreeString(ptr);
        }
    }

    public void setProxyUrl(String proxyUrl) {
        this.proxyUrl = proxyUrl;
    }

    public void setDefaultGrpcUrl(String url) {
        this.defaultGrpcUrl = url;
    }

    private static interface CoreConnectLib
    extends Library {
        public Pointer MakeHttpRequest(String var1, String var2, String var3, String var4);

        public Pointer InitClient(String var1, String var2, String var3);

        public Pointer MakeGrpcRequest(String var1, String var2, String var3, String var4, String var5, byte[] var6, int var7);

        public void FreeString(Pointer var1);
    }
}

