/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.security.impl;

import in.gov.uidai.ec.security.error.SecurityRuntimeException;
import in.gov.uidai.ec.security.impl.SecurityConstants;
import in.gov.uidai.ec.security.sapi.ISignature;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class SignatureImpl
implements ISignature,
SecurityConstants {
    private static final String MEC_TYPE = "DOM";
    private static final String SIGNATURE_TAG = "Signature";
    private static final String SIGNATURE_PUBLIC_KEY_FILE = "usercredentials/UserCredentialsSign.cer";

    @Override
    public boolean verify(String certFileName, String registrarCode) {
        return false;
    }

    @Override
    public boolean verify(Document xmlDoc, String certFilePath) throws SecurityRuntimeException {
        PublicKey publicKey = this.getPublicKeyFromCert(certFilePath);
        return this.verify(xmlDoc, publicKey);
    }

    private PublicKey getPublicKeyFromCert(String certFilePath) throws SecurityRuntimeException {
        FileInputStream fis = null;
        try {
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509", "BC");
            fis = new FileInputStream(certFilePath);
            X509Certificate cert = (X509Certificate)certFactory.generateCertificate(fis);
            PublicKey publicKey = cert.getPublicKey();
            return publicKey;
        }
        catch (IOException ioe) {
            throw new SecurityRuntimeException(ioe.getMessage());
        }
        catch (GeneralSecurityException genExp) {
            throw new SecurityRuntimeException(genExp.getMessage());
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public boolean verify(Document xmlDoc) throws SecurityRuntimeException {
        PublicKey publicKey = this.getPublicKeyFromClasspath();
        return this.verify(xmlDoc, publicKey);
    }

    private PublicKey getPublicKeyFromClasspath() {
        InputStream certStream = ClassLoader.getSystemResourceAsStream(SIGNATURE_PUBLIC_KEY_FILE);
        if (certStream == null) {
            throw new SecurityRuntimeException("SignatureCertificateNotFound");
        }
        X509Certificate issuerCert = this.getCertificate(certStream);
        return issuerCert.getPublicKey();
    }

    private X509Certificate getCertificate(InputStream certStream) {
        try {
            CertificateFactory factory = CertificateFactory.getInstance("X.509", "BC");
            return (X509Certificate)factory.generateCertificate(certStream);
        }
        catch (GeneralSecurityException exp) {
            throw new SecurityRuntimeException(exp.getMessage());
        }
    }

    private boolean verify(Document xmlDoc, PublicKey publicKey) throws SecurityRuntimeException {
        try {
            NodeList nl = xmlDoc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", SIGNATURE_TAG);
            if (nl.getLength() == 0) {
                throw new IllegalArgumentException("Cannot find Signature element");
            }
            XMLSignatureFactory fac = XMLSignatureFactory.getInstance(MEC_TYPE);
            DOMValidateContext valContext = new DOMValidateContext(publicKey, nl.item(0));
            XMLSignature signature = fac.unmarshalXMLSignature(valContext);
            return signature.validate(valContext);
        }
        catch (MarshalException mExp) {
            throw new SecurityRuntimeException(mExp.getMessage());
        }
        catch (XMLSignatureException xmlExp) {
            throw new SecurityRuntimeException(xmlExp.getMessage());
        }
    }
}

