/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.security.impl;

import in.gov.uidai.ec.security.impl.SecurityConstants;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Utility
implements SecurityConstants {
    private static final Logger LOGGER = LoggerFactory.getLogger(Utility.class);

    public static String byteArrayToHexString(byte[] bytes) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            result.append(Integer.toString((bytes[i] & 0xFF) + 256, 16).substring(1));
        }
        return result.toString();
    }

    public static byte[] hexStringToByteArray(String data) {
        int k = 0;
        byte[] results = new byte[data.length() / 2];
        int i = 0;
        while (i < data.length()) {
            results[k] = (byte)(Character.digit(data.charAt(i++), 16) << 4);
            int n = k++;
            results[n] = (byte)(results[n] + (byte)Character.digit(data.charAt(i++), 16));
        }
        return results;
    }

    public static byte[][] split(byte[] src, int n) {
        byte[] r;
        byte[] l;
        if (src == null || src.length <= n) {
            l = src;
            r = new byte[]{};
        } else {
            l = new byte[n];
            r = new byte[src.length - n];
            System.arraycopy(src, 0, l, 0, n);
            System.arraycopy(src, n, r, 0, r.length);
        }
        return new byte[][]{l, r};
    }

    public static int length(byte[] byteArr) {
        return byteArr == null ? 0 : byteArr.length;
    }

    public static int length(String anyStr) {
        return anyStr == null ? 0 : anyStr.trim().length();
    }

    public static String convertToUUID(String convertString) {
        StringBuilder newValue = new StringBuilder();
        newValue.append(convertString.substring(0, 8));
        newValue.append("-");
        newValue.append(convertString.substring(8, 12));
        newValue.append("-");
        newValue.append(convertString.substring(12, 16));
        newValue.append("-");
        newValue.append(convertString.substring(16, 20));
        newValue.append("-");
        newValue.append(convertString.substring(20, 32));
        return newValue.toString();
    }

    public static byte[] generateHash(byte[] message) {
        byte[] hash = null;
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256", "BC");
            digest.reset();
            hash = digest.digest(message);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("SHA-256 Hashing algorithm not available");
        }
        return hash;
    }

    public static boolean compareByteArray(byte[] array1, byte[] array2) {
        if (array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (array1[i] == array2[i]) continue;
            return false;
        }
        return true;
    }
}

