/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.security.sapi;

import in.gov.uidai.ec.security.sapi.IHashGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SecurityProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecurityProvider.class);
    private static SecurityProvider theInst;
    protected static String keySize;
    protected static String ecmpTimeout;

    public static final SecurityProvider getInst() {
        return theInst;
    }

    protected SecurityProvider() {
    }

    public abstract void setKeySize(String var1);

    public abstract IHashGenerator getHashGenerator();

    static {
        ClassLoader cl = SecurityProvider.class.getClassLoader();
        InputStream input = cl.getResourceAsStream("conf/securityprovider.properties");
        Properties props = new Properties();
        try {
            props.load(input);
            input.close();
            String fqcn = props.getProperty("provider.class");
            theInst = (SecurityProvider)cl.loadClass(fqcn).newInstance();
            keySize = props.getProperty("key.version");
            ecmpTimeout = props.getProperty("ecmp.timeout");
        }
        catch (IOException | NullPointerException exep) {
            LOGGER.error("error reading security provider information", (Throwable)exep);
        }
        catch (ClassNotFoundException exep) {
            LOGGER.error("security provider not found", (Throwable)exep);
        }
        catch (IllegalAccessException | InstantiationException exep) {
            LOGGER.error("unable to create security provider", (Throwable)exep);
        }
    }
}

