/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ecmpapi;

import in.gov.uidai.ec.ecmpapi.EcmpApiException;
import in.gov.uidai.ec.ecmpapi.PublicKeysHolder;
import java.security.SecureRandom;

public class CIDREncryptorImpl {
    private PublicKeysHolder keysHolder = PublicKeysHolder.getInstance();

    public byte[] getPublicKey() {
        int random = this.getRandom(this.keysHolder.getNoOfKeys());
        return this.keysHolder.getPublicKey(random);
    }

    private int getRandom(int keyCount) {
        int start = 0;
        int end = keyCount - 1;
        SecureRandom random = new SecureRandom();
        if (start > end) {
            throw new EcmpApiException("security-errors:emptyKeyFile");
        }
        long range = (long)end - (long)start + 1L;
        long fraction = (long)((double)range * random.nextDouble());
        int randomNumber = (int)(fraction + (long)start);
        return randomNumber;
    }
}

