/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ecmpapi;

import com.google.common.base.Strings;
import in.gov.uidai.ec.ecmpapi.EcmpApiException;
import in.gov.uidai.ec.oauthapi.exception.ErrorCodes;
import in.gov.uidai.ec.oauthapi.json.UosResponse;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.GregorianCalendar;
import javax.xml.bind.JAXB;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CommonUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommonUtils.class);

    public static XMLGregorianCalendar getXMLTimeStamp() {
        XMLGregorianCalendar xmlCalendar;
        try {
            DatatypeFactory dataFactory = DatatypeFactory.newInstance();
            GregorianCalendar cal = new GregorianCalendar();
            xmlCalendar = dataFactory.newXMLGregorianCalendar(cal);
        }
        catch (DatatypeConfigurationException e) {
            LOGGER.error("Default DataTypeFactory for generating XMLGregorianCalendar is missing. Configure a DataTypeFactory.", (Throwable)e);
            throw new EcmpApiException("Exception during creating timestamp", e);
        }
        return xmlCalendar;
    }

    public static Object unMarshal(InputStreamReader inputStream, Class<?> responseType) throws JAXBException, XMLStreamException {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{responseType});
        Unmarshaller m = jc.createUnmarshaller();
        XMLInputFactory xif = XMLInputFactory.newFactory();
        xif.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        xif.setProperty("javax.xml.stream.supportDTD", false);
        XMLStreamReader xsr = xif.createXMLStreamReader(inputStream);
        return m.unmarshal(xsr);
    }

    public static Object unMarshal(InputStream inputStream, Class<?> responseType) throws JAXBException, XMLStreamException {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{responseType});
        Unmarshaller m = jc.createUnmarshaller();
        XMLInputFactory xif = XMLInputFactory.newFactory();
        xif.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        xif.setProperty("javax.xml.stream.supportDTD", false);
        XMLStreamReader xsr = xif.createXMLStreamReader(inputStream);
        return m.unmarshal(xsr);
    }

    public static Object unmarshal(InputStream inputStream, Class<?> responseType) throws JAXBException, XMLStreamException {
        return JAXB.unmarshal((InputStream)inputStream, responseType);
    }

    public static String getErrorMessage(UosResponse uosResponse) {
        if (uosResponse.getErrorDetail() != null) {
            if (!Strings.isNullOrEmpty((String)uosResponse.getErrorDetail().getMessage())) {
                return uosResponse.getErrorDetail().getMessage();
            }
            if (!Strings.isNullOrEmpty((String)uosResponse.getErrorDetail().getMessageEnglish())) {
                return uosResponse.getErrorDetail().getMessageEnglish();
            }
            return uosResponse.getErrorDetail().getMessageLocal();
        }
        if (!Strings.isNullOrEmpty((String)uosResponse.getError()) && !Strings.isNullOrEmpty((String)uosResponse.getErrorDescription())) {
            if (uosResponse.getError().contains("invalid_token")) {
                return ErrorCodes.UC_OP_002.getReason();
            }
            return uosResponse.getErrorDescription();
        }
        return "";
    }

    public static String getErrorCode(UosResponse uosResponse) {
        if (!Strings.isNullOrEmpty((String)uosResponse.getErrorCode())) {
            return uosResponse.getErrorCode();
        }
        if (!Strings.isNullOrEmpty((String)uosResponse.getError()) && !Strings.isNullOrEmpty((String)uosResponse.getErrorDescription())) {
            if (uosResponse.getError().contains("invalid_token")) {
                return ErrorCodes.UC_OP_002.getErrorCode();
            }
            return ErrorCodes.UC_GEN_001.getErrorCode();
        }
        return ErrorCodes.UC_GEN_001.getErrorCode();
    }
}

