/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ecmpapi;

import in.gov.uidai.ec.ecmpapi.EcmpApiException;
import in.gov.uidai.ec.ecmpapi.EcmpApiSecurityConstants;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;

final class EcmpApiHashGenerator
implements EcmpApiSecurityConstants {
    private String algorithm = "SHA-256";

    EcmpApiHashGenerator() {
    }

    void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    byte[] generateHash(byte[] message) {
        try {
            MessageDigest digest = MessageDigest.getInstance(this.algorithm, "BC");
            digest.reset();
            digest.getDigestLength();
            return digest.digest(message);
        }
        catch (GeneralSecurityException e) {
            throw new EcmpApiException("security-errors:hash.noSHA256");
        }
    }

    String generateHashHexString(byte[] bytes) {
        StringBuilder result = new StringBuilder();
        for (byte aByte : this.generateHash(bytes)) {
            result.append(Integer.toString((aByte & 0xFF) + 256, 16).substring(1));
        }
        return result.toString();
    }
}

