/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ecmpapi;

import com.fasterxml.jackson.databind.ObjectMapper;
import in.gov.uidai.ec.ecmpapi.CommonUtils;
import in.gov.uidai.ec.ecmpapi.EcmpApiBusinessException;
import in.gov.uidai.ec.ecmpapi.EcmpApiConstants;
import in.gov.uidai.ec.ecmpapi.EcmpApiException;
import in.gov.uidai.ec.ecmpapi.EcmpRequest;
import in.gov.uidai.ec.ecmpapi.EcmpRequestHandler;
import in.gov.uidai.ec.ecmpapi.ICIDRPreference;
import in.gov.uidai.ec.ecmpapi.ITokenProvider;
import in.gov.uidai.ec.ecmpapi.SecurityTokenManager;
import in.gov.uidai.ec.ecmpapi.json.StationRegistrationHelperRequest;
import in.gov.uidai.ec.ecmpapi.json.mandatorybiometriccheck.MandatoryBiometricCheckResponse;
import in.gov.uidai.ec.ecmpapi.json.onlineqc.EnrollmentUploadResponse;
import in.gov.uidai.ec.ecmpapi.json.onlineqc.OnlineEnrollmentRequest;
import in.gov.uidai.ec.ecmpapi.json.sessionlogout.SessionLogoutResponse;
import in.gov.uidai.ec.ecmpapi.json.sessionvalidation.SessionValidationResponse;
import in.gov.uidai.ec.ecmpapi.json.statuscheck.UidStatusCheckResponse;
import in.gov.uidai.ec.ecmpapi.model.RegisteredDeviceType;
import in.gov.uidai.ec.ecmpapi.model.RegisteredDeviceTypeError;
import in.gov.uidai.ec.ecmpapi.xml.Gps.GpsDataReadReq;
import in.gov.uidai.ec.ecmpapi.xml.Gps.GpsValidationResponse;
import in.gov.uidai.ec.ecmpapi.xml.api.ApiResponseMessage;
import in.gov.uidai.ec.ecmpapi.xml.api.ApiServerError;
import in.gov.uidai.ec.ecmpapi.xml.bioverify.xml.BioVerifyRequest;
import in.gov.uidai.ec.ecmpapi.xml.bioverify.xml.BioVerifyResponse;
import in.gov.uidai.ec.ecmpapi.xml.cidgenerateotp.CidOtpRequest;
import in.gov.uidai.ec.ecmpapi.xml.cidgenerateotp.CidOtpResponse;
import in.gov.uidai.ec.ecmpapi.xml.disclosure.DisclosureRequest;
import in.gov.uidai.ec.ecmpapi.xml.disclosure.DisclosureResponse;
import in.gov.uidai.ec.ecmpapi.xml.docarchival.DocArchivalDataReadReq;
import in.gov.uidai.ec.ecmpapi.xml.docarchival.DocArchivalGetDocumentDetailsAPIResponse;
import in.gov.uidai.ec.ecmpapi.xml.findaadhaar.FindAadhaarRequest;
import in.gov.uidai.ec.ecmpapi.xml.operatorsync.OperatorCenterSyncRequest;
import in.gov.uidai.ec.ecmpapi.xml.operatorsync.OperatorCenterSyncResponse;
import in.gov.uidai.ec.ecmpapi.xml.presync.PreSyncRequest;
import in.gov.uidai.ec.ecmpapi.xml.presync.PreSyncResponse;
import in.gov.uidai.ec.ecmpapi.xml.qssitv.Result;
import in.gov.uidai.ec.ecmpapi.xml.qssitv.TokenRequest;
import in.gov.uidai.ec.ecmpapi.xml.qssitv.TokenResponse;
import in.gov.uidai.ec.ecmpapi.xml.stationderegister.DeRegisterStationRequest;
import in.gov.uidai.ec.ecmpapi.xml.stationderegister.DeRegisterStationResponse;
import in.gov.uidai.ec.ecmpapi.xml.stationregister.RegisterStationRequest;
import in.gov.uidai.ec.ecmpapi.xml.stationregister.RegisterStationResponse;
import in.gov.uidai.ec.oauthapi.IGatewayPreference;
import in.gov.uidai.ec.security.impl.DistributionKeyProviderImpl;
import java.io.IOException;
import java.net.URISyntaxException;
import org.apache.http.HttpResponse;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class EcmpApiService
extends EcmpRequestHandler
implements EcmpApiConstants,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(EcmpApiService.class);
    private final SecurityTokenManager securityTokenManager = new SecurityTokenManager();
    private ITokenProvider tokenDAO;
    private ICIDRPreference cidrPreference;
    private IGatewayPreference gatewayPreference;

    public void setGatewayPreference(IGatewayPreference gatewayPreference) {
        this.gatewayPreference = gatewayPreference;
    }

    public void setCidrPreference(ICIDRPreference cidrPreference) {
        this.cidrPreference = cidrPreference;
    }

    public void setTokenManagerDAO(ITokenProvider dao) {
        this.tokenDAO = dao;
    }

    public OperatorCenterSyncResponse operatorSyncDetailsSubmit(OperatorCenterSyncRequest operatorCenterSyncRequest, boolean rdCaptured) throws IOException {
        try {
            return (OperatorCenterSyncResponse)this.doPostEncrypted("/uidclientintegrationserver/v3/operatorCenterSyncApiDetailsSubmit", operatorCenterSyncRequest, String.valueOf(this.securityTokenManager.getToken()), OperatorCenterSyncResponse.class);
        }
        catch (EcmpApiBusinessException e) {
            ObjectMapper mapper = new ObjectMapper();
            ApiServerError apiServerData = (ApiServerError)mapper.readValue(e.getMessage(), ApiServerError.class);
            String[] regDetails = apiServerData.getDescription().split(",");
            if (apiServerData.getShortName().equals("ACTIVE_SESSION_EXISTS")) {
                throw new EcmpApiBusinessException(String.format("Only one active session allowed per operator. \nActive session exist on registrar: %s, agency: %s, station: %s", regDetails[0], regDetails[1], regDetails[2]));
            }
            throw new EcmpApiException("Operator sync failed", e);
        }
    }

    public OperatorCenterSyncResponse operatorSyncOtpSubmit(OperatorCenterSyncRequest operatorCenterSyncRequest, boolean rdCaptured) throws IOException {
        operatorCenterSyncRequest.addHeader("X-Request-Device-Type", rdCaptured ? "registered" : "non-registered");
        if (rdCaptured) {
            return (OperatorCenterSyncResponse)this.doPostEncrypted("/uidclientintegrationserver/v25/operatorCenterSyncApi25", operatorCenterSyncRequest, String.valueOf(this.securityTokenManager.getToken()), OperatorCenterSyncResponse.class);
        }
        return (OperatorCenterSyncResponse)this.doPostEncrypted("/uidclientintegrationserver/v2/operatorCenterSyncApiOtpSubmit", operatorCenterSyncRequest, String.valueOf(this.securityTokenManager.getToken()), OperatorCenterSyncResponse.class);
    }

    public TokenResponse syncToken(TokenRequest tokenRequest) throws IOException {
        TokenResponse tokenResponse = (TokenResponse)this.doPostEncrypted("/uidclientintegrationserver/requestToken", tokenRequest, String.valueOf(this.securityTokenManager.getToken()), TokenResponse.class);
        if (tokenResponse.getResult() == Result.SUCCESS) {
            this.securityTokenManager.setToken(tokenResponse.getToken());
            this.securityTokenManager.setIncrementor(tokenResponse.getIncrementor());
        }
        return tokenResponse;
    }

    public BioVerifyResponse verifyBiometrics(BioVerifyRequest bioVerifyRequest, boolean rdDeviceSelected) throws IOException {
        if (rdDeviceSelected) {
            BioVerifyResponse bioVerifyResponse = (BioVerifyResponse)this.doPostEncrypted("/uidclientintegrationserver/verifyBio25", bioVerifyRequest, String.valueOf(this.securityTokenManager.getToken()), BioVerifyResponse.class);
            this.securityTokenManager.incrementToken();
            return bioVerifyResponse;
        }
        BioVerifyResponse bioVerifyResponse = (BioVerifyResponse)this.doPostEncrypted("/uidclientintegrationserver/verifyBio", bioVerifyRequest, String.valueOf(this.securityTokenManager.getToken()), BioVerifyResponse.class);
        this.securityTokenManager.incrementToken();
        return bioVerifyResponse;
    }

    public CidOtpResponse registrationOtpVerify(CidOtpRequest cidOtpRequest) throws IOException {
        return (CidOtpResponse)this.doPostEncrypted("/uidclientintegrationserver/cidOtp25", cidOtpRequest, String.valueOf(this.securityTokenManager.getToken()), CidOtpResponse.class);
    }

    public ApiResponseMessage makeFindAadhaarRequest(FindAadhaarRequest findAadhaarRequest) throws IOException {
        return (ApiResponseMessage)this.doPostEncrypted("/ecmp/findaadhaar", findAadhaarRequest, this.tokenDAO.getToken("PACKET_STATUS_API"), null);
    }

    public RegisterStationResponse makeRegistrationRequest(String userName, String password, RegisterStationRequest request) throws IOException {
        String url = "/admin/enrolmentagency/V1/" + this.clientInformation.getAgencyId();
        request.setTimestamp(CommonUtils.getXMLTimeStamp());
        request.setSecurityParameters(this.getSecurityParams(userName, password));
        try {
            return (RegisterStationResponse)this.doPostXML(request, url, RegisterStationResponse.class);
        }
        catch (EcmpApiException e) {
            throw new EcmpApiException("Client Registration failed", e);
        }
    }

    public DeRegisterStationResponse deregisterClient(DeRegisterStationRequest request) throws IOException {
        request.setTimestamp(CommonUtils.getXMLTimeStamp());
        return (DeRegisterStationResponse)this.doPostXML(request, "/admin/deregistration/enrolmentagency/station", DeRegisterStationResponse.class);
    }

    public PreSyncResponse preSyncClient(PreSyncRequest preSyncRequest) throws IOException {
        preSyncRequest.setTimestamp(CommonUtils.getXMLTimeStamp());
        return (PreSyncResponse)this.doPostXML(preSyncRequest, "/admin/presync/config/params", PreSyncResponse.class);
    }

    public String getRegisteredDeviceType(String dpId, String rdsId, String rdsVer, String mi) {
        try {
            URIBuilder ub = new URIBuilder("/ecmp/registereddevice/type");
            ub.addParameter("dpId", dpId);
            ub.addParameter("rdsId", rdsId);
            ub.addParameter("rdsVer", rdsVer);
            ub.addParameter("mi", mi);
            HttpResponse httpResponse = this.doGet(ub.toString());
            int execStatus = httpResponse.getStatusLine().getStatusCode();
            LOGGER.info("Status received from server for getting registered device type: " + execStatus);
            ObjectMapper objectMapper = new ObjectMapper();
            if (200 == execStatus) {
                RegisteredDeviceType deviceType = (RegisteredDeviceType)objectMapper.readValue(httpResponse.getEntity().getContent(), RegisteredDeviceType.class);
                return deviceType.getDeviceType();
            }
            RegisteredDeviceTypeError error = (RegisteredDeviceTypeError)objectMapper.readValue(httpResponse.getEntity().getContent(), RegisteredDeviceTypeError.class);
            throw new EcmpApiException("Get Registered Device type request failed. Error: " + error.getErrorName());
        }
        catch (IOException | URISyntaxException e) {
            throw new EcmpApiException(e.getMessage(), e);
        }
    }

    public SessionValidationResponse validateSessionRequest(EcmpRequest request, String sessionKey) throws IOException {
        return (SessionValidationResponse)this.doPostJson("/ecmp/session/verify", request, SessionValidationResponse.class, sessionKey);
    }

    public SessionLogoutResponse doSessionLogout(EcmpRequest request, String sessionKey) throws IOException {
        return (SessionLogoutResponse)this.doPostJson("/ecmp/session/logout", request, SessionLogoutResponse.class, sessionKey);
    }

    public MandatoryBiometricCheckResponse doMandatoryBiometricCheck(EcmpRequest request) throws IOException {
        return (MandatoryBiometricCheckResponse)this.doPostJson("/ecmp/mandatorybiometriccheckV2", request, MandatoryBiometricCheckResponse.class);
    }

    public UidStatusCheckResponse doUpdateContCheck(EcmpRequest request) throws IOException {
        return (UidStatusCheckResponse)this.doPostJson("/ecmp/StatusSearchUpdateCount", request, UidStatusCheckResponse.class);
    }

    public DisclosureResponse makeDisclosureRequest(DisclosureRequest request) throws IOException {
        LOGGER.info("DR Request :::: " + request.getAllGeneratedEids() + "," + request.getRegistrarId() + "," + request.getAgencyCode() + "," + request.getStationId() + "," + request.getMachineId() + "," + request.getOperatorId() + "" + request.getDisclosedPackets());
        String url = "/ecmp/enrolment/uploadedpacketcount";
        LOGGER.info("DR Request :::: " + request.getAllGeneratedEids() + "," + request.getRegistrarId() + "," + request.getAgencyCode() + "," + request.getStationId() + "," + request.getMachineId() + "," + request.getOperatorId() + "" + request.getDisclosedPackets());
        try {
            return (DisclosureResponse)this.doPostJson(url, request, DisclosureResponse.class);
        }
        catch (EcmpApiException e) {
            throw new EcmpApiException("Disclosure Request failed", e);
        }
    }

    public void doPostStationRegistrationHelperInfo(StationRegistrationHelperRequest request) {
        String url = "/ecmp/station/TEMSubmit";
        try {
            this.doPostJson(url, request);
        }
        catch (EcmpApiException | IOException e) {
            LOGGER.error("Unable to post registration helper information", (Throwable)e);
        }
    }

    public void doUpdateInfo() {
        try {
            this.initUpdateInfo("/ecmp/station/tpmUpdatePayloadKey");
        }
        catch (Exception e) {
            LOGGER.error("Unable to update core connect info", (Throwable)e);
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.setServiceUrls(this.cidrPreference.getEcmpServicesUrl(), this.gatewayPreference.getOAuthGWServicesUrl());
        this.setDistributionKey(new DistributionKeyProviderImpl().getKey());
    }

    public EnrollmentUploadResponse uploadEnrollmentData(OnlineEnrollmentRequest onlineEnrollmentRequest, String sessionKey) throws IOException {
        return (EnrollmentUploadResponse)this.doPostJson("/oes/enrollment", onlineEnrollmentRequest, EnrollmentUploadResponse.class, sessionKey);
    }

    public DocArchivalGetDocumentDetailsAPIResponse makeDocArchivalApiCall(DocArchivalDataReadReq request) throws IOException {
        String url = "/ecmp/docupdatestatus/getDocumentUpdateStatus/?uid=" + request.getId();
        try {
            return (DocArchivalGetDocumentDetailsAPIResponse)this.doDocPostXML(request, url, DocArchivalGetDocumentDetailsAPIResponse.class);
        }
        catch (EcmpApiException e) {
            throw new EcmpApiException("DocArchival Request failed", e);
        }
    }

    public GpsValidationResponse makeGPSValidationApiCall(GpsDataReadReq request) throws IOException {
        String url = "/ecmp/longitudeLatitude/getLongitudeLatitude?lat=" + request.getLatitude() + "&long=" + request.getLongitude();
        try {
            return (GpsValidationResponse)this.doGPSPostXML(request, url, GpsValidationResponse.class);
        }
        catch (EcmpApiException e) {
            throw new EcmpApiException("GPS Validation Request failed", e);
        }
    }
}

