/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ecmpapi;

import com.fasterxml.jackson.databind.ObjectMapper;
import in.gov.uidai.ec.ecmpapi.AuthResponseDecryptorImpl;
import in.gov.uidai.ec.ecmpapi.CIDRCredentials;
import in.gov.uidai.ec.ecmpapi.ClientInformation;
import in.gov.uidai.ec.ecmpapi.CommonUtils;
import in.gov.uidai.ec.ecmpapi.EcmpApiConstants;
import in.gov.uidai.ec.ecmpapi.EcmpApiException;
import in.gov.uidai.ec.ecmpapi.EcmpApiHashGenerator;
import in.gov.uidai.ec.ecmpapi.EcmpRequest;
import in.gov.uidai.ec.ecmpapi.HttpConnection;
import in.gov.uidai.ec.ecmpapi.RequestEncryptionHelper;
import in.gov.uidai.ec.ecmpapi.json.StationRegistrationHelperRequest;
import in.gov.uidai.ec.ecmpapi.xml.Gps.GpsValidationResponse;
import in.gov.uidai.ec.ecmpapi.xml.api.ApiRequestMessage;
import in.gov.uidai.ec.ecmpapi.xml.api.ApiResponseMessage;
import in.gov.uidai.ec.ecmpapi.xml.api.ApiSessionData;
import in.gov.uidai.ec.ecmpapi.xml.api.Result;
import in.gov.uidai.ec.ecmpapi.xml.disclosure.DisclosureResponse;
import in.gov.uidai.ec.ecmpapi.xml.docarchival.DocArchivalGetDocumentDetailsAPIResponse;
import in.gov.uidai.ec.ecmpapi.xml.operatorsync.OperatorCenterSyncResponse;
import in.gov.uidai.ec.ecmpapi.xml.security.SecurityParameters;
import in.gov.uidai.ec.ecmpapi.xml.stationregister.RegistrationSecurityParameters;
import in.gov.uidai.ec.oauthapi.ProxyConfiguration;
import in.gov.uidai.ec.oauthapi.exception.ErrorCodes;
import in.gov.uidai.ec.security.impl.SecureCommunicationBridge;
import in.gov.uidai.ec.telemetry.ConnectionTypeDetector;
import in.gov.uidai.ec.telemetry.TelemetryHttpRequestModel;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Instant;
import java.util.UUID;
import javax.xml.bind.JAXB;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EcmpRequestHandler
implements EcmpApiConstants {
    private static final Logger LOGGER = LoggerFactory.getLogger(EcmpRequestHandler.class);
    ClientInformation clientInformation;
    private String distributionKey;
    private String ecmpServicesUrl;
    private String oAuthGWServicesUrl;
    private static final String VERSION = "3.0";

    EcmpRequestHandler() {
    }

    public void setDistributionKey(String distributionKey) {
        this.distributionKey = distributionKey;
    }

    public void setClientInformation(ClientInformation clientInformation) {
        this.clientInformation = clientInformation;
    }

    public void setServiceUrls(String ecmpServicesUrl, String oAuthGWServicesUrl) {
        this.ecmpServicesUrl = ecmpServicesUrl;
        this.oAuthGWServicesUrl = oAuthGWServicesUrl;
    }

    Object doPostEncrypted(String url, EcmpRequest ecmpRequest, String token, Class<?> decryptedResponseClass) throws IOException {
        String reqParams;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        JAXB.marshal((Object)ecmpRequest, (OutputStream)outputStream);
        byte[] sessionKey = RequestEncryptionHelper.generateSecretKey();
        byte[] apiData = RequestEncryptionHelper.encryptRequest(outputStream, sessionKey);
        String checksum = new EcmpApiHashGenerator().generateHashHexString(apiData);
        ApiRequestMessage apiRequestMessage = new ApiRequestMessage();
        apiRequestMessage.setSecurityParameters(this.getEncryptedSecurityParameters(checksum, token, sessionKey));
        apiRequestMessage.setData(apiData);
        apiRequestMessage.setTimestamp(CommonUtils.getXMLTimeStamp());
        apiRequestMessage.addHeader("X-Client-Identification", this.clientInformation.toString());
        apiRequestMessage.addHeader("X-Response-Key", new String(Base64.encodeBase64((byte[])sessionKey)));
        String deviceType = ecmpRequest.getHeader().get("X-Request-Device-Type");
        if (deviceType != null) {
            apiRequestMessage.addHeader("X-Request-Device-Type", deviceType);
        }
        if ((reqParams = ecmpRequest.getRequestParams()) != null) {
            apiRequestMessage.addHeader("X-Request-Params", reqParams);
        }
        HttpConnection httpConnection = new HttpConnection(ApiResponseMessage.class, this.distributionKey, this.ecmpServicesUrl + url);
        LOGGER.info("ECMP URL :- " + this.ecmpServicesUrl + url);
        HttpResponse httpResponse = httpConnection.processXMLRequest(apiRequestMessage);
        httpConnection.processResponseStatus(httpResponse);
        Object processRequest = httpConnection.convertResponseXMLToObject(httpResponse);
        if (processRequest instanceof ApiResponseMessage && decryptedResponseClass != null) {
            processRequest = this.decryptResponse((ApiResponseMessage)processRequest, decryptedResponseClass, sessionKey);
            if (decryptedResponseClass == OperatorCenterSyncResponse.class) {
                ApiSessionData apiSessionData = null;
                Header sessionDataHeader = httpResponse.getFirstHeader("X-Server-SessionDetails");
                if (sessionDataHeader != null) {
                    ObjectMapper mapper = new ObjectMapper();
                    apiSessionData = (ApiSessionData)mapper.readValue(sessionDataHeader.getValue(), ApiSessionData.class);
                }
                ((OperatorCenterSyncResponse)processRequest).setSessionData(apiSessionData);
            }
        }
        return processRequest;
    }

    HttpResponse doGet(String url) throws IOException {
        EcmpRequest request = new EcmpRequest();
        request.addHeader("X-Client-Identification", this.clientInformation.toString());
        HttpConnection httpConnection = new HttpConnection(this.distributionKey, this.ecmpServicesUrl + url);
        LOGGER.info("ECMP URL for RD: " + this.ecmpServicesUrl + url);
        return httpConnection.submitGetRequest(request);
    }

    Object doPostXML(EcmpRequest request, String url, Class<?> responseType) throws IOException {
        String xClientIdentification = this.clientInformation.toString();
        HttpConnection httpConnection = new HttpConnection(responseType, this.distributionKey, this.ecmpServicesUrl + url);
        LOGGER.info("ECMP URL for Presync : " + this.ecmpServicesUrl + url);
        request.addHeader("X-Client-Identification", xClientIdentification);
        HttpResponse httpResponse = httpConnection.processXMLRequest(request);
        httpConnection.processResponseStatus(httpResponse);
        return httpConnection.convertResponseXMLToObject(httpResponse);
    }

    Object doPostJson(String url, EcmpRequest ecmpRequest, Class<?> responseType, String sessionKey) throws IOException {
        HttpConnection httpConnection = new HttpConnection(responseType, this.distributionKey, this.ecmpServicesUrl + url, sessionKey);
        ecmpRequest.addHeader("X-Client-Identification", this.clientInformation.toString());
        HttpResponse httpResponse = httpConnection.processJsonRequest(ecmpRequest);
        LOGGER.info("status received from server : " + httpResponse.getStatusLine().getStatusCode());
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            return objectMapper.readValue(httpResponse.getEntity().getContent(), responseType);
        }
        catch (IOException e) {
            throw new EcmpApiException("Failed to obtain response from server. Please try again", e);
        }
    }

    void doPostJson(String url, StationRegistrationHelperRequest ecmpRequest) throws IOException {
        HttpConnection httpConnection = new HttpConnection(this.distributionKey, this.ecmpServicesUrl + url);
        ecmpRequest.addHeader("X-Client-Identification", this.clientInformation.toString());
        HttpResponse httpResponse = httpConnection.processJsonRequest(ecmpRequest, ecmpRequest.getMessage());
        LOGGER.info("status received from server : " + httpResponse.getStatusLine().getStatusCode());
    }

    void doPostJson(String url, TelemetryHttpRequestModel.LogDataEcmpRequest ecmpRequest) throws IOException {
        HttpConnection httpConnection = new HttpConnection(this.distributionKey, this.oAuthGWServicesUrl + url);
        ecmpRequest.addHeader("X-Client-Identification", this.clientInformation.toString());
        ecmpRequest.addHeader("X-Request-Id", UUID.randomUUID().toString());
        HttpResponse httpResponse = httpConnection.processJsonRequest(ecmpRequest, ecmpRequest.getMessage());
        LOGGER.info("status received from server : " + httpResponse.getStatusLine().getStatusCode());
    }

    Object doPostJson(String url, EcmpRequest ecmpRequest, Class<?> responseType) throws IOException {
        HttpConnection httpConnection = new HttpConnection(responseType, this.distributionKey, this.ecmpServicesUrl + url);
        ecmpRequest.addHeader("X-Client-Identification", this.clientInformation.toString());
        ecmpRequest.addHeader("X-OSD-Version", "V2");
        ecmpRequest.addHeader("Content-Type", ContentType.APPLICATION_JSON.getMimeType());
        HttpResponse httpResponse = httpConnection.processJsonRequest(ecmpRequest);
        LOGGER.info("status received from server : " + httpResponse.getStatusLine().getStatusCode());
        LOGGER.info("JSON Content Data :::: " + httpResponse.getEntity().getContent());
        HttpEntity entity = httpResponse.getEntity();
        String body = EntityUtils.toString((HttpEntity)entity);
        StringEntity newEntity = new StringEntity(body, ContentType.get((HttpEntity)entity));
        httpResponse.setEntity((HttpEntity)newEntity);
        InputStream inputStream = httpResponse.getEntity().getContent();
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            if (responseType.isAssignableFrom(DisclosureResponse.class)) {
                DisclosureResponse response = new DisclosureResponse();
                response.setCode(String.valueOf(httpResponse.getStatusLine().getStatusCode()));
                if (httpResponse.getStatusLine().getStatusCode() == 200) {
                    response.setMessage("OK");
                } else if (httpResponse.getStatusLine().getStatusCode() == 500) {
                    response.setMessage("Internet Connectivity Failed with error : " + httpResponse.getStatusLine().getStatusCode());
                } else {
                    response.setMessage("Unable perform Operator Disclosure with error : " + httpResponse.getStatusLine().getStatusCode());
                }
                return response;
            }
            if (httpResponse.getStatusLine().getStatusCode() == 200) {
                return objectMapper.readValue(httpResponse.getEntity().getContent(), responseType);
            }
            return new Object();
        }
        catch (IOException e) {
            LOGGER.error("Error : ", (Throwable)e);
            throw new EcmpApiException("Failed to obtain response from server. Please try again", e);
        }
    }

    public void initUpdateInfo(String endpoint) {
        String url = this.ecmpServicesUrl + endpoint;
        String clientInfoHeader = this.clientInformation.toString();
        String proxyUrl = ProxyConfiguration.getProxyUrl();
        String errorString = SecureCommunicationBridge.getInstance().initializeClient(url, clientInfoHeader, proxyUrl != null ? proxyUrl : "");
        if (errorString != null && !errorString.isEmpty()) {
            try {
                RuntimeException e = new RuntimeException(errorString);
                TelemetryHttpRequestModel.LogDataRequest request = this.createTelemetryHttpLogRequest(errorString, ErrorCodes.UC_GEN_190.getErrorCode(), e);
                TelemetryHttpRequestModel.LogDataEcmpRequest req = new TelemetryHttpRequestModel.LogDataEcmpRequest(new ObjectMapper().writeValueAsString((Object)request));
                this.doPostJson("/telemetryservice/log", req);
            }
            catch (EcmpApiException | IOException err) {
                LOGGER.error("Unable to post core connect information", (Throwable)err);
            }
        }
    }

    private TelemetryHttpRequestModel.LogDataRequest createTelemetryHttpLogRequest(String errorString, String errorCode, Exception e) {
        StringWriter trace = new StringWriter();
        PrintWriter pw = new PrintWriter(trace);
        e.printStackTrace(pw);
        return TelemetryHttpRequestModel.LogDataRequest.builder().eid(UUID.randomUUID().toString()).ver(VERSION).ets(String.valueOf(Instant.now().getEpochSecond())).mid(UUID.randomUUID().toString()).type("ERROR").edata(TelemetryHttpRequestModel.LogDataRequest.LogsEdata.builder().error(errorString).errorType(errorCode).stacktrace(trace.toString()).build()).context(TelemetryHttpRequestModel.LogDataRequest.Context.builder().channel(ConnectionTypeDetector.getConnectionType()).env("Prod").pdata(TelemetryHttpRequestModel.LogDataRequest.Pdata.builder().id(this.clientInformation.getMachineCode()).ver(this.clientInformation.getVersion()).platform(ConnectionTypeDetector.getPlatform()).build()).build()).build();
    }

    private Object decryptResponse(ApiResponseMessage responseMessage, Class<?> responseClass, byte[] sessionKey) {
        Result result = responseMessage.getResult();
        if (result == Result.FAILURE) {
            throw new EcmpApiException(responseMessage.getErrorMessage());
        }
        byte[] response = new AuthResponseDecryptorImpl().decrypt(responseMessage.getData(), sessionKey);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(response);
        try {
            return CommonUtils.unmarshal(inputStream, responseClass);
        }
        catch (JAXBException | XMLStreamException e) {
            throw new EcmpApiException("XmlParsingFailure", (Exception)e);
        }
    }

    private byte[] getEncryptedSecurityParameters(String checksum, String token, byte[] sessionKey) {
        SecurityParameters securityParameters = new SecurityParameters();
        securityParameters.setToken(token);
        securityParameters.setRegistrarCode(this.clientInformation.getRegistrarId());
        securityParameters.setAgencyCode(this.clientInformation.getAgencyId());
        securityParameters.setStationCode(this.clientInformation.getStationId());
        securityParameters.setMachineCode(this.clientInformation.getMachineCode());
        securityParameters.setChecksum(checksum);
        securityParameters.setSessionKey(sessionKey);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        JAXB.marshal((Object)securityParameters, (OutputStream)outputStream);
        return RequestEncryptionHelper.encryptRequest(outputStream, null);
    }

    RegistrationSecurityParameters getSecurityParams(String userName, String password) {
        RegistrationSecurityParameters securityParams = new RegistrationSecurityParameters();
        CIDRCredentials cred = new CIDRCredentials(userName, password);
        securityParams.setUsername(cred.getUserName());
        securityParams.setUserUid(cred.getUserName());
        securityParams.setPassword(cred.getPassword());
        securityParams.setHashcode(cred.getHash());
        return securityParams;
    }

    Object doDocPostXML(EcmpRequest request, String url, Class<?> responseType) throws IOException {
        String xClientIdentification = this.clientInformation.toString();
        HttpConnection httpConnection = new HttpConnection(responseType, this.distributionKey, this.ecmpServicesUrl + url);
        request.addHeader("X-Client-Identification", xClientIdentification);
        request.addHeader("X-Request-id", UUID.randomUUID().toString());
        request.addHeader("Content-Type", "application/xml;");
        request.addHeader("appId", "PORTAL");
        HttpResponse httpResponse = httpConnection.processXMLRequest(request);
        httpConnection.processResponseStatus(httpResponse);
        HttpEntity entity = httpResponse.getEntity();
        String responseString = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        DocArchivalGetDocumentDetailsAPIResponse response = (DocArchivalGetDocumentDetailsAPIResponse)new ObjectMapper().readValue(responseString, DocArchivalGetDocumentDetailsAPIResponse.class);
        return response;
    }

    void doPostTelemetricJson(String url, EcmpRequest ecmpRequest) throws IOException {
        HttpConnection httpConnection = new HttpConnection(String.class, this.distributionKey, url);
        ecmpRequest.addHeader("X-Client-Identification", this.clientInformation.toString());
        HttpResponse httpResponse = httpConnection.processJsonRequest(ecmpRequest);
        LOGGER.info("status received from telemetric server : " + httpResponse.getStatusLine().getStatusCode());
    }

    Object doGPSPostXML(EcmpRequest request, String url, Class<?> responseType) throws IOException {
        String xClientIdentification = this.clientInformation.toString();
        HttpConnection httpConnection = new HttpConnection(responseType, this.distributionKey, this.ecmpServicesUrl + url);
        request.addHeader("X-Client-Identification", xClientIdentification);
        HttpResponse httpResponse = httpConnection.processXMLRequest(request);
        httpConnection.processResponseStatus(httpResponse);
        HttpEntity entity = httpResponse.getEntity();
        String responseString = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        GpsValidationResponse response = (GpsValidationResponse)new ObjectMapper().readValue(responseString, GpsValidationResponse.class);
        return response;
    }
}

