/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ecmpapi;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import in.gov.uidai.ec.ecmpapi.CommonUtils;
import in.gov.uidai.ec.ecmpapi.EcmpApiBusinessException;
import in.gov.uidai.ec.ecmpapi.EcmpApiConstants;
import in.gov.uidai.ec.ecmpapi.EcmpApiException;
import in.gov.uidai.ec.ecmpapi.EcmpRequest;
import in.gov.uidai.ec.ecmpapi.ProxyConfiguration;
import in.gov.uidai.ec.ecmpapi.SessionVerificationSignatureGenerature;
import in.gov.uidai.ec.ecmpapi.VerificationSignatureGenerator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.SingleClientConnManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

class HttpConnection
implements DisposableBean,
EcmpApiConstants {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpConnection.class);
    private final String distributionKey;
    private final String requestURL;
    @Deprecated
    private final DefaultHttpClient client;
    private Class<?> responseType;
    private String sessionKey;

    HttpConnection(String distributionKey, String requestURL) {
        this.distributionKey = distributionKey;
        this.requestURL = requestURL;
        this.client = new DefaultHttpClient((ClientConnectionManager)new SingleClientConnManager());
        ProxyConfiguration.initialize(this.client);
    }

    HttpConnection(Class<?> responseType, String distributionKey, String requestURL) {
        this(distributionKey, requestURL);
        this.responseType = responseType;
    }

    HttpConnection(Class<?> responseType, String distributionKey, String requestURL, String sessionKey) {
        this(responseType, distributionKey, requestURL);
        this.sessionKey = sessionKey;
    }

    private HttpResponse submitPostRequest(EcmpRequest request, byte[] baosByteArray) throws IOException {
        return this.submitRequest((HttpRequestBase)new HttpPost(this.requestURL), request, baosByteArray);
    }

    HttpResponse submitGetRequest(EcmpRequest request) throws IOException {
        return this.submitRequest((HttpRequestBase)new HttpGet(this.requestURL), request, null);
    }

    private HttpResponse submitRequest(HttpRequestBase httpRequest, EcmpRequest request, byte[] baosByteArray) throws IOException {
        String body = "";
        if (httpRequest instanceof HttpEntityEnclosingRequestBase) {
            ByteArrayEntity ise = new ByteArrayEntity(baosByteArray);
            ((HttpEntityEnclosingRequestBase)httpRequest).setEntity((HttpEntity)ise);
            body = IOUtils.toString((InputStream)ise.getContent(), (String)StandardCharsets.UTF_8.displayName());
        }
        URI requestUri = httpRequest.getURI();
        HttpHost target = new HttpHost(requestUri.getHost(), requestUri.getPort(), requestUri.getScheme());
        this.addVerificationHeaders(httpRequest, request, body);
        if (this.sessionKey != null) {
            this.addSessionVerificationHeader(httpRequest, request, body);
            this.sessionKey = null;
        }
        this.addRequestHeaders(request, httpRequest);
        return this.client.execute(target, (HttpRequest)httpRequest);
    }

    private void addVerificationHeaders(HttpRequestBase httpRequest, EcmpRequest request, String body) {
        try {
            httpRequest.addHeader("X-Client-Verification", new VerificationSignatureGenerator().generate(body, request.getHeader().get("X-Client-Identification"), httpRequest.getURI(), this.distributionKey));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new EcmpApiException("Failed to add verification headers while processing HttpRequest ", e);
        }
    }

    private void addSessionVerificationHeader(HttpRequestBase httpRequest, EcmpRequest request, String body) {
        try {
            httpRequest.addHeader("X-Session-Verification", new SessionVerificationSignatureGenerature().generate(body, this.sessionKey));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new EcmpApiException("Failed to add verification headers while processing HttpRequest ", e);
        }
    }

    private void addRequestHeaders(EcmpRequest request, HttpRequestBase httpRequest) {
        HashMap<String, String> headers = request.getHeader();
        headers.keySet().forEach(key -> httpRequest.addHeader(key, (String)headers.get(key)));
    }

    HttpResponse processXMLRequest(EcmpRequest request) throws IOException {
        HttpResponse httpResponse;
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            this.convertRequestObjectToXML(request, baos);
            httpResponse = this.submitPostRequest(request, baos.toByteArray());
        }
        return httpResponse;
    }

    HttpResponse processJsonRequest(EcmpRequest request) throws IOException {
        byte[] requestJSONBytes = this.getObjectWriter().writeValueAsBytes((Object)request);
        return this.submitPostRequest(request, requestJSONBytes);
    }

    HttpResponse processJsonRequest(EcmpRequest request, String body) throws IOException {
        byte[] requestJSONBytes = body.getBytes();
        return this.submitPostRequest(request, requestJSONBytes);
    }

    private ObjectWriter getObjectWriter() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        return objectMapper.writer().withDefaultPrettyPrinter();
    }

    void processResponseStatus(HttpResponse response) {
        int execStatus = response.getStatusLine().getStatusCode();
        LOGGER.info("Status received from server : " + execStatus);
        if (422 == execStatus) {
            Header ivsError = response.getFirstHeader("X-IVS-Error");
            if (ivsError == null) {
                throw new EcmpApiBusinessException("Client Distribution key verification failed");
            }
            String apiServerError = ivsError.getValue();
            if (!StringUtils.isBlank((String)apiServerError)) {
                throw new EcmpApiBusinessException(apiServerError);
            }
        }
        if (execStatus != 200) {
            throw new EcmpApiException("Connection Failure");
        }
    }

    private void convertRequestObjectToXML(Object request, ByteArrayOutputStream baos) {
        XmlType xmlType = request.getClass().getAnnotation(XmlType.class);
        JAXBElement authElement = new JAXBElement(new QName(xmlType.namespace(), xmlType.name()), request.getClass(), request);
        try {
            JAXBContext.newInstance((Class[])new Class[]{request.getClass()}).createMarshaller().marshal((Object)authElement, (OutputStream)baos);
        }
        catch (JAXBException e) {
            throw new EcmpApiException("XmlCreationFailure", (Exception)((Object)e));
        }
    }

    Object convertResponseXMLToObject(HttpResponse response) throws IOException {
        Object retObj;
        try {
            retObj = CommonUtils.unmarshal(response.getEntity().getContent(), this.responseType);
        }
        catch (JAXBException | XMLStreamException e) {
            throw new EcmpApiException("XmlParsingFailure", (Exception)e);
        }
        this.destroy();
        return retObj;
    }

    public void destroy() {
        this.client.clearRequestInterceptors();
        this.client.getConnectionManager().closeExpiredConnections();
        this.client.getConnectionManager().shutdown();
    }
}

