/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ecmpapi;

import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.DefaultHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProxyConfiguration.class);

    public static void initialize(DefaultHttpClient client) {
        Properties proxyProps = new Properties();
        try {
            FileInputStream fis = new FileInputStream(new File("./conf/proxy.properties"));
            proxyProps.load(fis);
            fis.close();
        }
        catch (Exception e) {
            LOGGER.warn("Failed to load Proxy properties");
        }
        String proxy = proxyProps.getProperty("custom.proxy.ip");
        String port = proxyProps.getProperty("custom.port");
        String proxyUserName = proxyProps.getProperty("custom.proxy.userName");
        String proxyUserPwd = proxyProps.getProperty("custom.proxy.userpwd");
        if (!StringUtils.isBlank((String)proxy) && !StringUtils.isBlank((String)port) && client.getParams().getParameter("http.route.default-proxy") == null) {
            HttpHost proxyHost = new HttpHost(proxy.trim(), Integer.parseInt(port.trim()));
            client.getParams().setParameter("http.route.default-proxy", (Object)proxyHost);
            if (!StringUtils.isBlank((String)proxyUserName.trim()) && !StringUtils.isBlank((String)proxyUserPwd.trim())) {
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(proxyUserName.trim(), proxyUserPwd);
                AuthScope authScope = new AuthScope(proxy.trim(), Integer.parseInt(port.trim()));
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(authScope, (Credentials)credentials);
                client.setCredentialsProvider((CredentialsProvider)credentialsProvider);
            }
        }
    }
}

