/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ecmpapi;

import in.gov.uidai.ec.ecmpapi.EcmpApiException;
import in.gov.uidai.ec.ecmpapi.EcmpApiSecurityConstants;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.bouncycastle.util.encoders.Base64;

class PublicKeysHolder
implements EcmpApiSecurityConstants {
    private static PublicKeysHolder keysHolder;
    private PublicKeys[] publicKeys;
    private int noOfKeys;
    private static final String FILE_NAME = "cidr/PublicKeys.cer";

    private PublicKeysHolder(PublicKeys[] _publicKeys) {
        this.publicKeys = _publicKeys;
        this.noOfKeys = _publicKeys.length;
    }

    static PublicKeysHolder getInstance() {
        if (keysHolder == null) {
            keysHolder = new PublicKeysHolder(PublicKeysHolder.readNewKeysFromFile());
        }
        return keysHolder;
    }

    private static PublicKeys[] readNewKeysFromFile() {
        InputStream fileStream = null;
        BufferedReader reader = null;
        try {
            String line;
            fileStream = ClassLoader.getSystemResourceAsStream(FILE_NAME);
            if (fileStream == null) {
                throw new EcmpApiException("security-errors:noKeyFile");
            }
            if (fileStream.available() == 0) {
                throw new EcmpApiException("security-errors:emptyKeyFile");
            }
            reader = new BufferedReader(new InputStreamReader(fileStream));
            ArrayList<PublicKeys> keys = new ArrayList<PublicKeys>();
            int i = 0;
            while ((line = reader.readLine()) != null) {
                byte[] key = Base64.decode((String)line.trim());
                keys.add(new PublicKeys(key, i++));
            }
            PublicKeys[] publicKeysArray = keys.toArray(new PublicKeys[0]);
            return publicKeysArray;
        }
        catch (IOException e) {
            throw new EcmpApiException("security-errors:keyFileReadError");
        }
        finally {
            if (fileStream != null) {
                try {
                    fileStream.close();
                }
                catch (IOException e) {
                    throw new EcmpApiException("security-errors:keyFileClosed");
                }
            }
            fileStream = null;
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    throw new EcmpApiException("security-errors:keyFileClosed");
                }
            }
            reader = null;
        }
    }

    public int getNoOfKeys() {
        return this.noOfKeys;
    }

    public byte[] getPublicKey(int index) {
        if (index > this.noOfKeys) {
            throw new EcmpApiException("security-errors:invalid Index");
        }
        return this.publicKeys[index].getPublicKey();
    }

    private static class PublicKeys {
        private final byte[] publicKey;
        private final int index;

        public PublicKeys(byte[] publicKey, int index) {
            this.publicKey = new byte[publicKey.length];
            System.arraycopy(publicKey, 0, this.publicKey, 0, publicKey.length);
            this.index = index;
        }

        public byte[] getPublicKey() {
            return this.publicKey;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

