/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ecmpapi;

import in.gov.uidai.ec.ecmpapi.CIDREncryptorImpl;
import in.gov.uidai.ec.ecmpapi.EcmpApiException;
import in.gov.uidai.ec.ecmpapi.EcmpApiHashGenerator;
import in.gov.uidai.ec.ecmpapi.EcmpApiSecurityConstants;
import in.gov.uidai.ec.ecmpapi.Utility;
import java.io.ByteArrayOutputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.SecureRandom;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.modes.CFBBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestEncryptionHelper
implements EcmpApiSecurityConstants {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestEncryptionHelper.class);

    public static byte[] encryptRequest(ByteArrayOutputStream outputStream, byte[] secretKey) {
        if (secretKey == null) {
            secretKey = RequestEncryptionHelper.generateSecretKey();
        }
        byte[] plainText = outputStream.toByteArray();
        byte[] publicKey = new CIDREncryptorImpl().getPublicKey();
        return RequestEncryptionHelper.encrypt(plainText, publicKey, secretKey);
    }

    static byte[] generateSecretKey() {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES", "BC");
            keyGenerator.init(256);
            SecretKey secretKey = keyGenerator.generateKey();
            return secretKey.getEncoded();
        }
        catch (GeneralSecurityException e) {
            throw new EcmpApiException("security-errors:noAes");
        }
    }

    private static byte[] encrypt(byte[] plainText, byte[] publicKey, byte[] secretKey) {
        if (Utility.length(plainText) == 0) {
            throw new EcmpApiException("security-errors:nullInputData");
        }
        SecureRandom random = Utility.generateRandom();
        byte[] eid = new EcmpApiHashGenerator().generateHash(((Object)random).toString().getBytes());
        byte[] byteCipherText = RequestEncryptionHelper.encryptAES(plainText, eid, secretKey);
        byte[] rsaData = RequestEncryptionHelper.encryptRSA(secretKey, eid, publicKey);
        byte[] mergedData = Utility.mergeStream(byteCipherText, rsaData);
        byte[] mergedDataEid = Utility.mergeStream(mergedData, eid);
        byte[] encryptedData = Utility.mergeStream(mergedDataEid, publicKey);
        byte[] hashEncryptedData = new EcmpApiHashGenerator().generateHash(encryptedData);
        byte[] mergedHEncryptedHash = Utility.mergeStream(encryptedData, hashEncryptedData);
        return Utility.mergeStream(mergedHEncryptedHash, HEADER1_DATA);
    }

    private static byte[] encryptAES(byte[] plainText, byte[] eid, byte[] rawSecretKey) {
        try {
            byte[][] eidSplit = Utility.split(eid, 16);
            byte[] iv = eidSplit[0];
            BufferedBlockCipher cipher = new BufferedBlockCipher((BlockCipher)new CFBBlockCipher((BlockCipher)new AESEngine(), 128));
            KeyParameter key = new KeyParameter(rawSecretKey);
            cipher.init(true, (CipherParameters)new ParametersWithIV((CipherParameters)key, iv));
            byte[] mergedData = Utility.mergeStream(plainText, new EcmpApiHashGenerator().generateHash(plainText));
            int outputSize = cipher.getOutputSize(mergedData.length);
            byte[] result = new byte[outputSize];
            int processLen = cipher.processBytes(mergedData, 0, mergedData.length, result, 0);
            cipher.doFinal(result, processLen);
            return result;
        }
        catch (InvalidCipherTextException e) {
            throw new EcmpApiException("security-errors:aesEncryptionError");
        }
    }

    private static byte[] encryptRSA(byte[] secretKey, byte[] eid, byte[] publicKey) {
        try {
            KeyFactory kf = KeyFactory.getInstance("RSA", "BC");
            X509EncodedKeySpec pubSpec = new X509EncodedKeySpec(publicKey);
            RSAPublicKey pubKey = (RSAPublicKey)kf.generatePublic(pubSpec);
            Cipher rsa = Cipher.getInstance("RSA/ECB/OAEPWITHSHA-256ANDMGF1PADDING", "BC");
            PSource.PSpecified pSrc = new PSource.PSpecified(eid);
            rsa.init(1, (Key)pubKey, new OAEPParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA256, pSrc));
            return rsa.doFinal(secretKey);
        }
        catch (GeneralSecurityException e) {
            throw new EcmpApiException("security-errors:rsaEncryptionError");
        }
    }
}

