/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ecmpapi;

import in.gov.uidai.ec.ecmpapi.SignatureGenerationData;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class SessionVerificationSignatureGenerature {
    String generate(String body, String sessionKey) throws NoSuchAlgorithmException, InvalidKeyException {
        Hashtable<String, Object> params = new Hashtable<String, Object>();
        ((Dictionary)params).put("sessionKey", sessionKey);
        ((Dictionary)params).put("body", body);
        return this.generateSignature(new SignatureGenerationData(params));
    }

    private boolean validate(SignatureGenerationData signature) {
        Dictionary<String, Object> signatureParams = signature.getParameter();
        if (signatureParams == null || signatureParams.isEmpty()) {
            return false;
        }
        if (signatureParams.get("sessionKey") == null) {
            return false;
        }
        return signatureParams.get("body") != null;
    }

    private String generateSignature(SignatureGenerationData signatureGenerationData) throws InvalidKeyException, NoSuchAlgorithmException {
        if (!this.validate(signatureGenerationData)) {
            throw new IllegalArgumentException("signatureGenerationData is missing required parameters");
        }
        Dictionary<String, Object> signatureParams = signatureGenerationData.getParameter();
        String key = (String)signatureParams.get("sessionKey");
        String message = this.getMessage(signatureGenerationData);
        byte[] messageBytes = this.hmacsha256(key, message);
        return this.base64Encode(messageBytes);
    }

    private String base64Encode(byte[] message) {
        byte[] bytesEncoded = Base64.encodeBase64((byte[])message);
        return new String(bytesEncoded);
    }

    private byte[] hmacsha256(String secret, String message) throws NoSuchAlgorithmException, InvalidKeyException {
        String algorithm = "HmacSHA256";
        Mac sha256_HMAC = Mac.getInstance(algorithm);
        byte[] decodedKey = Base64.decodeBase64((byte[])secret.getBytes());
        SecretKeySpec secret_key = new SecretKeySpec(decodedKey, algorithm);
        sha256_HMAC.init(secret_key);
        return sha256_HMAC.doFinal(message.getBytes());
    }

    private String getMessage(SignatureGenerationData signature) {
        Dictionary<String, Object> signatureParams = signature.getParameter();
        String body = (String)signatureParams.get("body");
        return String.join((CharSequence)"", body);
    }
}

