/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ecmpapi;

import in.gov.uidai.ec.ecmpapi.EcmpApiSecurityConstants;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Utility
implements EcmpApiSecurityConstants {
    private static final Logger LOGGER = LoggerFactory.getLogger(Utility.class);

    Utility() {
    }

    static byte[] mergeStream(byte[] byte2, byte[] byte1) {
        byte[] message = new byte[byte1.length + byte2.length];
        System.arraycopy(byte1, 0, message, 0, byte1.length);
        System.arraycopy(byte2, 0, message, byte1.length, byte2.length);
        return message;
    }

    static byte[][] split(byte[] src, int n) {
        byte[] r;
        byte[] l;
        if (src == null || src.length <= n) {
            l = src;
            r = new byte[]{};
        } else {
            l = new byte[n];
            r = new byte[src.length - n];
            System.arraycopy(src, 0, l, 0, n);
            System.arraycopy(src, n, r, 0, r.length);
        }
        return new byte[][]{l, r};
    }

    static SecureRandom generateRandom() {
        SecureRandom sr = null;
        try {
            sr = SecureRandom.getInstance("SHA1PRNG");
            byte[] bytes = new byte[128];
            sr.nextBytes(bytes);
            int seedByteCount = 10;
            byte[] seed = sr.generateSeed(seedByteCount);
            sr = SecureRandom.getInstance("SHA1PRNG");
            sr.setSeed(seed);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Random Number Generation Error.");
        }
        return sr;
    }

    public static int length(byte[] byteArr) {
        return byteArr == null ? 0 : byteArr.length;
    }

    public static int length(String anyStr) {
        return anyStr == null ? 0 : anyStr.trim().length();
    }
}

