/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ecmpapi.json.onlineqc;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import in.gov.uidai.ec.ecmpapi.EcmpRequest;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class OnlineEnrollmentRequest
extends EcmpRequest {
    private String eid;
    @JsonProperty(value="demographics")
    private Demographics demographics;
    @JsonProperty(value="relation")
    private Relation relation;
    @JsonProperty(value="proofs")
    private Proofs proofs;
    @JsonProperty(value="documents")
    private List<Document> documents;

    public OnlineEnrollmentRequest(String eid) {
        this.eid = eid;
    }

    public String getEid() {
        return this.eid;
    }

    public void setEid(String eid) {
        this.eid = eid;
    }

    public Demographics getDemographics() {
        return this.demographics;
    }

    public void setDemographics(Demographics demographics) {
        this.demographics = demographics;
    }

    public Proofs getProofs() {
        return this.proofs;
    }

    public void setProofs(Proofs proofs) {
        this.proofs = proofs;
    }

    public List<Document> getDocuments() {
        return this.documents;
    }

    public void addDocument(Document document) {
        if (this.documents == null) {
            this.documents = new ArrayList<Document>();
        }
        this.documents.add(document);
    }

    public Relation getRelation() {
        return this.relation;
    }

    public void setRelation(Relation relation) {
        this.relation = relation;
    }

    public static class Document {
        private Integer scannedDocumentId;
        private Content content;
        private String name;

        public Document() {
            this.content = new Content();
        }

        public Document(Integer scannedDocumentId, Content content) {
            this.scannedDocumentId = scannedDocumentId;
            this.content = content;
        }

        public Integer getScannedDocumentId() {
            return this.scannedDocumentId;
        }

        public void setScannedDocumentId(Integer scannedDocumentId) {
            this.scannedDocumentId = scannedDocumentId;
        }

        public Content getContent() {
            return this.content;
        }

        public void setContent(Content content) {
            this.content = content;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static class Proof {
        private String proofDocumentCode;
        private Integer scannedDocumentId;

        public Proof() {
        }

        public Proof(String proofDocumentCode, Integer scannedDocumentId) {
            this.proofDocumentCode = proofDocumentCode;
            this.scannedDocumentId = scannedDocumentId;
        }

        public String getProofDocumentCode() {
            return this.proofDocumentCode;
        }

        public void setProofDocumentCode(String proofDocumentCode) {
            this.proofDocumentCode = proofDocumentCode;
        }

        public Integer getScannedDocumentId() {
            return this.scannedDocumentId;
        }

        public void setScannedDocumentId(Integer scannedDocumentId) {
            this.scannedDocumentId = scannedDocumentId;
        }
    }

    public static class Coordinate {
        Integer x;
        Integer y;

        public Coordinate() {
        }

        public Coordinate(Integer x, Integer y) {
            this.x = x;
            this.y = y;
        }

        public Integer getX() {
            return this.x;
        }

        public void setX(Integer x) {
            this.x = x;
        }

        public Integer getY() {
            return this.y;
        }

        public void setY(Integer y) {
            this.y = y;
        }
    }

    public static class Roi {
        private String labelName;
        private String fieldType;
        @JsonProperty(value="pageIndex")
        private Integer pageIndex;
        @JsonProperty(value="coordinates")
        private List<Coordinate> coordinates;

        public Roi() {
        }

        public Roi(String name, String field, String labelName, String fieldType, Integer fieldOrder, Integer pageIndex, List<Coordinate> coordinates) {
            this.labelName = labelName;
            this.fieldType = fieldType;
            this.pageIndex = pageIndex;
            this.coordinates = coordinates;
        }

        public String getLabelName() {
            return this.labelName;
        }

        public void setLabelName(String labelName) {
            this.labelName = labelName;
        }

        public String getFieldType() {
            return this.fieldType;
        }

        public void setFieldType(String fieldType) {
            this.fieldType = fieldType;
        }

        public Integer getPageIndex() {
            return this.pageIndex;
        }

        public void setPageIndex(Integer pageIndex) {
            this.pageIndex = pageIndex;
        }

        public List<Coordinate> getCoordinates() {
            return this.coordinates;
        }

        public void setCoordinates(List<Coordinate> coordinates) {
            this.coordinates = coordinates;
        }
    }

    public static class Pdf {
        private String data;
        private String hash;

        public Pdf() {
        }

        public Pdf(String data, String hash) {
            this.data = data;
            this.hash = hash;
        }

        public String getData() {
            return this.data;
        }

        public void setData(String data) {
            this.data = data;
        }

        public String getHash() {
            return this.hash;
        }

        public void setHash(String hash) {
            this.hash = hash;
        }
    }

    public static class Content {
        private Pdf pdf;
        @JsonProperty(value="rois")
        private List<Roi> rois;

        public Content() {
            this.pdf = new Pdf();
            this.rois = new ArrayList<Roi>();
        }

        public Content(Pdf pdf, List<Roi> rois) {
            this.pdf = pdf;
            this.rois = rois;
        }

        public Pdf getPdf() {
            return this.pdf;
        }

        public void setPdf(Pdf pdf) {
            this.pdf = pdf;
        }

        public List<Roi> getRois() {
            return this.rois;
        }

        public void setRois(List<Roi> rois) {
            this.rois = rois;
        }
    }

    public static class Proofs {
        private Proof poi;
        private Proof poa;
        private Proof pob;
        private Proof por;

        public Proofs() {
            this.pob = this.por = new Proof();
            this.poa = this.por;
            this.poi = this.por;
        }

        public Proofs(Proof poi, Proof poa, Proof pob, Proof por) {
            this.poi = poi;
            this.poa = poa;
            this.pob = pob;
            this.por = por;
        }

        public Proof getPoi() {
            return this.poi;
        }

        public void setPoi(Proof poi) {
            this.poi = poi;
        }

        public Proof getPoa() {
            return this.poa;
        }

        public void setPoa(Proof poa) {
            this.poa = poa;
        }

        public Proof getPob() {
            return this.pob;
        }

        public void setPob(Proof pob) {
            this.pob = pob;
        }

        public Proof getPor() {
            return this.por;
        }

        public void setPor(Proof por) {
            this.por = por;
        }
    }

    public static class Relation {
        private String name;
        private String eid;
        private String uid;

        public Relation() {
        }

        public Relation(String name, String eid, String uid) {
            this.name = name;
            this.eid = eid;
            this.uid = uid;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getEid() {
            return this.eid;
        }

        public void setEid(String eid) {
            this.eid = eid;
        }

        public String getUid() {
            return this.uid;
        }

        public void setUid(String uid) {
            this.uid = uid;
        }
    }

    public static class Address {
        private String careOf;
        private String house;
        private String street;
        private String landmark;
        private String area;
        private String city;
        private String subDistrict;
        private String district;
        private String postOffice;
        private String state;
        private String pinCode;

        public Address() {
        }

        public Address(String careOf, String house, String street, String landmark, String area, String city, String subDistrict, String district, String postOffice, String state, String pinCode) {
            this.careOf = careOf;
            this.house = house;
            this.street = street;
            this.landmark = landmark;
            this.area = area;
            this.city = city;
            this.subDistrict = subDistrict;
            this.district = district;
            this.postOffice = postOffice;
            this.state = state;
            this.pinCode = pinCode;
        }

        public String getCareOf() {
            return this.careOf;
        }

        public void setCareOf(String careOf) {
            this.careOf = careOf;
        }

        public String getHouse() {
            return this.house;
        }

        public void setHouse(String house) {
            this.house = house;
        }

        public String getStreet() {
            return this.street;
        }

        public void setStreet(String street) {
            this.street = street;
        }

        public String getLandmark() {
            return this.landmark;
        }

        public void setLandmark(String landmark) {
            this.landmark = landmark;
        }

        public String getArea() {
            return this.area;
        }

        public void setArea(String area) {
            this.area = area;
        }

        public String getCity() {
            return this.city;
        }

        public void setCity(String city) {
            this.city = city;
        }

        public String getSubDistrict() {
            return this.subDistrict;
        }

        public void setSubDistrict(String subDistrict) {
            this.subDistrict = subDistrict;
        }

        public String getDistrict() {
            return this.district;
        }

        public void setDistrict(String district) {
            this.district = district;
        }

        public String getPostOffice() {
            return this.postOffice;
        }

        public void setPostOffice(String postOffice) {
            this.postOffice = postOffice;
        }

        public String getState() {
            return this.state;
        }

        public void setState(String state) {
            this.state = state;
        }

        public String getPinCode() {
            return this.pinCode;
        }

        public void setPinCode(String pinCode) {
            this.pinCode = pinCode;
        }
    }

    public static class Demographics {
        private String name;
        private Integer age;
        private Date dob;
        @JsonProperty(value="address")
        private Address address;

        public Demographics() {
        }

        public Demographics(String name, Integer age, Date dob, Address address) {
            this.name = name;
            this.age = age;
            this.dob = dob;
            this.address = address;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Integer getAge() {
            return this.age;
        }

        public void setAge(Integer age) {
            this.age = age;
        }

        public Date getDob() {
            return this.dob;
        }

        public void setDob(Date dob) {
            this.dob = dob;
        }

        public Address getAddress() {
            return this.address;
        }

        public void setAddress(Address address) {
            this.address = address;
        }
    }
}

