/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ecmpapi.xml.telemetric;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import in.gov.uidai.ec.ecmpapi.EcmpRequest;
import in.gov.uidai.ec.ecmpapi.xml.telemetric.Actor;
import in.gov.uidai.ec.ecmpapi.xml.telemetric.Context;
import in.gov.uidai.ec.ecmpapi.xml.telemetric.Params;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class TelemetryData
extends EcmpRequest {
    private String eid;
    private String ver;
    private String ets;
    private UUID mid;
    private Actor actor;
    private Context context;
    private Map<String, Object> edata;

    public TelemetryData(String operatorId, String sid, String type, String message, String eid) {
        this.eid = eid;
        this.mid = UUID.randomUUID();
        this.actor = new Actor(operatorId);
        this.edata = new HashMap<String, Object>();
        this.edata.put("type", type);
        this.edata.put("message", "Exception : " + message);
        this.edata.put("level", "ERROR");
        Params param = new Params(type);
        ArrayList<Params> paramList = new ArrayList<Params>();
        paramList.add(param);
        this.edata.put("params", paramList);
        this.context = new Context(sid);
        this.ets = String.valueOf(Instant.now().getEpochSecond());
    }

    public TelemetryData(String operatorId, String sid, String type, String eid) {
        this.eid = eid;
        this.mid = UUID.randomUUID();
        this.actor = new Actor(operatorId);
        this.edata = new HashMap<String, Object>();
        this.edata.put(type, 1);
        this.context = new Context(sid);
        this.ets = String.valueOf(Instant.now().getEpochSecond());
    }

    public String getEid() {
        return this.eid;
    }
}

