/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.grpc;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import in.gov.uidai.ec.grpc.GrpcUtil;
import in.gov.uidai.ec.grpc.RetryConfigUtil;
import in.gov.uidai.ec.grpc.XServingDcInterceptor;
import in.gov.uidai.ec.icas.util.ApplicationVersion;
import in.gov.uidai.ec.oauthapi.OnlineGatewayException;
import in.gov.uidai.ec.oauthapi.ProxyConfiguration;
import in.gov.uidai.ec.oauthapi.exception.ErrorCodes;
import in.gov.uidai.ec.oauthapi.json.UosResponse;
import in.gov.uidai.ec.oauthapi.token.TokenManager;
import in.gov.uidai.ec.protobuf.AppointmentServiceProto;
import in.gov.uidai.ec.protobuf.BiometricMessage;
import in.gov.uidai.ec.protobuf.DocumentMessage;
import in.gov.uidai.ec.protobuf.FreighterService;
import in.gov.uidai.ec.protobuf.Mbu;
import in.gov.uidai.ec.protobuf.Rgs;
import in.gov.uidai.ec.protobuf.UcDemographicServiceProto;
import in.gov.uidai.ec.protobuf.UcDocumentServiceProto;
import in.gov.uidai.ec.protobuf.UniversalOrchestrationServiceGrpc;
import in.gov.uidai.ec.protobuf.UosProto;
import in.gov.uidai.ec.telemetry.TelemetryMetrics;
import in.gov.uidai.ec.telemetry.TelemetryService;
import in.gov.uidai.ec.ui.biologin.UserType;
import io.github.resilience4j.retry.Retry;
import io.grpc.CallCredentials;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NettyChannelBuilder;
import io.grpc.stub.StreamObserver;
import io.netty.handler.ssl.SslContext;
import java.security.Security;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.net.ssl.SSLException;
import org.conscrypt.Conscrypt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcService {
    private static final GrpcService GRPC_SERVICE = new GrpcService();
    private static final Logger LOGGER = LoggerFactory.getLogger(GrpcService.class);
    private final Map<UserType, TokenManager> tokenManagerMap = new HashMap<UserType, TokenManager>();
    private static final String GRPC_ERROR_HEADER = "UC_ERROR";
    private String transactionId;
    ManagedChannel managedChannel;
    UniversalOrchestrationServiceGrpc.UniversalOrchestrationServiceStub stub;

    public static GrpcService getInst() {
        return GRPC_SERVICE;
    }

    public void setTokenManager(TokenManager tokenManager) {
        this.tokenManagerMap.put(tokenManager.getUserType(), tokenManager);
    }

    public void removeConsentToken() {
        this.tokenManagerMap.remove((Object)UserType.RESIDENT);
        this.tokenManagerMap.remove((Object)UserType.HOF);
        this.tokenManagerMap.remove((Object)UserType.SUPERVISOR);
    }

    public void setConsentTokenManager(TokenManager tokenManager) {
        this.tokenManagerMap.put(tokenManager.getUserType(), tokenManager);
    }

    public void closeChannel() {
        if (this.managedChannel != null) {
            this.managedChannel.shutdown();
            this.managedChannel = null;
        }
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
        TelemetryService.getTelemetryServiceInstance().setTransactionId(transactionId);
    }

    private String getTransactionId() {
        if (Strings.isNullOrEmpty((String)this.transactionId)) {
            this.transactionId = UUID.randomUUID().toString();
        }
        return this.transactionId;
    }

    public void setGrpcConfigUOS(String url) {
        String ip = this.extractIpFromUrl(url);
        int port = this.extractPortFromUrl(url);
        if (this.managedChannel == null) {
            this.setupManagedChannel(ip, port);
        }
        if (this.stub == null) {
            this.stub = (UniversalOrchestrationServiceGrpc.UniversalOrchestrationServiceStub)((UniversalOrchestrationServiceGrpc.UniversalOrchestrationServiceStub)UniversalOrchestrationServiceGrpc.newStub((Channel)this.managedChannel).withCallCredentials(this.createCallCredentials())).withInterceptors(new ClientInterceptor[]{new XServingDcInterceptor()});
        }
    }

    private String extractIpFromUrl(String url) {
        return url.split(":")[1].substring(2);
    }

    private int extractPortFromUrl(String url) {
        String[] splitIp = url.split(":");
        return splitIp.length == 2 ? (splitIp[0].equals("http") ? 80 : 443) : Integer.parseInt(splitIp[2]);
    }

    private void setupManagedChannel(String ip, int port) {
        NettyChannelBuilder builder;
        if (port != 443) {
            builder = NettyChannelBuilder.forAddress((String)ip, (int)port).usePlaintext();
        } else {
            try {
                SslContext sslContext = GrpcSslContexts.forClient().protocols(new String[]{"TLSv1.3"}).build();
                builder = NettyChannelBuilder.forAddress((String)ip, (int)port).sslContext(sslContext);
            }
            catch (SSLException e) {
                TelemetryService.getTelemetryServiceInstance().postLogData(e, ErrorCodes.UC_GEN_145.getErrorCode(), new String[0]);
                throw new RuntimeException("Failed to create SSL context for UC gRPC", e);
            }
        }
        this.managedChannel = ProxyConfiguration.initialize(builder).build();
    }

    private CallCredentials createCallCredentials() {
        final Metadata.Key requestIdHeader = Metadata.Key.of((String)"X-Request-Id", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
        final Metadata.Key authorizationHeader = Metadata.Key.of((String)"Authorization", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
        final Metadata.Key cAuthorizationHeader = Metadata.Key.of((String)"cAuthorization", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
        final Metadata.Key hAuthorizationHeader = Metadata.Key.of((String)"hAuthorization", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
        final Metadata.Key sAuthorizationHeader = Metadata.Key.of((String)"sAuthorization", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
        final Metadata.Key retryCountHeader = Metadata.Key.of((String)"retry-count-tracker", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
        final Metadata.Key clientVersionHeader = Metadata.Key.of((String)"client-version", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
        return new CallCredentials(){
            private int retryCount = 1;

            public void applyRequestMetadata(CallCredentials.RequestInfo requestInfo, Executor executor, CallCredentials.MetadataApplier metadataApplier) {
                executor.execute(() -> {
                    try {
                        Metadata headers = new Metadata();
                        headers.put(requestIdHeader, (Object)GrpcService.this.getTransactionId());
                        headers.put(authorizationHeader, (Object)("Bearer " + ((TokenManager)GrpcService.this.tokenManagerMap.get((Object)UserType.OPERATOR)).getAccessToken()));
                        if (GrpcService.this.tokenManagerMap.get((Object)UserType.RESIDENT) != null && ((TokenManager)GrpcService.this.tokenManagerMap.get((Object)UserType.RESIDENT)).getAccessToken() != null && !((TokenManager)GrpcService.this.tokenManagerMap.get((Object)UserType.RESIDENT)).getAccessToken().isEmpty()) {
                            headers.put(cAuthorizationHeader, (Object)("Bearer " + ((TokenManager)GrpcService.this.tokenManagerMap.get((Object)UserType.RESIDENT)).getAccessToken()));
                        }
                        if (GrpcService.this.tokenManagerMap.get((Object)UserType.HOF) != null && ((TokenManager)GrpcService.this.tokenManagerMap.get((Object)UserType.HOF)).getAccessToken() != null && !((TokenManager)GrpcService.this.tokenManagerMap.get((Object)UserType.HOF)).getAccessToken().isEmpty()) {
                            headers.put(hAuthorizationHeader, (Object)("Bearer " + ((TokenManager)GrpcService.this.tokenManagerMap.get((Object)UserType.HOF)).getAccessToken()));
                        }
                        if (GrpcService.this.tokenManagerMap.get((Object)UserType.SUPERVISOR) != null && ((TokenManager)GrpcService.this.tokenManagerMap.get((Object)UserType.SUPERVISOR)).getAccessToken() != null && !((TokenManager)GrpcService.this.tokenManagerMap.get((Object)UserType.SUPERVISOR)).getAccessToken().isEmpty()) {
                            headers.put(sAuthorizationHeader, (Object)("Bearer " + ((TokenManager)GrpcService.this.tokenManagerMap.get((Object)UserType.SUPERVISOR)).getAccessToken()));
                        }
                        headers.put(retryCountHeader, (Object)String.valueOf(this.retryCount));
                        ++this.retryCount;
                        headers.put(clientVersionHeader, (Object)ApplicationVersion.FULLDISPLAYVERSION);
                        metadataApplier.apply(headers);
                    }
                    catch (Throwable e) {
                        metadataApplier.fail(Status.UNAUTHENTICATED.withCause(e));
                    }
                });
            }

            public void thisUsesUnstableApi() {
            }
        };
    }

    public void generateSrn(UosProto.SrnRequest srnRequest, Consumer<UcDemographicServiceProto.EnrolMetadataResponse> respConsumer, Consumer<UosResponse> errorConsumer) {
        LOGGER.info("SrnRequest payload size: {}", (Object)srnRequest.getSerializedSize());
        Retry retry = RetryConfigUtil.getRetry("generateSrnRetry");
        GrpcUtil.executeWithRetry("generateSrn", (request, responseObserver) -> this.uosStub().generateSrn((UosProto.SrnRequest)request, (StreamObserver<UcDemographicServiceProto.EnrolMetadataResponse>)responseObserver), srnRequest, respConsumer, errorConsumer, retry);
    }

    public void generateSrn(FreighterService.FlowDataWithSrnRequest srnRequest, Consumer<FreighterService.FlowDataWithSrnResponse> respConsumer, Consumer<UosResponse> errorConsumer) {
        LOGGER.info("SrnRequest payload size: {}", (Object)srnRequest.getSerializedSize());
        Retry retry = RetryConfigUtil.getRetry("generateSrnRetry");
        GrpcUtil.executeWithRetry("generateSrn", (request, responseObserver) -> this.uosStub().getFlowDataWithSrn((FreighterService.FlowDataWithSrnRequest)request, (StreamObserver<FreighterService.FlowDataWithSrnResponse>)responseObserver), srnRequest, respConsumer, errorConsumer, retry);
    }

    public void getUpdateCount(UcDemographicServiceProto.DemographicCountRequest countRequest, Consumer<UcDemographicServiceProto.DemographicCountResponse> responseConsumer, Consumer<UosResponse> errorConsumer) {
        LOGGER.info("CountRequest payload size: {}", (Object)countRequest);
        Retry retry = RetryConfigUtil.getRetry("countCallRetry");
        GrpcUtil.executeWithRetry("countCall", (request, responseObserver) -> this.uosStub().getCountCall((UcDemographicServiceProto.DemographicCountRequest)request, (StreamObserver<UcDemographicServiceProto.DemographicCountResponse>)responseObserver), countRequest, responseConsumer, errorConsumer, retry);
    }

    public void getGrievanceId(Rgs.GetGrievanceIdRequest grievanceRequest, Consumer<Rgs.GetGrievanceIdResponse> responseConsumer, Consumer<UosResponse> errorConsumer) {
        LOGGER.info("GetGrievanceId payload size: {}", (Object)grievanceRequest);
        Retry retry = RetryConfigUtil.getRetry("getGrievanceIdRetry");
        GrpcUtil.executeWithRetry("getGrievanceIdCall", (request, responseObserver) -> this.uosStub().getGrievanceId((Rgs.GetGrievanceIdRequest)request, (StreamObserver<Rgs.GetGrievanceIdResponse>)responseObserver), grievanceRequest, responseConsumer, errorConsumer, retry);
    }

    public void getProfileData(UcDemographicServiceProto.ProfileDataRequest profileRequest, Consumer<UcDemographicServiceProto.ProfileDataResponse> respConsumer, Consumer<UosResponse> errorConsumer) {
        LOGGER.info("ProfileDataRequest payload size: {}", (Object)profileRequest.getSerializedSize());
        Retry retry = RetryConfigUtil.getRetry("profileCallRetry");
        GrpcUtil.executeWithRetry("profileCall", (request, responseObserver) -> this.uosStub().getProfileCall((UcDemographicServiceProto.ProfileDataRequest)request, (StreamObserver<UcDemographicServiceProto.ProfileDataResponse>)responseObserver), profileRequest, respConsumer, errorConsumer, retry);
    }

    public void cancelDemo(UcDemographicServiceProto.CancelDemoRequest cancelDemoRequest, Consumer<UcDemographicServiceProto.CancelDemoResponse> respConsumer, Consumer<UosResponse> errorConsumer) {
        LOGGER.info("CancelDemoRequest payload size: {}", (Object)cancelDemoRequest.getSerializedSize());
        Retry retry = RetryConfigUtil.getRetry("cancelDemoDataRetry");
        GrpcUtil.executeWithRetry("cancelDemoData", (request, responseObserver) -> this.uosStub().cancelDemoData((UcDemographicServiceProto.CancelDemoRequest)request, (StreamObserver<UcDemographicServiceProto.CancelDemoResponse>)responseObserver), cancelDemoRequest, respConsumer, errorConsumer, retry);
    }

    public void uploadDemo(UcDemographicServiceProto.UpdateDemoRequest updateDemoRequest, Consumer<UcDemographicServiceProto.UpdateDemoResponse> respConsumer, Consumer<UosResponse> errorConsumer) {
        LOGGER.info("updateDemoRequest payload size: {}", (Object)updateDemoRequest.getSerializedSize());
        Retry retry = RetryConfigUtil.getRetry("updateDemoCallRetry");
        GrpcUtil.executeWithRetry("updateDemoCall", (request, responseObserver) -> this.uosStub().updateDemoCall((UcDemographicServiceProto.UpdateDemoRequest)request, (StreamObserver<UcDemographicServiceProto.UpdateDemoResponse>)responseObserver), updateDemoRequest, respConsumer, errorConsumer, retry);
    }

    public void deleteCapture(BiometricMessage.DeleteCaptureRequest deleteCaptureRequest, Consumer<BiometricMessage.DeleteCaptureResponse> respConsumer, Consumer<UosResponse> errorConsumer) {
        LOGGER.info("deleteCaptureRequest payload size: {}", (Object)deleteCaptureRequest.getSerializedSize());
        Retry retry = RetryConfigUtil.getRetry("deleteCaptureRetry");
        GrpcUtil.executeWithRetry("deleteCaptureCall", (request, responseObserver) -> this.uosStub().deleteCapture((BiometricMessage.DeleteCaptureRequest)request, (StreamObserver<BiometricMessage.DeleteCaptureResponse>)responseObserver), deleteCaptureRequest, respConsumer, errorConsumer, retry);
    }

    public void getAckSlip(UcDemographicServiceProto.AcknowledgementSlipRequest acknowledgementSlipRequest, Consumer<UcDemographicServiceProto.AcknowledgementSlipResponse> respConsumer, Consumer<UosResponse> errorConsumer) {
        LOGGER.info("acknowledgementSlipRequest payload size: {}", (Object)acknowledgementSlipRequest.getSerializedSize());
        Retry retry = RetryConfigUtil.getRetry("ackSlipCallRetry");
        GrpcUtil.executeWithRetry("ackSlipCall", (request, responseObserver) -> this.uosStub().ackSlipCall((UcDemographicServiceProto.AcknowledgementSlipRequest)request, (StreamObserver<UcDemographicServiceProto.AcknowledgementSlipResponse>)responseObserver), acknowledgementSlipRequest, respConsumer, errorConsumer, retry);
    }

    public void uploadFingerprintQss(BiometricMessage.UploadData fingerRequest, Consumer<BiometricMessage.BiometricResponse> respConsumer, Consumer<UosResponse> errorConsumer) {
        LOGGER.info("fingerRequest payload size: {}", (Object)fingerRequest.getSerializedSize());
        Retry retry = RetryConfigUtil.getRetry("fingerUploadRetry");
        GrpcUtil.executeWithRetry("fingerUpload", (request, responseObserver) -> this.uosStub().fingerUpload((BiometricMessage.UploadData)request, (StreamObserver<BiometricMessage.BiometricResponse>)responseObserver), fingerRequest, respConsumer, errorConsumer, retry);
    }

    public void uploadIrisQss(BiometricMessage.UploadData irisRequest, Consumer<BiometricMessage.BiometricResponse> respConsumer, Consumer<UosResponse> errorConsumer) {
        LOGGER.info("irisRequest payload size: {}", (Object)irisRequest.getSerializedSize());
        Retry retry = RetryConfigUtil.getRetry("irisUploadRetry");
        GrpcUtil.executeWithRetry("irisUpload", (request, responseObserver) -> this.uosStub().irisUpload((BiometricMessage.UploadData)request, (StreamObserver<BiometricMessage.BiometricResponse>)responseObserver), irisRequest, respConsumer, errorConsumer, retry);
    }

    public void uploadFaceQss(BiometricMessage.UploadData faceRequest, Consumer<BiometricMessage.BiometricResponse> respConsumer, Consumer<UosResponse> errorConsumer) {
        LOGGER.info("faceRequest payload size: {}", (Object)faceRequest.getSerializedSize());
        Retry retry = RetryConfigUtil.getRetry("faceUploadRetry");
        GrpcUtil.executeWithRetry("faceUpload", (request, responseObserver) -> this.uosStub().faceUpload((BiometricMessage.UploadData)request, (StreamObserver<BiometricMessage.BiometricResponse>)responseObserver), faceRequest, respConsumer, errorConsumer, retry);
    }

    public void uploadExceptionPhoto(BiometricMessage.UploadData exceptionPhotoRequest, Consumer<BiometricMessage.BiometricResponse> respConsumer, Consumer<UosResponse> errorConsumer) {
        LOGGER.info("exceptionPhotoRequest payload size: {}", (Object)exceptionPhotoRequest.getSerializedSize());
        Retry retry = RetryConfigUtil.getRetry("exceptionPhotoUploadRetry");
        GrpcUtil.executeWithRetry("exceptionPhotoUpload", (request, responseObserver) -> this.uosStub().exceptionPhotoUpload((BiometricMessage.UploadData)request, (StreamObserver<BiometricMessage.BiometricResponse>)responseObserver), exceptionPhotoRequest, respConsumer, errorConsumer, retry);
    }

    public void fetchDocumentDetails(String url, String transactionId, final Consumer<DocumentMessage.DocumentDetailResponse> respConsumer, final Consumer<UosResponse> errorConsumer) {
        final long startTime = System.currentTimeMillis();
        this.uosStub().getMetaData(DocumentMessage.Void.newBuilder().build(), new StreamObserver<DocumentMessage.DocumentDetailResponse>(){

            public void onNext(DocumentMessage.DocumentDetailResponse documentDetail) {
                GrpcService.this.sendLatency("getMetaData", startTime);
                respConsumer.accept(documentDetail);
            }

            public void onError(Throwable throwable) {
                LOGGER.error("getMetaData: " + throwable.getMessage());
                if (throwable.getMessage().contains("Received unexpected EOS")) {
                    return;
                }
                GrpcService.this.sendLatency("getMetaData", startTime);
                Metadata metadata = Status.trailersFromThrowable((Throwable)throwable);
                if (metadata != null) {
                    GrpcService.this.handleMetaDataErrors(metadata, errorConsumer);
                }
            }

            public void onCompleted() {
                LOGGER.info("Completed registry metadata request");
            }
        });
    }

    public void fetchRegistry(DocumentMessage.DocumentFetchRequest fetchRequest, Consumer<DocumentMessage.DocumentFetchResponse> respConsumer, Consumer<UosResponse> errorConsumer) throws OnlineGatewayException {
        LOGGER.info("DocumentFetchRequest payload size: {}", (Object)fetchRequest.getSerializedSize());
        Retry retry = RetryConfigUtil.getRetry("fetchRegistryDocumentRetry");
        GrpcUtil.executeWithRetry("fetchRegistryDocument", (request, responseObserver) -> this.uosStub().fetchRegistryDocument((DocumentMessage.DocumentFetchRequest)request, (StreamObserver<DocumentMessage.DocumentFetchResponse>)responseObserver), fetchRequest, respConsumer, errorConsumer, retry);
    }

    public void fetchAndUploadRegistry(DocumentMessage.DocumentFetchAndUploadRequest fetchRequest, Consumer<DocumentMessage.DocumentFetchAndUploadResponse> respConsumer, Consumer<UosResponse> errorConsumer) throws OnlineGatewayException {
        LOGGER.info("DocumentFetchRequest payload size: {}", (Object)fetchRequest.getSerializedSize());
        Retry retry = RetryConfigUtil.getRetry("fetchAndUploadRegistryRetry");
        GrpcUtil.executeWithRetry("fetchAndUploadRegistry", (request, responseObserver) -> this.uosStub().fetchAndUploadRegistryDocument((DocumentMessage.DocumentFetchAndUploadRequest)request, (StreamObserver<DocumentMessage.DocumentFetchAndUploadResponse>)responseObserver), fetchRequest, respConsumer, errorConsumer, retry);
    }

    public void saveDocumentWithPassportParams(UcDocumentServiceProto.PassportRequest passportRequest, Consumer<UcDocumentServiceProto.PassportValidityResponse> respConsumer, Consumer<UosResponse> errorConsumer) {
        LOGGER.info("PassportRequest payload size: {}", (Object)passportRequest.getSerializedSize());
        Retry retry = RetryConfigUtil.getRetry("saveAndVerifyPassportRetry");
        GrpcUtil.executeWithRetry("saveAndVerifyPassport", (request, responseObserver) -> this.uosStub().saveAndVerifyPassport((UcDocumentServiceProto.PassportRequest)request, (StreamObserver<UcDocumentServiceProto.PassportValidityResponse>)responseObserver), passportRequest, respConsumer, errorConsumer, retry);
    }

    public void docSaveAndValidate(UcDocumentServiceProto.DocumentStoreRequest saveRequest, Consumer<UcDocumentServiceProto.DocumentSaveResponse> respConsumer, Consumer<UosResponse> errorConsumer) throws OnlineGatewayException {
        LOGGER.info("DocumentStoreRequest payload size: {}", (Object)saveRequest.getSerializedSize());
        Retry retry = RetryConfigUtil.getRetry("saveAndValidateRetry");
        GrpcUtil.executeWithRetry("saveAndValidate", (request, responseObserver) -> this.uosStub().saveAndValidate((UcDocumentServiceProto.DocumentStoreRequest)request, (StreamObserver<UcDocumentServiceProto.DocumentSaveResponse>)responseObserver), saveRequest, respConsumer, errorConsumer, retry);
    }

    public void documentSave(UcDocumentServiceProto.DocumentUploadRequest saveRequest, Consumer<UcDocumentServiceProto.DocumentUploadResponse> respConsumer, Consumer<UosResponse> errorConsumer) throws OnlineGatewayException {
        LOGGER.info("DocumentUploadRequest payload size: {}", (Object)saveRequest.getSerializedSize());
        Retry retry = RetryConfigUtil.getRetry("documentSaveRetry");
        GrpcUtil.executeWithRetry("documentSave", (request, responseObserver) -> this.uosStub().uploadDocument((UcDocumentServiceProto.DocumentUploadRequest)request, (StreamObserver<UcDocumentServiceProto.DocumentUploadResponse>)responseObserver), saveRequest, respConsumer, errorConsumer, retry);
    }

    public void documentVerifyAndValidate(UcDocumentServiceProto.DocumentVerifyAndValidateRequest documentVerifyAndValidateRequest, Consumer<UcDocumentServiceProto.DocumentVerifyAndValidateResponse> respConsumer, Consumer<UosResponse> errorConsumer) throws OnlineGatewayException {
        LOGGER.info("DocumentVerifyAndValidateRequest payload size: {}", (Object)documentVerifyAndValidateRequest.getSerializedSize());
        Retry retry = RetryConfigUtil.getRetry("documentVerifyAndValidateRetry");
        GrpcUtil.executeWithRetry("documentVerifyAndValidate", (request, responseObserver) -> this.uosStub().verifyAndValidateDocument((UcDocumentServiceProto.DocumentVerifyAndValidateRequest)request, (StreamObserver<UcDocumentServiceProto.DocumentVerifyAndValidateResponse>)responseObserver), documentVerifyAndValidateRequest, respConsumer, errorConsumer, retry);
    }

    public void fetchAllVerifiableDocumentDetails(Consumer<DocumentMessage.VerifiableAllMetadataResponse> respConsumer, Consumer<UosResponse> errorConsumer) throws OnlineGatewayException {
        Retry retry = RetryConfigUtil.getRetry("fetchVerifiableDocumentDetailsRetry");
        GrpcUtil.executeWithRetry("fetchVerifiableDocumentDetails", (request, responseObserver) -> this.uosStub().getAllVerifiableMetadata((DocumentMessage.Void)request, (StreamObserver<DocumentMessage.VerifiableAllMetadataResponse>)responseObserver), DocumentMessage.Void.newBuilder().build(), respConsumer, errorConsumer, retry);
    }

    public void genericDocSave(UcDocumentServiceProto.DocumentGenericRequest genericDocumentRequest, Consumer<UcDocumentServiceProto.DocumentSuccessResponse> respConsumer, Consumer<UosResponse> errorConsumer) throws OnlineGatewayException {
        LOGGER.info("genericDocumentRequest payload size: {}", (Object)genericDocumentRequest.getSerializedSize());
        Retry retry = RetryConfigUtil.getRetry("saveGenericRetry");
        GrpcUtil.executeWithRetry("saveGeneric", (request, responseObserver) -> this.uosStub().saveGeneric((UcDocumentServiceProto.DocumentGenericRequest)request, (StreamObserver<UcDocumentServiceProto.DocumentSuccessResponse>)responseObserver), genericDocumentRequest, respConsumer, errorConsumer, retry);
    }

    public void mbuAvailabilityCheck(Mbu.MbuRequest mbuRequest, Consumer<Mbu.MbuResponse> responseConsumer, Consumer<UosResponse> errorConsumer) {
        LOGGER.info("Mbu Availability request payload size: {}", (Object)mbuRequest.getSerializedSize());
        Retry retry = RetryConfigUtil.getRetry("MbuAvailabilityCallRetry");
        GrpcUtil.executeWithRetry("mbuAvailabilityCheck", (request, responseObserver) -> this.uosStub().mbuCheck((Mbu.MbuRequest)request, (StreamObserver<Mbu.MbuResponse>)responseObserver), mbuRequest, responseConsumer, errorConsumer, retry);
    }

    public void getAppointmentData(AppointmentServiceProto.AppointmentRequest appointmentRequest, Consumer<AppointmentServiceProto.AppointmentResponse> respConsumer, Consumer<UosResponse> errorConsumer) throws OnlineGatewayException {
        LOGGER.info("appointmentRequest payload size: {}", (Object)appointmentRequest.getSerializedSize());
        Retry retry = RetryConfigUtil.getRetry("appointmentCallRetry");
        GrpcUtil.executeWithRetry("appointmentFetch", (request, responseObserver) -> this.uosStub().getAppointmentData((AppointmentServiceProto.AppointmentRequest)request, (StreamObserver<AppointmentServiceProto.AppointmentResponse>)responseObserver), appointmentRequest, respConsumer, errorConsumer, retry);
    }

    public void getPreferredDoc(UcDocumentServiceProto.PreferredDocRequest preferredDocRequest, Consumer<UcDocumentServiceProto.PreferredDocResponse> respConsumer, Consumer<UosResponse> errorConsumer) throws OnlineGatewayException {
        LOGGER.info("Previous/Preferred doc fetch payload size: {}", (Object)preferredDocRequest.getSerializedSize());
        Retry retry = RetryConfigUtil.getRetry("previously/Preferred doc used retry");
        GrpcUtil.executeWithRetry("getPreviousPobDocFetch", (request, responseObserver) -> this.uosStub().getPreferredDocList((UcDocumentServiceProto.PreferredDocRequest)request, (StreamObserver<UcDocumentServiceProto.PreferredDocResponse>)responseObserver), preferredDocRequest, respConsumer, errorConsumer, retry);
    }

    private UniversalOrchestrationServiceGrpc.UniversalOrchestrationServiceStub uosStub() {
        return (UniversalOrchestrationServiceGrpc.UniversalOrchestrationServiceStub)this.stub.withDeadlineAfter(60L, TimeUnit.SECONDS);
    }

    private void sendLatency(String url, long startTime) {
        long responseTime = System.currentTimeMillis() - startTime;
        String servingDc = XServingDcInterceptor.getXServingDc();
        TelemetryService.getTelemetryServiceInstance().postMetricsData(url, TelemetryMetrics.API_LATENCY, responseTime, servingDc);
    }

    private void handleMetaDataErrors(Metadata metadata, Consumer<UosResponse> errorConsumer) {
        for (String key : metadata.keys()) {
            if (!GRPC_ERROR_HEADER.equalsIgnoreCase(key)) continue;
            String errorResponse = (String)metadata.get(Metadata.Key.of((String)key, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
            try {
                errorConsumer.accept((UosResponse)new ObjectMapper().readValue(errorResponse, UosResponse.class));
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void fetchEodReportDetails(UcDemographicServiceProto.FetchEodReportDetailsRequest fetchEodReportDetailsRequest, Consumer<UcDemographicServiceProto.FetchEodReportDetailsResponse> respConsumer, Consumer<UosResponse> errorConsumer) {
        LOGGER.info("FetchEodReportDetailsRequest payload size: {}", (Object)fetchEodReportDetailsRequest.getSerializedSize());
        Retry retry = RetryConfigUtil.getRetry("fetchEodReportDetailsRetry");
        GrpcUtil.executeWithRetry("fetchEodReportDetails", (request, responseObserver) -> this.uosStub().fetchEodReportDetails((UcDemographicServiceProto.FetchEodReportDetailsRequest)request, (StreamObserver<UcDemographicServiceProto.FetchEodReportDetailsResponse>)responseObserver), fetchEodReportDetailsRequest, respConsumer, errorConsumer, retry);
    }

    static {
        Security.insertProviderAt(Conscrypt.newProvider(), 1);
    }
}

