/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.grpc;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import in.gov.uidai.ec.grpc.RetryConfigUtil;
import in.gov.uidai.ec.grpc.XServingDcInterceptor;
import in.gov.uidai.ec.oauthapi.OnlineGatewayException;
import in.gov.uidai.ec.oauthapi.exception.ErrorCodes;
import in.gov.uidai.ec.oauthapi.json.ErrorDetail;
import in.gov.uidai.ec.oauthapi.json.UosResponse;
import in.gov.uidai.ec.telemetry.TelemetryMetrics;
import in.gov.uidai.ec.telemetry.TelemetryService;
import io.github.resilience4j.retry.Retry;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Semaphore;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcUtil {
    private static final int MAX_CONCURRENT_REQUESTS = 10;
    private static final Semaphore semaphore = new Semaphore(10);
    private static final String GRPC_ERROR_HEADER = "UC_ERROR";
    private static final Logger LOGGER = LoggerFactory.getLogger(GrpcUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <ReqT, RespT> void executeWithRetry(final String operationName, GrpcCallExecutor<ReqT, RespT> grpcCallExecutor, ReqT request, final Consumer<RespT> responseConsumer, Consumer<UosResponse> errorConsumer, Retry retry) {
        RetryConfigUtil.sendRetryCount(operationName, 0L);
        Supplier<Object> supplier = () -> {
            GrpcUtil.acquirePermit();
            final long startTime = System.currentTimeMillis();
            final CompletableFuture future = new CompletableFuture();
            grpcCallExecutor.execute(request, new StreamObserver<RespT>(){

                public void onNext(RespT response) {
                    LOGGER.info("{} is success", (Object)operationName);
                    GrpcUtil.sendLatency(operationName, startTime);
                    future.complete(response);
                    responseConsumer.accept(response);
                }

                public void onError(Throwable throwable) {
                    if (throwable.getMessage() != null && throwable.getMessage().contains("Received unexpected EOS")) {
                        return;
                    }
                    LOGGER.error("{} failed.", (Object)operationName, (Object)throwable);
                    GrpcUtil.sendLatency(operationName, startTime);
                    future.completeExceptionally(throwable);
                }

                public void onCompleted() {
                    LOGGER.info("{} is completed.", (Object)operationName);
                }
            });
            try {
                Object t = future.get();
                return t;
            }
            catch (StatusRuntimeException | InterruptedException | ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof StatusRuntimeException) {
                    throw (StatusRuntimeException)cause;
                }
                throw OnlineGatewayException.getClientException(Objects.toString(e.getCause().getMessage().split(":")[0]), e.getCause().getMessage().substring(e.getCause().getMessage().indexOf(" ") + 1), "", (Exception)e);
            }
            finally {
                semaphore.release();
                XServingDcInterceptor.clearXServingDc();
            }
        };
        Supplier retryableSupplier = Retry.decorateSupplier((Retry)retry, supplier);
        try {
            retryableSupplier.get();
        }
        catch (StatusRuntimeException e) {
            Status status = e.getStatus();
            String servingDc = XServingDcInterceptor.getXServingDc();
            if (e.getStatus().getDescription() != null && e.getStatus().getDescription().contains("code 200")) {
                assert (e.getTrailers() != null);
                GrpcUtil.handleMetaDataErrors(e.getTrailers(), errorConsumer, e, servingDc);
            } else if (GrpcUtil.isGrpcError(status)) {
                TelemetryService.getTelemetryServiceInstance().postLogData((Exception)((Object)e), "UC-GRPC-" + e.getStatus().getCode().name(), servingDc);
                if (!e.getMessage().contains("Received unexpected EOS")) {
                    GrpcUtil.handleGrpcErrors(errorConsumer, e, servingDc);
                }
            } else {
                GrpcUtil.handleServiceErrors(status.getDescription(), errorConsumer, e, servingDc);
            }
        }
        finally {
            XServingDcInterceptor.clearXServingDc();
        }
    }

    private static void acquirePermit() {
        try {
            semaphore.acquire();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Backpressure limit reached: " + e.getMessage(), e);
        }
    }

    private static void handleServiceErrors(String message, Consumer<UosResponse> errorConsumer, StatusRuntimeException ex, String servingDc) {
        try {
            UosResponse response = (UosResponse)new ObjectMapper().readValue(message, UosResponse.class);
            TelemetryService.getTelemetryServiceInstance().postLogData((Exception)((Object)ex), response.getErrorCode(), servingDc);
            errorConsumer.accept(response);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private static void handleGrpcErrors(Consumer<UosResponse> errorConsumer, StatusRuntimeException exception, String servingDc) {
        ErrorDetail errorDetail = new ErrorDetail();
        String errorCode = exception.getStatus().getCode().name();
        String errorMsg = ErrorCodes.UC_NET_004.getReason();
        if ("DEADLINE_EXCEEDED".equalsIgnoreCase(errorCode)) {
            errorMsg = ErrorCodes.UC_NET_005.getReason();
        }
        errorDetail.setMessage(errorMsg);
        errorDetail.setMessageEnglish(errorMsg);
        UosResponse response = new UosResponse();
        response.setErrorDetail(errorDetail);
        response.setErrorCode("UC-GRPC-" + errorCode);
        errorConsumer.accept(response);
    }

    private static boolean isGrpcError(Status status) {
        return status.getCode().toStatus().equals((Object)Status.UNAVAILABLE) || status.getCode().toStatus().equals((Object)Status.UNIMPLEMENTED) || status.getCode().toStatus().equals((Object)Status.DEADLINE_EXCEEDED) || status.getCode().toStatus().equals((Object)Status.INTERNAL) && status.getDescription() != null && !status.getDescription().contains("message");
    }

    private static void sendLatency(String operationName, long startTime) {
        long responseTime = System.currentTimeMillis() - startTime;
        String servingDc = XServingDcInterceptor.getXServingDc();
        LOGGER.info("{} latency is {}", (Object)operationName, (Object)responseTime);
        TelemetryService.getTelemetryServiceInstance().postMetricsData(operationName, TelemetryMetrics.API_LATENCY, responseTime, servingDc);
    }

    private static void handleMetaDataErrors(Metadata metadata, Consumer<UosResponse> errorConsumer, StatusRuntimeException ex, String servingDc) {
        for (String key : metadata.keys()) {
            if (!GRPC_ERROR_HEADER.equalsIgnoreCase(key)) continue;
            String errorResponse = (String)metadata.get(Metadata.Key.of((String)key, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
            try {
                UosResponse response = (UosResponse)new ObjectMapper().readValue(errorResponse, UosResponse.class);
                TelemetryService.getTelemetryServiceInstance().postLogData((Exception)((Object)ex), response.getErrorCode(), servingDc);
                errorConsumer.accept(response);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @FunctionalInterface
    public static interface GrpcCallExecutor<ReqT, RespT> {
        public void execute(ReqT var1, StreamObserver<RespT> var2);
    }
}

