/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.grpc;

import in.gov.uidai.ec.telemetry.TelemetryMetrics;
import in.gov.uidai.ec.telemetry.TelemetryService;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryConfigUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(RetryConfigUtil.class);

    public static Retry getRetry(String name) {
        AtomicInteger retryCounter = new AtomicInteger(0);
        RetryConfig config = RetryConfig.custom().maxAttempts(3).waitDuration(Duration.ofMillis(2000L)).build();
        Retry retry = Retry.of((String)name, (RetryConfig)config);
        retry.getEventPublisher().onRetry(event -> {
            int attempt = retryCounter.incrementAndGet();
            RetryConfigUtil.sendRetryCount(name, attempt);
            LOGGER.info("Retry attempt " + attempt + " for " + event.getName() + ": " + event.getLastThrowable());
        }).onSuccess(event -> LOGGER.info("Successful after " + retryCounter.get() + " retries")).onError(event -> LOGGER.error("All retries failed for " + event.getName()));
        return retry;
    }

    public static void sendRetryCount(String operationName, long retryCount) {
        TelemetryService.getTelemetryServiceInstance().postMetricsData(operationName, TelemetryMetrics.RETRY_COUNT, retryCount, new String[0]);
    }
}

