/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.grpc;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XServingDcInterceptor
implements ClientInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(XServingDcInterceptor.class);
    private static final Metadata.Key<String> X_SERVING_DC_HEADER_KEY = Metadata.Key.of((String)"x-serving-dc", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final ThreadLocal<String> X_SERVING_DC_THREAD_LOCAL = new ThreadLocal();

    public static String getXServingDc() {
        String value = X_SERVING_DC_THREAD_LOCAL.get();
        return value != null ? value : "";
    }

    public static void clearXServingDc() {
        X_SERVING_DC_THREAD_LOCAL.remove();
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                XServingDcInterceptor.clearXServingDc();
                super.start((ClientCall.Listener)new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                    public void onHeaders(Metadata headers) {
                        String xServingDc = (String)headers.get(X_SERVING_DC_HEADER_KEY);
                        if (xServingDc != null) {
                            X_SERVING_DC_THREAD_LOCAL.set(xServingDc);
                            LOGGER.debug("Interceptor: Captured X-Serving-DC from headers: {}", (Object)xServingDc);
                        }
                        super.onHeaders(headers);
                    }

                    public void onClose(Status status, Metadata trailers) {
                        String xServingDc = (String)trailers.get(X_SERVING_DC_HEADER_KEY);
                        if (xServingDc != null && (X_SERVING_DC_THREAD_LOCAL.get() == null || ((String)X_SERVING_DC_THREAD_LOCAL.get()).isEmpty())) {
                            X_SERVING_DC_THREAD_LOCAL.set(xServingDc);
                            LOGGER.debug("Interceptor: Captured X-Serving-DC from trailers: {}", (Object)xServingDc);
                        }
                        super.onClose(status, trailers);
                        XServingDcInterceptor.clearXServingDc();
                    }
                }, headers);
            }
        };
    }
}

