/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.oauthapi;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import in.gov.uidai.ec.oauthapi.OauthGWConstants;
import in.gov.uidai.ec.oauthapi.OnlineGatewayException;
import in.gov.uidai.ec.oauthapi.ProxyConfiguration;
import in.gov.uidai.ec.oauthapi.exception.ErrorCodes;
import in.gov.uidai.ec.telemetry.TelemetryService;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class HttpConnection
implements OauthGWConstants,
DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpConnection.class);
    private final URI requestUri;
    private final CloseableHttpClient httpClient;
    private Class<?> responseType;
    private final Map<String, String> headers;
    private String transactionId;

    HttpConnection(String requestUrl, Map<String, String> pathParams, Map<String, String> queryParams, Map<String, String> headers, Class<?> responseType, boolean isJson, String transactionId) throws URISyntaxException {
        SSLContext sslContext;
        requestUrl = HttpConnection.replacePathParams(requestUrl, Optional.ofNullable(pathParams).orElse(Collections.emptyMap()));
        queryParams = Optional.ofNullable(queryParams).orElse(Collections.emptyMap());
        URIBuilder builder = new URIBuilder(requestUrl);
        queryParams.forEach((arg_0, arg_1) -> ((URIBuilder)builder).setParameter(arg_0, arg_1));
        this.requestUri = builder.build();
        this.headers = Optional.ofNullable(headers).orElse(new HashMap());
        this.headers.put("Content-Type", "application/json");
        if (!isJson) {
            this.headers.put("Content-Type", "text/plain");
        }
        this.responseType = responseType;
        this.transactionId = transactionId;
        RequestConfig config = RequestConfig.custom().setConnectTimeout(100000).setSocketTimeout(100000).build();
        try {
            sslContext = SSLContext.getDefault();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        ProxyConfiguration.initialize(httpClientBuilder);
        this.httpClient = httpClientBuilder.setDefaultRequestConfig(config).setSSLContext(sslContext).build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Object processPostRequest(Object request) throws IOException, OnlineGatewayException {
        Object object;
        byte[] requestJSONBytes;
        if (request instanceof String) {
            requestJSONBytes = ((String)request).getBytes();
        } else {
            try {
                requestJSONBytes = this.getObjectWriter().writeValueAsBytes(request);
            }
            catch (IOException e) {
                LOGGER.error("Error serializing request object: {}", (Object)e.getMessage());
                throw OnlineGatewayException.getClientExceptionFromEnum(ErrorCodes.UC_VAL_001, this.transactionId, e);
            }
        }
        CloseableHttpResponse httpResponse = null;
        String xServingDcValue = null;
        try {
            httpResponse = this.submitRequest((HttpRequestBase)new HttpPost(this.requestUri), requestJSONBytes);
            Header xServingDcHeader = httpResponse.getFirstHeader("x-serving-dc");
            if (xServingDcHeader != null && xServingDcHeader.getValue() != null) {
                xServingDcValue = xServingDcHeader.getValue();
            }
            object = this.convertResponseToObject((HttpResponse)httpResponse);
            if (httpResponse == null) return object;
        }
        catch (IOException e) {
            try {
                LOGGER.error("POST request failed: {}", (Object)e.getMessage());
                throw OnlineGatewayException.getClientExceptionFromEnum(ErrorCodes.UC_NET_001, this.transactionId, e);
            }
            catch (Throwable throwable) {
                if (httpResponse == null) throw throwable;
                try {
                    httpResponse.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    LOGGER.error("Error while closing HTTP response: {}", (Object)e2.getMessage());
                    TelemetryService.getTelemetryServiceInstance().postLogData(e2, ErrorCodes.UC_GEN_110.getErrorCode(), xServingDcValue);
                }
                throw throwable;
            }
        }
        try {
            httpResponse.close();
            return object;
        }
        catch (IOException e) {
            LOGGER.error("Error while closing HTTP response: {}", (Object)e.getMessage());
            TelemetryService.getTelemetryServiceInstance().postLogData(e, ErrorCodes.UC_GEN_110.getErrorCode(), xServingDcValue);
        }
        return object;
    }

    Object processPostRequestXml(Object request) throws IOException, OnlineGatewayException {
        byte[] requestJSONBytes;
        if (request instanceof String) {
            requestJSONBytes = ((String)request).getBytes();
        } else {
            try {
                requestJSONBytes = this.getObjectWriter().writeValueAsBytes(request);
            }
            catch (IOException e) {
                throw OnlineGatewayException.getClientExceptionFromEnum(ErrorCodes.UC_VAL_002, this.transactionId, e);
            }
        }
        LOGGER.debug("Sending Request : {}", (Object)new String(requestJSONBytes));
        CloseableHttpResponse httpResponse = this.submitRequest((HttpRequestBase)new HttpPost(this.requestUri), requestJSONBytes);
        Object object = this.convertResponseToXmlObject((HttpResponse)httpResponse);
        httpResponse.close();
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Object processGetRequest() throws IOException, OnlineGatewayException {
        Object object;
        CloseableHttpResponse httpResponse = null;
        String xServingDcValue = null;
        try {
            httpResponse = this.submitRequest((HttpRequestBase)new HttpGet(this.requestUri), null);
            Header xServingDcHeader = httpResponse.getFirstHeader("x-serving-dc");
            if (xServingDcHeader != null && xServingDcHeader.getValue() != null) {
                xServingDcValue = xServingDcHeader.getValue();
            }
            object = this.convertResponseToObject((HttpResponse)httpResponse);
            if (httpResponse == null) return object;
        }
        catch (IOException e) {
            try {
                LOGGER.error("GET request failed: {}", (Object)e.getMessage());
                throw OnlineGatewayException.getClientExceptionFromEnum(ErrorCodes.UC_NET_001, this.transactionId, e);
            }
            catch (Throwable throwable) {
                if (httpResponse == null) throw throwable;
                try {
                    httpResponse.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    LOGGER.error("Error while closing HTTP response: {}", (Object)e2.getMessage());
                    TelemetryService.getTelemetryServiceInstance().postLogData(e2, ErrorCodes.UC_GEN_110.getErrorCode(), xServingDcValue);
                }
                throw throwable;
            }
        }
        try {
            httpResponse.close();
            return object;
        }
        catch (IOException e) {
            LOGGER.error("Error while closing HTTP response: {}", (Object)e.getMessage());
            TelemetryService.getTelemetryServiceInstance().postLogData(e, ErrorCodes.UC_GEN_110.getErrorCode(), xServingDcValue);
        }
        return object;
    }

    Object processGetRequestXml() throws IOException, OnlineGatewayException {
        CloseableHttpResponse httpResponse = this.submitRequest((HttpRequestBase)new HttpGet(this.requestUri), null);
        Object object = this.convertResponseToXmlObject((HttpResponse)httpResponse);
        httpResponse.close();
        return object;
    }

    private CloseableHttpResponse submitRequest(HttpRequestBase httpRequest, byte[] baosByteArray) throws IOException {
        this.headers.forEach((arg_0, arg_1) -> ((HttpRequestBase)httpRequest).addHeader(arg_0, arg_1));
        if (httpRequest instanceof HttpEntityEnclosingRequestBase) {
            ByteArrayEntity ise = new ByteArrayEntity(baosByteArray);
            ((HttpEntityEnclosingRequestBase)httpRequest).setEntity((HttpEntity)ise);
        }
        URI requestUri = httpRequest.getURI();
        HttpHost target = new HttpHost(requestUri.getHost(), requestUri.getPort(), requestUri.getScheme());
        return this.httpClient.execute(target, (HttpRequest)httpRequest);
    }

    private Object convertResponseToObject(HttpResponse httpResponse) throws OnlineGatewayException {
        ObjectMapper objectMapper = new ObjectMapper();
        String response = null;
        String xServingDcValue = null;
        try {
            response = HttpConnection.getResponse(httpResponse.getEntity().getContent());
            Header xServingDcHeader = httpResponse.getFirstHeader("x-serving-dc");
            if (xServingDcHeader != null && xServingDcHeader.getValue() != null) {
                xServingDcValue = xServingDcHeader.getValue();
            }
            return objectMapper.readValue(response, this.responseType);
        }
        catch (IOException e) {
            LOGGER.error("JSON parsing failed. Raw Response may be invalid: {}", (Object)e.getMessage());
            TelemetryService.getTelemetryServiceInstance().postLogData(e, ErrorCodes.UC_GEN_112.getErrorCode(), xServingDcValue);
            if (response != null) {
                TelemetryService.getTelemetryServiceInstance().postDebugData(response, xServingDcValue);
            }
            if (httpResponse.getAllHeaders() != null) {
                TelemetryService.getTelemetryServiceInstance().postDebugData(this.headersToString(httpResponse.getAllHeaders()), xServingDcValue);
            }
            throw OnlineGatewayException.getClientExceptionFromEnum(ErrorCodes.UC_VAL_001, this.transactionId, e);
        }
    }

    private Object convertResponseToXmlObject(HttpResponse httpResponse) throws OnlineGatewayException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        SAXSource xmlSource = null;
        try {
            spf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            spf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            spf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            spf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            xmlSource = new SAXSource(spf.newSAXParser().getXMLReader(), new InputSource(httpResponse.getEntity().getContent()));
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw OnlineGatewayException.getClientExceptionFromEnum(ErrorCodes.UC_VAL_002, this.transactionId, e);
        }
        try {
            JAXBContext context2 = JAXBContext.newInstance((Class[])new Class[]{this.responseType});
            Unmarshaller um = context2.createUnmarshaller();
            return um.unmarshal((Source)xmlSource);
        }
        catch (JAXBException e) {
            LOGGER.error("Error in ummarshalling XML:" + (Object)((Object)e));
            throw OnlineGatewayException.getClientExceptionFromEnum(ErrorCodes.UC_VAL_002, this.transactionId, (Exception)((Object)e));
        }
    }

    private ObjectWriter getObjectWriter() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        return objectMapper.writer().withDefaultPrettyPrinter();
    }

    public void destroy() throws IOException {
        this.httpClient.getConnectionManager().closeExpiredConnections();
        this.httpClient.close();
    }

    private static String replacePathParams(String requestUrl, Map<String, String> pathParameters) {
        for (Map.Entry<String, String> entry : pathParameters.entrySet()) {
            requestUrl = requestUrl.replace("{" + entry.getKey() + "}", entry.getValue());
        }
        return requestUrl;
    }

    private static String getResponse(InputStream httpResponse) {
        return new BufferedReader(new InputStreamReader(httpResponse)).lines().collect(Collectors.joining());
    }

    private String headersToString(Header[] headers) {
        StringBuffer headerString = new StringBuffer("[");
        for (Header headerElement : headers) {
            headerString.append(headerElement.getName());
            headerString.append(":");
            headerString.append(headerElement.getValue());
            headerString.append(",");
        }
        headerString.append("]");
        return headerString.toString();
    }
}

