/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.oauthapi;

import in.gov.uidai.ec.oauthapi.HttpConnection;
import in.gov.uidai.ec.oauthapi.OauthGWConstants;
import in.gov.uidai.ec.oauthapi.OnlineGatewayException;
import in.gov.uidai.ec.oauthapi.exception.ErrorCodes;
import in.gov.uidai.ec.telemetry.TelemetryMetrics;
import in.gov.uidai.ec.telemetry.TelemetryService;
import io.github.resilience4j.core.IntervalFunction;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import java.io.IOException;
import java.net.ConnectException;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthGWRequestHandler
implements OauthGWConstants {
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuthGWRequestHandler.class);
    private String gatewayServiceUrl;

    public void setServiceUrl(String serviceUrl) {
        this.gatewayServiceUrl = serviceUrl;
    }

    public Object doPostJson(String url, Object request, Map<String, String> pathParams, Map<String, String> queryParams, Map<String, String> headers, Class<?> responseType, String transactionId) throws OnlineGatewayException {
        RetryConfig retryConfig = RetryConfig.custom().maxAttempts(url.contains("authwrapper") ? 1 : 3).intervalFunction(IntervalFunction.ofExponentialBackoff((long)1000L, (double)1.0)).build();
        Retry retry = Retry.of((String)"doPost", (RetryConfig)retryConfig);
        retry.getEventPublisher().onRetry(event -> LOGGER.info(event.toString())).onSuccess(event -> LOGGER.info(event.toString())).onError(event -> LOGGER.info(event.toString()));
        Supplier<Object> supplier = () -> {
            try {
                return new HttpConnection(this.gatewayServiceUrl + url, pathParams, queryParams, headers, responseType, true, transactionId).processPostRequest(request);
            }
            catch (URISyntaxException e) {
                LOGGER.error("Failed :{}", (Object)e.getMessage(), (Object)e);
                TelemetryService.getTelemetryServiceInstance().postMetricsData(url, TelemetryMetrics.EXCEPTIONS, 1L, new String[0]);
                throw OnlineGatewayException.getClientExceptionFromEnum(ErrorCodes.UC_VAL_003, transactionId, e);
            }
            catch (ConnectException e) {
                LOGGER.error("Failed :{}", (Object)e.getMessage(), (Object)e);
                TelemetryService.getTelemetryServiceInstance().postMetricsData(url, TelemetryMetrics.EXCEPTIONS, 1L, new String[0]);
                throw OnlineGatewayException.getClientExceptionFromEnum(ErrorCodes.UC_GEN_001, transactionId, e);
            }
            catch (IOException e) {
                LOGGER.error("Failed :{}", (Object)e.getMessage(), (Object)e);
                TelemetryService.getTelemetryServiceInstance().postMetricsData(url, TelemetryMetrics.EXCEPTIONS, 1L, new String[0]);
                throw OnlineGatewayException.getClientExceptionFromEnum(ErrorCodes.UC_NET_001, transactionId, e);
            }
        };
        long startTime = System.currentTimeMillis();
        Object response = retry.executeSupplier(supplier);
        long responseTime = System.currentTimeMillis() - startTime;
        TelemetryService.getTelemetryServiceInstance().setTransactionId(transactionId);
        TelemetryService.getTelemetryServiceInstance().postMetricsData(url, TelemetryMetrics.API_LATENCY, responseTime, new String[0]);
        return response;
    }

    Object doGetJson(String url, Map<String, String> pathParams, Map<String, String> queryParams, Map<String, String> headers, Class<?> responseType, String transactionId) throws OnlineGatewayException {
        RetryConfig retryConfig = RetryConfig.custom().maxAttempts(3).intervalFunction(IntervalFunction.ofExponentialBackoff((long)1000L, (double)1.0)).build();
        Retry retry = Retry.of((String)"doGet", (RetryConfig)retryConfig);
        retry.getEventPublisher().onRetry(event -> LOGGER.info(event.toString())).onSuccess(event -> LOGGER.info(event.toString())).onError(event -> LOGGER.info(event.toString()));
        Supplier<Object> supplier = () -> {
            try {
                HttpConnection httpConnection = new HttpConnection(this.gatewayServiceUrl + url, pathParams, queryParams, headers, responseType, true, transactionId);
                return httpConnection.processGetRequest();
            }
            catch (URISyntaxException e) {
                LOGGER.info("Failed :{}", (Object)e.getMessage());
                TelemetryService.getTelemetryServiceInstance().postMetricsData(url, TelemetryMetrics.EXCEPTIONS, 1L, new String[0]);
                throw OnlineGatewayException.getClientExceptionFromEnum(ErrorCodes.UC_VAL_003, transactionId, e);
            }
            catch (IOException e) {
                LOGGER.info("Failed :{}", (Object)e.getMessage());
                TelemetryService.getTelemetryServiceInstance().postMetricsData(url, TelemetryMetrics.EXCEPTIONS, 1L, new String[0]);
                throw OnlineGatewayException.getClientExceptionFromEnum(ErrorCodes.UC_NET_001, transactionId, e);
            }
        };
        long startTime = System.currentTimeMillis();
        Object response = retry.executeSupplier(supplier);
        long responseTime = System.currentTimeMillis() - startTime;
        TelemetryService.getTelemetryServiceInstance().setTransactionId(transactionId);
        TelemetryService.getTelemetryServiceInstance().postMetricsData(url, TelemetryMetrics.API_LATENCY, responseTime, new String[0]);
        return response;
    }
}

