/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.oauthapi;

import com.google.common.base.Strings;
import in.gov.uidai.ec.ecmpapi.CommonUtils;
import in.gov.uidai.ec.ecmpapi.xml.genericotp.GenerateOtpResponse;
import in.gov.uidai.ec.ecmpapi.xml.genericotp.MatchEmailOtpRequest;
import in.gov.uidai.ec.ecmpapi.xml.genericotp.MatchMobileOtpRequest;
import in.gov.uidai.ec.ecmpapi.xml.genericotp.MatchOtpResponse;
import in.gov.uidai.ec.oauthapi.IGatewayPreference;
import in.gov.uidai.ec.oauthapi.OAuthGWRequestHandler;
import in.gov.uidai.ec.oauthapi.OnlineGatewayException;
import in.gov.uidai.ec.oauthapi.exception.ErrorCodes;
import in.gov.uidai.ec.oauthapi.json.ackslipapi.AckSlipResponse;
import in.gov.uidai.ec.oauthapi.json.brnapi.ChildInfoRequest;
import in.gov.uidai.ec.oauthapi.json.brnapi.ChildInfoResponse;
import in.gov.uidai.ec.oauthapi.json.brnapi.state.StatesList;
import in.gov.uidai.ec.oauthapi.json.cancelapi.CancelResponse;
import in.gov.uidai.ec.oauthapi.json.countapi.UpdateCountResponse;
import in.gov.uidai.ec.oauthapi.json.mda.pinapi.PinCodeResponse;
import in.gov.uidai.ec.oauthapi.json.mda.proofdocapi.CountryListResponse;
import in.gov.uidai.ec.oauthapi.json.mda.proofdocapi.NationalityTypeResponse;
import in.gov.uidai.ec.oauthapi.json.mda.proofdocapi.ProofDocumentResponse;
import in.gov.uidai.ec.oauthapi.json.mda.roiapi.DocRoiResponse;
import in.gov.uidai.ec.oauthapi.json.statusapi.StageStatusRequest;
import in.gov.uidai.ec.oauthapi.json.statusapi.StageStatusResponse;
import in.gov.uidai.ec.oauthapi.json.updateapi.UpdateDemographicsRequest;
import in.gov.uidai.ec.oauthapi.json.updateapi.UpdateDemographicsResponse;
import in.gov.uidai.ec.oauthapi.token.TokenManager;
import in.gov.uidai.ec.telemetry.TelemetryMetrics;
import in.gov.uidai.ec.telemetry.TelemetryService;
import in.gov.uidai.ec.ui.biologin.AuthWrapper25Request;
import in.gov.uidai.ec.ui.biologin.AuthWrapperRequest;
import in.gov.uidai.ec.ui.biologin.BioAuthResponse;
import in.gov.uidai.ec.ui.biologin.CheckTokenResponse;
import in.gov.uidai.ec.ui.biologin.LogoutResponse;
import in.gov.uidai.ec.ui.biologin.UserType;
import in.gov.uidai.ec.ui.enrol.confirmbioauth.BioAuth16Request;
import in.gov.uidai.ec.ui.enrol.confirmbioauth.BioAuth16Response;
import in.gov.uidai.ec.ui.enrol.confirmbioauth.BioAuth25Request;
import in.gov.uidai.ec.ui.pac.PacResponse;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class OauthGWService
extends OAuthGWRequestHandler
implements InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuthGWRequestHandler.class);
    private TokenManager opTokenManager;
    private TokenManager consentTokenManager;
    private TokenManager supervisorTokenManager;
    private IGatewayPreference gatewayPreference;
    private Map<String, String> xRequestMap = new HashMap<String, String>();

    public IGatewayPreference getGatewayPreference() {
        return this.gatewayPreference;
    }

    public void setGatewayPreference(IGatewayPreference gatewayPreference) {
        this.gatewayPreference = gatewayPreference;
    }

    public void setOpTokenManager(TokenManager opTokenManager) {
        this.opTokenManager = opTokenManager;
    }

    public void setConsentTokenManager(TokenManager consentTokenManager) {
        this.consentTokenManager = consentTokenManager;
    }

    public void setSupervisorTokenManager(TokenManager supervisorTokenManager) {
        this.supervisorTokenManager = supervisorTokenManager;
    }

    public void afterPropertiesSet() throws Exception {
        this.setServiceUrl(this.gatewayPreference.getOAuthGWServicesUrl());
    }

    public UpdateCountResponse getUpdateCountData(String uid) throws OnlineGatewayException {
        Map<String, String> headers;
        Map<String, String> pathParams = Collections.singletonMap("uid", uid);
        UpdateCountResponse response = (UpdateCountResponse)this.doGetJson("/uos/ext/demographics/update/count/{uid}", pathParams, null, headers = this.getCAuthorisationHeaderMap(), UpdateCountResponse.class, this.getTransactionId());
        if (response.failure()) {
            TelemetryService.getTelemetryServiceInstance().postMetricsData("/uos/ext/demographics/update/count/{uid}", TelemetryMetrics.EXCEPTIONS, 1L, new String[0]);
            throw new OnlineGatewayException(CommonUtils.getErrorMessage(response), CommonUtils.getErrorMessage(response), CommonUtils.getErrorCode(response));
        }
        return response;
    }

    public ProofDocumentResponse proofDocumentRequestSubmit(String proofDocumentsRequest) throws OnlineGatewayException {
        Map<String, String> headerMap = this.getAuthorisationHeaderMap();
        return (ProofDocumentResponse)this.doPostJson("/uc/supportingDataManagement/graphql", proofDocumentsRequest, null, null, headerMap, ProofDocumentResponse.class, this.getTransactionId());
    }

    public PinCodeResponse pincodeRequestSubmit(String pincodeRequest) throws OnlineGatewayException {
        Map<String, String> headerMap = this.getAuthorisationHeaderMap();
        return (PinCodeResponse)this.doPostJson("/uc/pincode/graphql", pincodeRequest, null, null, headerMap, PinCodeResponse.class, this.getTransactionId());
    }

    public DocRoiResponse fetchRoiLabels(String roiRequest) throws OnlineGatewayException {
        Map<String, String> headerMap = this.getAuthorisationHeaderMap();
        try {
            DocRoiResponse docRoiResponse = (DocRoiResponse)this.doPostJson("/mda/graphql", roiRequest, null, null, headerMap, DocRoiResponse.class, this.getTransactionId());
            return docRoiResponse;
        }
        catch (OnlineGatewayException e) {
            LOGGER.info("Fetch Roi MDA Server Failure");
            throw new OnlineGatewayException("Fetch Roi MDA Server Failure" + e.getMessage(), "Fetch Roi MDA Server Failure", e.getErrorCode());
        }
    }

    public ChildInfoResponse getChildInfo(ChildInfoRequest childInfoRequest) throws OnlineGatewayException {
        Map<String, String> headerMap = this.getAuthorisationHeaderMap();
        try {
            ChildInfoResponse childInfoResponse = (ChildInfoResponse)this.doPostJson("/uos/ext/brn/getChildInfo", childInfoRequest, null, null, headerMap, ChildInfoResponse.class, this.getTransactionId());
            return childInfoResponse;
        }
        catch (OnlineGatewayException e) {
            LOGGER.info("Error while fetching child info");
            throw new OnlineGatewayException("Fetch Child Info Failure" + e.getMessage(), e.getMessage(), e.getErrorCode());
        }
    }

    public StatesList brnStateListSubmit() throws OnlineGatewayException {
        Map<String, String> headerMap = this.getAuthorisationHeaderMap();
        return (StatesList)this.doGetJson("/childenrollmentservices/getbrnstates", null, null, headerMap, StatesList.class, this.getTransactionId());
    }

    public NationalityTypeResponse getNationalityTypeList(String request) throws OnlineGatewayException {
        Map<String, String> headerMap = this.getAuthorisationHeaderMap();
        return (NationalityTypeResponse)this.doPostJson("/uc/supportingDataManagement/graphql", request, null, null, headerMap, NationalityTypeResponse.class, this.getTransactionId());
    }

    public CountryListResponse getCountries(String request) throws OnlineGatewayException {
        Map<String, String> headerMap = this.getAuthorisationHeaderMap();
        return (CountryListResponse)this.doPostJson("/uc/supportingDataManagement/graphql", request, null, null, headerMap, CountryListResponse.class, this.getTransactionId());
    }

    public void updateDemographics(UpdateDemographicsRequest request) throws OnlineGatewayException {
        UpdateDemographicsResponse response;
        LOGGER.info("Uploading demographics data on server");
        Map<String, String> headerMap = this.getCAuthorisationHeaderMap();
        if (this.isHofConsent() && this.consentTokenManager.getAccessToken() != null) {
            headerMap.put("hAuthorization", "Bearer " + this.consentTokenManager.getAccessToken());
            headerMap.remove("cAuthorization");
        }
        if ((response = (UpdateDemographicsResponse)this.doPostJson("/uos/ext/demographics/update", request, null, null, headerMap, UpdateDemographicsResponse.class, this.getTransactionId())).failure()) {
            TelemetryService.getTelemetryServiceInstance().postMetricsData("/uos/ext/demographics/update", TelemetryMetrics.EXCEPTIONS, 1L, new String[0]);
            throw new OnlineGatewayException(CommonUtils.getErrorMessage(response), CommonUtils.getErrorMessage(response), CommonUtils.getErrorCode(response));
        }
        if (this.isHofConsent() && this.consentTokenManager.getAccessToken() != null) {
            headerMap.remove("hAuthorization");
            headerMap.put("cAuthorization", "Bearer " + this.consentTokenManager.getAccessToken());
        }
    }

    public AckSlipResponse getAckSlip(String sid) throws OnlineGatewayException {
        LOGGER.debug("Obtaining acknowledgment slip");
        Map<String, String> pathParams = Collections.singletonMap("sid", sid);
        Map<String, String> headerMap = this.getCAuthorisationHeaderMap();
        AckSlipResponse response = (AckSlipResponse)this.doGetJson("/uos/ext/demographics/download/ackslip/{sid}", pathParams, null, headerMap, AckSlipResponse.class, this.getTransactionId());
        if (response.failure() || response.getResponseData() == null || StringUtils.isEmpty((String)response.getResponseData().getAckSlip())) {
            TelemetryService.getTelemetryServiceInstance().postMetricsData("/uos/ext/demographics/download/ackslip/{sid}", TelemetryMetrics.EXCEPTIONS, 1L, new String[0]);
            throw new OnlineGatewayException(CommonUtils.getErrorMessage(response), CommonUtils.getErrorMessage(response), CommonUtils.getErrorCode(response));
        }
        return response;
    }

    public CancelResponse cancelCall(String sid) throws OnlineGatewayException {
        Map<String, String> headers;
        Map<String, String> pathParams = Collections.singletonMap("sid", sid);
        CancelResponse response = (CancelResponse)this.doGetJson("/uos/ext/cancel/{sid}", pathParams, null, headers = this.getCAuthorisationHeaderMap(), CancelResponse.class, this.getTransactionId());
        if (response.failure()) {
            String msg = "Error occurred while canceling";
            TelemetryService.getTelemetryServiceInstance().postMetricsData("/uos/ext/cancel/{sid}", TelemetryMetrics.EXCEPTIONS, 1L, new String[0]);
            throw new OnlineGatewayException(msg + ": " + response, msg, response.getErrorCode());
        }
        return response;
    }

    public StageStatusResponse getStageStatus(StageStatusRequest request, String client) throws OnlineGatewayException {
        LOGGER.info("Fetching stage status");
        Map<String, String> headerMap = this.getCAuthorisationHeaderMap();
        headerMap.put("X-Client-Identification", client);
        StageStatusResponse response = (StageStatusResponse)this.doPostJson("/enrolstatus/ucpacketstatus", request, null, null, headerMap, StageStatusResponse.class, this.getTransactionId());
        return response;
    }

    public GenerateOtpResponse otpRequestSubmit(boolean isMobile, String value) throws OnlineGatewayException {
        String url;
        Map<String, String> queryParams;
        if (isMobile) {
            queryParams = Collections.singletonMap("mobile", value);
            url = "/uos/ext/genericOtp/generate";
        } else {
            queryParams = Collections.singletonMap("email", value);
            url = "/uos/ext/genericEmailOtp/generate";
        }
        Map<String, String> headerMap = this.getCAuthorisationHeaderMap();
        GenerateOtpResponse response = (GenerateOtpResponse)this.doGetJson(url, null, queryParams, headerMap, GenerateOtpResponse.class, this.getTransactionId());
        if (response.getErrorDetail() != null || response.getError() != null) {
            TelemetryService.getTelemetryServiceInstance().postMetricsData(url, TelemetryMetrics.EXCEPTIONS, 1L, new String[0]);
            String msg = CommonUtils.getErrorMessage(response);
            LOGGER.error(msg);
            throw new OnlineGatewayException(msg, msg, Strings.isNullOrEmpty((String)response.getErrorCode()) ? ErrorCodes.UC_OTP_005.getErrorCode() : response.getResponseCode());
        }
        if (response.getResult() == null) {
            TelemetryService.getTelemetryServiceInstance().postMetricsData(url, TelemetryMetrics.EXCEPTIONS, 1L, new String[0]);
            String msg = "Otp Generation Failed. " + (Strings.isNullOrEmpty((String)response.getMessage()) ? "" : response.getMessage());
            LOGGER.error(msg);
            throw new OnlineGatewayException(msg, msg, Strings.isNullOrEmpty((String)response.getErrorCode()) ? ErrorCodes.UC_OTP_005.getErrorCode() : response.getResponseCode());
        }
        if (!response.getResult().equals("Y")) {
            TelemetryService.getTelemetryServiceInstance().postMetricsData(url, TelemetryMetrics.EXCEPTIONS, 1L, new String[0]);
            String msg = "Otp Generation Failed. " + (Strings.isNullOrEmpty((String)response.getMessage()) ? "" : response.getMessage());
            LOGGER.error(msg);
            throw new OnlineGatewayException(msg, msg, Strings.isNullOrEmpty((String)response.getErrorCode()) ? ErrorCodes.UC_OTP_006.getErrorCode() : response.getResponseCode());
        }
        return response;
    }

    public MatchOtpResponse matchMobOtp(MatchMobileOtpRequest request) throws OnlineGatewayException {
        Map<String, String> headerMap = this.getCAuthorisationHeaderMap();
        MatchOtpResponse response = (MatchOtpResponse)this.doPostJson("/uos/ext/genericOtp/match", request, null, null, headerMap, MatchOtpResponse.class, this.getTransactionId());
        return response;
    }

    public MatchOtpResponse matchEmailOtp(MatchEmailOtpRequest request) throws OnlineGatewayException {
        Map<String, String> headerMap = this.getCAuthorisationHeaderMap();
        MatchOtpResponse response = (MatchOtpResponse)this.doPostJson("/uos/ext/genericEmailOtp/match", request, null, null, headerMap, MatchOtpResponse.class, this.getTransactionId());
        return response;
    }

    public BioAuthResponse doBioAuth(AuthWrapperRequest request, boolean isOperator) throws OnlineGatewayException {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("Forward-Auth-Xml", "true");
        if (isOperator) {
            return (BioAuthResponse)this.doPostJson("/operator/authwrapper/uc/bioAuth/1.6", request, null, null, headerMap, BioAuthResponse.class, this.opTokenManager.getBioLoginTransactionId());
        }
        headerMap.put("Authorization", "Bearer " + this.opTokenManager.getAccessToken());
        return (BioAuthResponse)this.doPostJson("/resident/authwrapper/uc/bioAuth/1.6", request, null, null, headerMap, BioAuthResponse.class, this.getTransactionId());
    }

    public BioAuthResponse verifyBiometricsUC(AuthWrapper25Request bioVerifyRequest, boolean isOperator) throws OnlineGatewayException {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("Forward-Auth-Xml", "true");
        if (isOperator) {
            return (BioAuthResponse)this.doPostJson("/operator/authwrapper/uc/bioAuth/2.5", bioVerifyRequest, null, null, headerMap, BioAuthResponse.class, this.opTokenManager.getBioLoginTransactionId());
        }
        headerMap.put("Authorization", "Bearer " + this.opTokenManager.getAccessToken());
        return (BioAuthResponse)this.doPostJson("/operator/authwrapper/uc/bioAuth/2.5", bioVerifyRequest, null, null, headerMap, BioAuthResponse.class, this.getTransactionId());
    }

    public LogoutResponse operatorLogout() throws OnlineGatewayException {
        Map<String, String> headerMap = this.getAuthorisationHeaderMap();
        String request = "";
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("refresh_token", this.opTokenManager.getAccessToken());
        return (LogoutResponse)this.doPostJson("/access/oauth/logout", request, null, queryParams, headerMap, LogoutResponse.class, this.getTransactionId());
    }

    public CheckTokenResponse checkOperatorToken() {
        Map<String, String> headerMap = this.getAuthorisationHeaderMap();
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("token", this.opTokenManager.getRefreshToken());
        return (CheckTokenResponse)this.doGetJson("/access/check_refresh_token", null, queryParams, headerMap, CheckTokenResponse.class, this.getTransactionId());
    }

    public PacResponse checkPacRequired(Map<String, String> queryParams) {
        Map<String, String> headerMap = this.getAuthorisationHeaderMap();
        return (PacResponse)this.doGetJson("/ss/uc/pacDetails", null, queryParams, headerMap, PacResponse.class, this.getTransactionId());
    }

    public BioAuth16Response doBioAuthConfirmEnrol(BioAuth16Request request, String sid, String refId, Boolean bioException, Boolean bothIrisException, Boolean allFingersException) throws OnlineGatewayException {
        Map<String, String> headerMap = this.getCAuthorisationHeaderMap();
        headerMap.put("Forward-Auth-Xml", "true");
        headerMap.put("role", "Operator");
        headerMap.put("biometric-exception", String.valueOf(bioException));
        headerMap.put("Both-Iris-Exception", String.valueOf(bothIrisException));
        headerMap.put("All-Fingers-Exception", String.valueOf(allFingersException));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("sid", sid);
        queryParams.put("refId", refId);
        return (BioAuth16Response)this.doPostJson("/uos/ext/auth16", request, null, queryParams, headerMap, BioAuth16Response.class, this.getTransactionId());
    }

    public BioAuth16Response doRDBioAuthConfirmEnrol(BioAuth25Request request, String sid, String refId, Boolean bioException, Boolean bothIrisException, Boolean allFingersException) throws OnlineGatewayException {
        Map<String, String> headerMap = this.getCAuthorisationHeaderMap();
        headerMap.put("Forward-Auth-Xml", "true");
        headerMap.put("role", "Operator");
        headerMap.put("biometric-exception", String.valueOf(bioException));
        headerMap.put("Both-Iris-Exception", String.valueOf(bothIrisException));
        headerMap.put("All-Fingers-Exception", String.valueOf(allFingersException));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("sid", sid);
        queryParams.put("refId", refId);
        return (BioAuth16Response)this.doPostJson("/uos/ext/auth25", request, null, queryParams, headerMap, BioAuth16Response.class, this.getTransactionId());
    }

    private Map<String, String> getXRequestIdHeaderMap() {
        if (!this.xRequestMap.containsKey("X-Request-Id")) {
            this.xRequestMap.put("X-Request-Id", UUID.randomUUID().toString());
            LOGGER.info("Transaction ID: " + this.xRequestMap.get("X-Request-Id"));
        }
        return this.xRequestMap;
    }

    public String getTransactionId() {
        this.xRequestMap = this.getXRequestIdHeaderMap();
        return this.xRequestMap.get("X-Request-Id");
    }

    public void clearTransactionId() {
        if (this.xRequestMap.containsKey("X-Request-Id")) {
            this.xRequestMap.remove("X-Request-Id");
        }
        if (this.xRequestMap.containsKey("cAuthorization")) {
            this.xRequestMap.remove("cAuthorization");
        }
        if (this.xRequestMap.containsKey("hAuthorization")) {
            this.xRequestMap.remove("hAuthorization");
        }
    }

    private Map<String, String> getAuthorisationHeaderMap() throws OnlineGatewayException {
        String accessToken = this.opTokenManager.getAccessToken();
        Map<String, String> result = this.getXRequestIdHeaderMap();
        result.put("Authorization", "Bearer " + accessToken);
        return result;
    }

    private Map<String, String> getCAuthorisationHeaderMap() throws OnlineGatewayException {
        String accessToken = this.consentTokenManager.getAccessToken();
        Map<String, String> result = this.getAuthorisationHeaderMap();
        if (accessToken != null && !this.isHofConsent()) {
            result.put("cAuthorization", "Bearer " + accessToken);
        }
        return result;
    }

    private boolean isHofConsent() {
        return this.consentTokenManager.getUserType().equals((Object)UserType.HOF);
    }
}

