/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.oauthapi;

import in.gov.uidai.ec.oauthapi.exception.ErrorCodes;
import in.gov.uidai.ec.telemetry.TelemetryService;
import io.grpc.HttpConnectProxiedSocketAddress;
import io.grpc.netty.NettyChannelBuilder;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProxyConfiguration.class);

    public static void initialize(HttpClientBuilder clientBuilder) {
        Properties proxyProps = new Properties();
        try {
            FileInputStream fis = new FileInputStream("./conf/proxy.properties");
            proxyProps.load(fis);
            fis.close();
        }
        catch (Exception e) {
            LOGGER.warn("Failed to load Proxy properties");
            TelemetryService.getTelemetryServiceInstance().postLogData(e, ErrorCodes.UC_GEN_120.getErrorCode(), new String[0]);
            return;
        }
        String proxy = proxyProps.getProperty("custom.proxy.ip");
        String port = proxyProps.getProperty("custom.port");
        String proxyUserName = proxyProps.getProperty("custom.proxy.userName");
        String proxyUserPwd = proxyProps.getProperty("custom.proxy.userpwd");
        if (!StringUtils.isBlank((String)proxy) && !StringUtils.isBlank((String)port)) {
            HttpHost proxyHost = new HttpHost(proxy.trim(), Integer.parseInt(port.trim()));
            clientBuilder.setProxy(proxyHost);
            if (!StringUtils.isBlank((String)proxyUserName) && !StringUtils.isBlank((String)proxyUserPwd)) {
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(proxyUserName.trim(), proxyUserPwd.trim());
                AuthScope authScope = new AuthScope(proxy.trim(), Integer.parseInt(port.trim()));
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(authScope, (Credentials)credentials);
                clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            }
        }
    }

    public static NettyChannelBuilder initialize(NettyChannelBuilder builder) {
        boolean useProxy;
        Properties props = ProxyConfiguration.getProperty();
        String proxyHost = props.getProperty("custom.proxy.ip");
        String proxyPort = props.getProperty("custom.port");
        String proxyUserName = props.getProperty("custom.proxy.userName");
        String proxyUserPwd = props.getProperty("custom.proxy.userpwd");
        boolean bl = useProxy = !StringUtils.isBlank((String)proxyHost) && !StringUtils.isBlank((String)proxyPort);
        if (useProxy) {
            LOGGER.info("[gRPC] Using proxy: " + proxyHost + ":" + proxyPort);
            builder.proxyDetector(address -> {
                if (address instanceof InetSocketAddress) {
                    InetSocketAddress target = (InetSocketAddress)address;
                    HttpConnectProxiedSocketAddress.Builder pb = HttpConnectProxiedSocketAddress.newBuilder().setProxyAddress((SocketAddress)new InetSocketAddress(proxyHost, Integer.parseInt(proxyPort))).setTargetAddress(target);
                    if (StringUtils.isNotBlank((String)proxyUserName) && StringUtils.isNotBlank((String)proxyUserPwd)) {
                        pb.setUsername(proxyUserName).setPassword(proxyUserPwd);
                        LOGGER.info("[gRPC] Proxy authentication set for user: " + proxyUserName);
                    }
                    LOGGER.info("[gRPC] ProxyDetector invoked for target: " + target);
                    return pb.build();
                }
                return null;
            });
        } else {
            LOGGER.info("[gRPC] No proxy configured \u2014 using direct connection");
            builder.proxyDetector(addr -> null);
        }
        return builder;
    }

    public static String getProxyUrl() {
        Properties props = ProxyConfiguration.getProperty();
        String host = props.getProperty("custom.proxy.ip");
        String port = props.getProperty("custom.port");
        String user = props.getProperty("custom.proxy.userName");
        String pass = props.getProperty("custom.proxy.userpwd");
        if (StringUtils.isBlank((String)host) || StringUtils.isBlank((String)port)) {
            return null;
        }
        StringBuilder proxyUrl = new StringBuilder("http://");
        try {
            if (StringUtils.isNotBlank((String)user) && StringUtils.isNotBlank((String)pass)) {
                String encodedUser = URLEncoder.encode(user.trim(), StandardCharsets.UTF_8.name());
                String encodedPass = URLEncoder.encode(pass.trim(), StandardCharsets.UTF_8.name());
                proxyUrl.append(encodedUser).append(":").append(encodedPass).append("@");
            }
        }
        catch (Exception e) {
            LOGGER.error("Error encoding proxy credentials", (Throwable)e);
        }
        proxyUrl.append(host.trim()).append(":").append(port.trim());
        return proxyUrl.toString();
    }

    private static Properties getProperty() {
        Properties props = new Properties();
        try (FileInputStream fis = new FileInputStream("./conf/proxy.properties");){
            props.load(fis);
        }
        catch (IOException e) {
            LOGGER.warn("Failed to load Proxy properties");
            TelemetryService.getTelemetryServiceInstance().postLogData(e, ErrorCodes.UC_GEN_120.getErrorCode(), new String[0]);
        }
        return props;
    }
}

