/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.oauthapi.json.mda.roiapi;

import in.gov.uidai.ec.oauthapi.OauthGWService;
import in.gov.uidai.ec.oauthapi.OnlineGatewayException;
import in.gov.uidai.ec.oauthapi.exception.ErrorCodes;
import in.gov.uidai.ec.oauthapi.json.mda.roiapi.DocRoiResponse;
import in.gov.uidai.ec.oauthapi.json.mda.roiapi.LabelDetail;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OnlineRoiCache {
    Map<String, Map<String, List<LabelDetail>>> roiMap = new HashMap<String, Map<String, List<LabelDetail>>>();
    private OauthGWService oauthGWApiService;

    public void setOauthGWApiService(OauthGWService oauthGWApiService) {
        this.oauthGWApiService = oauthGWApiService;
    }

    public List<LabelDetail> getRoiLables(String queryDocType, String queryDocId) throws OnlineGatewayException {
        if (this.roiMap.containsKey(queryDocType) && this.roiMap.get(queryDocType) != null && this.roiMap.get(queryDocType).get(queryDocId) != null) {
            return this.roiMap.get(queryDocType).get(queryDocId);
        }
        DocRoiResponse docRoiResponse = this.oauthGWApiService.fetchRoiLabels("{\"query\":\"query {docRoiLabels { docLabels { docType, labelName, partLabelName, documentId }}}\"}");
        List<LabelDetail> labelDetailList = docRoiResponse.getData().getDocRoiLabels().getDocLabels();
        if (labelDetailList.isEmpty()) {
            throw new OnlineGatewayException("Could not found labels of region of interest", "Could not found labels of region of interest", ErrorCodes.UC_DOC_001.getErrorCode());
        }
        for (LabelDetail labelDetail : labelDetailList) {
            String docType = labelDetail.getDocType();
            String docId = labelDetail.getDocumentId();
            if (this.roiMap.get(docType) == null) {
                HashMap docMap = new HashMap();
                ArrayList<LabelDetail> nodesList = new ArrayList<LabelDetail>();
                nodesList.add(labelDetail);
                docMap.put(docId, nodesList);
                this.roiMap.put(docType, docMap);
                continue;
            }
            if (this.roiMap.get(docType).get(docId) == null) {
                ArrayList<LabelDetail> nodesList = new ArrayList<LabelDetail>();
                nodesList.add(labelDetail);
                this.roiMap.get(docType).put(docId, nodesList);
                continue;
            }
            this.roiMap.get(docType).get(docId).add(labelDetail);
        }
        return this.roiMap.get(queryDocType).get(queryDocId);
    }
}

