/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.oauthapi.token;

import in.gov.uidai.ec.oauthapi.OAuthGWRequestHandler;
import in.gov.uidai.ec.oauthapi.OnlineGatewayException;
import in.gov.uidai.ec.oauthapi.json.bioauth.BioAuthTokenData;
import in.gov.uidai.ec.oauthapi.json.tokenapi.AccessTokenResponse;
import in.gov.uidai.ec.oauthapi.token.AuthCodeListener;
import in.gov.uidai.ec.oauthapi.token.ITokenHelper;
import in.gov.uidai.ec.ui.biologin.BioAuthType;
import in.gov.uidai.ec.ui.biologin.UserType;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenManager
implements AuthCodeListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(TokenManager.class);
    private final OAuthGWRequestHandler oAuthGWRequestHandler;
    private final ITokenHelper tokenHelper;
    private final List<Consumer<Boolean>> validityChangeListener;
    private final ScheduledExecutorService scheduledExecutorService;
    private String accessToken;
    private String refreshToken;
    private long accessTokenExpiry;
    private long refreshTokenExpiry;
    private String bioAuthToken;
    private BioAuthType bioAuthType;
    private UserType userType;
    private boolean isValid;
    private ScheduledFuture<?> scheduledFuture;
    private String transactionId;
    private Runnable opInvalidateRunnable;
    private boolean isUniversalClientTransaction = false;

    public TokenManager(OAuthGWRequestHandler oAuthGWRequestHandler, ITokenHelper tokenHelper, String userType) {
        this.oAuthGWRequestHandler = oAuthGWRequestHandler;
        oAuthGWRequestHandler.setServiceUrl(tokenHelper.getDomain());
        this.tokenHelper = tokenHelper;
        this.validityChangeListener = new ArrayList<Consumer<Boolean>>();
        this.userType = UserType.valueOf(userType);
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
    }

    public void setUniversalClientTransaction(boolean isUniversalClientTransaction) {
        this.isUniversalClientTransaction = isUniversalClientTransaction;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public String getAccessToken() {
        long current = Instant.now().getEpochSecond();
        if (this.accessTokenExpiry >= current) {
            return this.accessToken;
        }
        if (this.refreshTokenExpiry >= current) {
            return this.accessToken;
        }
        return null;
    }

    public long getAccessTokenExpiry() {
        return this.accessTokenExpiry;
    }

    public String getBioAuthToken() {
        return this.bioAuthToken;
    }

    public boolean isValid() {
        long current = Instant.now().getEpochSecond();
        return this.accessTokenExpiry >= current || this.refreshTokenExpiry >= current;
    }

    private void setValid(boolean valid) {
        if (this.isValid != valid) {
            this.isValid = valid;
            this.validityChangeListener.forEach(listener -> listener.accept(this.isValid));
        }
    }

    public UserType getUserType() {
        return this.userType;
    }

    @Override
    public void accept(String authCode, String codeVerifier) throws OnlineGatewayException {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("client_id", this.tokenHelper.getClientId());
        queryParams.put("code_verifier", codeVerifier);
        queryParams.put("grant_type", this.tokenHelper.getOAuthGrantType());
        queryParams.put("code", authCode);
        this.getTokens(queryParams);
        this.scheduleTokenValidityExpiry(this.accessTokenExpiry - Instant.now().getEpochSecond());
    }

    @Override
    public void acceptOp(String authCode, String codeVerifier, Runnable runnable) throws OnlineGatewayException {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("client_id", this.tokenHelper.getClientId());
        queryParams.put("code_verifier", codeVerifier);
        queryParams.put("grant_type", this.tokenHelper.getOAuthGrantType());
        queryParams.put("code", authCode);
        this.opInvalidateRunnable = runnable;
        this.getTokens(queryParams);
        this.scheduleTokenValidityExpiry(this.accessTokenExpiry - Instant.now().getEpochSecond());
        this.setUniversalClientTransaction(true);
    }

    public Runnable getOpInvalidateRunnable() {
        return this.opInvalidateRunnable;
    }

    @Override
    public void acceptBioAuth(String authToken, String bioAuthType, UserType userType, String transactionId) {
        this.bioAuthToken = authToken;
        this.userType = userType;
        this.bioAuthType = BioAuthType.valueOf(bioAuthType);
        this.transactionId = transactionId;
    }

    @Override
    public String getOperatorId() {
        return (String)this.getClaims(this.accessToken).get((Object)"operatorCode");
    }

    @Override
    public String getOperatorUid() {
        return (String)this.getClaims(this.accessToken).get((Object)"uid");
    }

    @Override
    public String getOperatorName() {
        return (String)this.getClaims(this.accessToken).get((Object)"user_name");
    }

    public Claims getClaims(String token) {
        int idx = token.lastIndexOf(46);
        String tokenWithoutSignature = token.substring(0, idx + 1);
        return (Claims)Jwts.parserBuilder().build().parseClaimsJwt(tokenWithoutSignature).getBody();
    }

    public String getBioLoginTransactionId() {
        String trnx = (String)this.getClaims(this.bioAuthToken).get((Object)"txn_id");
        LOGGER.info("Operator Login Transaction ID: {}", (Object)trnx);
        return trnx;
    }

    public BioAuthType getBioAuthType() {
        return this.bioAuthType;
    }

    public void addValidityListener(Consumer<Boolean> validityListener) {
        if (validityListener == null) {
            return;
        }
        this.validityChangeListener.add(validityListener);
    }

    public ITokenHelper getTokenHelper() {
        return this.tokenHelper;
    }

    private void refreshTokens() throws OnlineGatewayException {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("client_id", this.tokenHelper.getClientId());
        queryParams.put("grant_type", "refresh_token");
        queryParams.put("refresh_token", this.refreshToken);
        this.getTokens(queryParams);
    }

    private void getTokens(Map<String, String> queryParams) throws OnlineGatewayException {
        try {
            LOGGER.info("Fetching Tokens ... ");
            AccessTokenResponse tokenResponse = (AccessTokenResponse)this.oAuthGWRequestHandler.doPostJson(this.tokenHelper.getTokenGenerationEndpoint(), null, null, queryParams, null, AccessTokenResponse.class, this.transactionId);
            this.accessToken = tokenResponse.getAccessToken();
            this.accessTokenExpiry = this.getExpiryTime(this.accessToken);
            this.refreshToken = tokenResponse.getRefreshToken();
            this.refreshTokenExpiry = this.getExpiryTime(this.refreshToken);
            LOGGER.info("Got Token Response  ... {}", (Object)tokenResponse);
            this.setValid(true);
        }
        catch (OnlineGatewayException e) {
            LOGGER.error("Error occurred while obtaining access tokens");
            throw e;
        }
    }

    private long getExpiryTime(String token) {
        return ((Date)this.getClaims(token).get("exp", Date.class)).toInstant().getEpochSecond();
    }

    private String getOperatorId(String token) {
        return (String)this.getClaims(token).get((Object)"operatorCode");
    }

    public BioAuthTokenData extractTokenFields(String authToken) {
        Claims claims = this.getClaims(authToken);
        BioAuthTokenData tokenData = new BioAuthTokenData();
        tokenData.setUser_id((String)claims.get((Object)"user_id"));
        tokenData.setSessionId((String)claims.get((Object)"session_id"));
        tokenData.setTxn((String)claims.get((Object)"txn_id"));
        return tokenData;
    }

    private void scheduleTokenValidityExpiry(long delay) {
        if (this.scheduledFuture != null && !this.scheduledFuture.isDone()) {
            this.scheduledFuture.cancel(true);
        }
        this.scheduledFuture = this.scheduledExecutorService.schedule(this::onTokenValidityExpiry, delay - 120L, TimeUnit.SECONDS);
    }

    private void onTokenValidityExpiry() {
        long current = Instant.now().getEpochSecond();
        LOGGER.debug("Token validity expiry triggered");
        if (this.accessTokenExpiry <= current && current < this.refreshTokenExpiry) {
            LOGGER.info("Access token has expired");
            if (this.isUniversalClientTransaction) {
                this.refreshTokens();
                this.scheduleTokenValidityExpiry(this.accessTokenExpiry - current);
            }
        } else {
            LOGGER.info("Refresh token has expired");
            this.invalidate();
        }
    }

    public String getOAuthGWServicesUrl() {
        return this.tokenHelper.getDomain();
    }

    public void invalidate() {
        if (this.userType == UserType.OPERATOR) {
            this.opInvalidateRunnable.run();
        }
        this.bioAuthToken = null;
        this.accessToken = null;
        this.accessTokenExpiry = -1L;
        this.refreshToken = null;
        this.refreshTokenExpiry = -1L;
        this.setValid(false);
    }

    public boolean isUniversalClientTransaction() {
        return this.isUniversalClientTransaction;
    }
}

