/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.oauthapi.token;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import org.bouncycastle.util.encoders.Hex;

public class TokenUtils {
    private static final String ALPHA_NUMERIC = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    private static final List<Character> CHARACTERS;
    private static final SecureRandom rnd;

    public static String randomString() {
        int len = 128;
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            sb.append(CHARACTERS.get(rnd.nextInt(CHARACTERS.size())));
        }
        return sb.toString();
    }

    public static String getCodeChallenge(String codeVerifier) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        byte[] digest = md.digest(codeVerifier.getBytes(StandardCharsets.UTF_8));
        return Base64.getUrlEncoder().encodeToString(Hex.encode((byte[])digest));
    }

    static {
        rnd = new SecureRandom();
        CHARACTERS = new ArrayList<Character>();
        char[] cArray = ALPHA_NUMERIC.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character ch = Character.valueOf(cArray[i]);
            CHARACTERS.add(ch);
        }
        Collections.shuffle(CHARACTERS);
    }
}

