/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.telemetry;

import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;

public class ConnectionTypeDetector {
    public static String getConnectionType() {
        StringBuilder result = new StringBuilder();
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface networkInterface = interfaces.nextElement();
                if (!networkInterface.isUp() || networkInterface.isLoopback()) continue;
                String name = networkInterface.getName();
                String displayName = networkInterface.getDisplayName();
                if (name.startsWith("eth")) {
                    result.append(name).append(" - LAN (Ethernet)");
                    continue;
                }
                if (name.startsWith("wlan") || name.startsWith("wi")) {
                    result.append(name).append(" - Wi-Fi");
                    continue;
                }
                if (name.startsWith("tun") || name.startsWith("tap") || name.startsWith("ppp")) {
                    result.append(name).append(" - Possible VPN");
                    continue;
                }
                if (name.contains("usb") || displayName.contains("usb") || displayName.contains("rndis") || displayName.contains("enp") || displayName.contains("enx")) {
                    result.append(name).append(" - USB");
                    continue;
                }
                result.append(name).append(" - Others");
            }
        }
        catch (SocketException e) {
            result.append("Error retrieving network interfaces").append(e.getMessage());
        }
        return result.toString();
    }

    public static String getPlatform() {
        return "OS Name: " + System.getProperty("os.name") + ", OS Version: " + System.getProperty("os.version") + ", OS Architecture: " + System.getProperty("os.arch");
    }
}

