/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.telemetry;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import com.google.protobuf.Message;
import com.sun.management.OperatingSystemMXBean;
import in.gov.uidai.ec.ApplicationContextProvider;
import in.gov.uidai.ec.ecmpapi.ClientInformation;
import in.gov.uidai.ec.oauthapi.IGatewayPreference;
import in.gov.uidai.ec.oauthapi.token.TokenManager;
import in.gov.uidai.ec.security.impl.SecureCommunicationBridge;
import in.gov.uidai.ec.telemetry.ConnectionTypeDetector;
import in.gov.uidai.ec.telemetry.TelemetryMetrics;
import in.gov.uidai.ec.telemetry.TelemetryUtil;
import in.gov.uidai.ec.telemetry.protobuf.Telemetryservice;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.time.Instant;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TelemetryService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TelemetryService.class);
    private String transactionId;
    private TokenManager opTokenManager;
    private ClientInformation clientInformation;
    private IGatewayPreference gatewayPreference;
    private static TelemetryService telemetryServiceInstance;
    private static final String ENV = "Prod";
    private static final String VERSION = "3.0";
    private String sid = "";

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public void setSid(String sid) {
        this.sid = sid;
    }

    public static TelemetryService getTelemetryServiceInstance() {
        if (telemetryServiceInstance == null) {
            telemetryServiceInstance = (TelemetryService)ApplicationContextProvider.getApplicationContext().getBean("telemetryService");
            try {
                telemetryServiceInstance.initTelemetryService();
            }
            catch (Exception e) {
                LOGGER.error("Could not init telemetry service", (Throwable)e);
                telemetryServiceInstance = null;
            }
        }
        return telemetryServiceInstance;
    }

    public String buildMetadataJson() {
        HashMap<String, String> metadataMap = new HashMap<String, String>();
        metadataMap.put("X-Request-Id", this.getTransactionId());
        if (this.opTokenManager != null && this.opTokenManager.getAccessToken() != null) {
            metadataMap.put("Authorization", "Bearer " + this.opTokenManager.getAccessToken());
        }
        metadataMap.put("client-version", VERSION);
        metadataMap.put("retry-count-tracker", "1");
        metadataMap.put("X-Machine-ID", this.clientInformation.getMachineCode());
        try {
            return new ObjectMapper().writeValueAsString(metadataMap);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize telemetry metadata", e);
        }
    }

    private void initTelemetryService() {
        SecureCommunicationBridge.getInstance().setDefaultGrpcUrl(this.gatewayPreference.getGrpcServicesUrl());
        this.scheduleCPUAndMemoryLog();
    }

    public void scheduleCPUAndMemoryLog() {
        Runnable sendCPUAndMemoryMetrics = () -> {
            try {
                if (this.getOpTokenManager() != null && this.getOpTokenManager().getAccessToken() != null) {
                    TelemetryUtil.sendTelemetry("SendMetrics", (Message)this.createMetricsRequestForCPUAndMemoryUtilization(), this.buildMetadataJson(), response -> LOGGER.debug("System metrics sent: {}", response), error -> LOGGER.warn("System metrics failed: {} : {}", (Object)error.getErrorCode(), (Object)error.getError()));
                }
            }
            catch (Exception e) {
                LOGGER.info("Unable to push CPU and Memory utilization data : {}", (Object)e.toString());
            }
        };
        Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate(sendCPUAndMemoryMetrics, 5L, 5L, TimeUnit.MINUTES);
    }

    public void postLogData(Exception exception, String errorCode, String ... servingDC) {
        String dc = servingDC != null && servingDC.length > 0 ? servingDC[0] : "";
        try {
            if (this.getOpTokenManager().isUniversalClientTransaction() && this.getOpTokenManager().getAccessToken() != null) {
                new Thread(() -> {
                    try {
                        TelemetryUtil.sendTelemetry("SendLogs", (Message)this.createLogRequest(exception, errorCode, dc), this.buildMetadataJson(), response -> LOGGER.debug("Telemetry success: {}", response), error -> LOGGER.warn("Telemetry failed: {} : {}", (Object)error.getErrorCode(), (Object)error.getError()));
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Telemetry thread failed: {}", (Object)ex.toString());
                    }
                }).start();
            }
        }
        catch (Exception e) {
            LOGGER.info("Unable to push log data : {}", (Object)e.toString());
        }
    }

    public void postMetricsData(String url, TelemetryMetrics metrics, long val, String ... servingDC) {
        String dc = servingDC != null && servingDC.length > 0 ? servingDC[0] : "";
        try {
            if (this.getOpTokenManager().isUniversalClientTransaction() && this.getOpTokenManager().getAccessToken() != null) {
                new Thread(() -> {
                    try {
                        TelemetryUtil.sendTelemetry("SendMetrics", (Message)this.createMetricsRequest(url, metrics, val, dc), this.buildMetadataJson(), response -> LOGGER.debug("Metrics sent: {}", response), error -> LOGGER.warn("Metrics failed: {} : {}", (Object)error.getErrorCode(), (Object)error.getError()));
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Async metrics push failed: {}", (Object)ex.toString());
                    }
                }).start();
            }
        }
        catch (Exception e) {
            LOGGER.info("Unable to push API metric data : {}", (Object)e.toString());
        }
    }

    public void postDebugData(String debugMessage, String ... servingDC) {
        String dc = servingDC != null && servingDC.length > 0 ? servingDC[0] : "";
        try {
            if (this.getOpTokenManager().isUniversalClientTransaction() && this.getOpTokenManager().getAccessToken() != null) {
                new Thread(() -> {
                    try {
                        TelemetryUtil.sendTelemetry("SendLogs", (Message)this.createDebugLogRequest(debugMessage, dc), this.buildMetadataJson(), response -> LOGGER.debug("Debug log sent: {}", response), error -> LOGGER.warn("Debug log failed: {} : {}", (Object)error.getErrorCode(), (Object)error.getError()));
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Async debug push failed: {}", (Object)ex.toString());
                    }
                }).start();
            }
        }
        catch (Exception e) {
            LOGGER.info("Unable to push debug log data : {}", (Object)e.toString());
        }
    }

    private Telemetryservice.LogRequest createLogRequest(Exception exception, String errorCode, String XServingDcValue) {
        StringWriter trace = new StringWriter();
        PrintWriter pw = new PrintWriter(trace);
        exception.printStackTrace(pw);
        String errorMessage = exception.getMessage();
        if (Strings.isNullOrEmpty((String)errorMessage)) {
            errorMessage = exception.getClass().toString();
        }
        return Telemetryservice.LogRequest.newBuilder().setEid(this.getTransactionId()).setVer(VERSION).setEts(String.valueOf(Instant.now().getEpochSecond())).setMid(UUID.randomUUID().toString()).setType("ERROR").setDc(XServingDcValue).setActor(Telemetryservice.IdAndType.newBuilder().setId(this.opTokenManager.getOperatorId()).setType(this.opTokenManager.getUserType().name()).build()).setContext(Telemetryservice.Context.newBuilder().setChannel(ConnectionTypeDetector.getConnectionType()).setEnv(ENV).setSid(this.sid).setPdata(Telemetryservice.Pdata.newBuilder().setId(this.clientInformation.getMachineCode()).setVer(this.clientInformation.getVersion()).setPlatform(ConnectionTypeDetector.getPlatform())).build()).setEdata(Telemetryservice.LogsEdata.newBuilder().setError(errorMessage).setErrorType(errorCode).setStacktrace(trace.toString()).build()).build();
    }

    private Telemetryservice.SendMetricsRequest createMetricsRequest(String url, TelemetryMetrics metrics, long val, String XServingDcValue) {
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        return Telemetryservice.SendMetricsRequest.newBuilder().setEid(this.getTransactionId()).setVer(VERSION).setEts(String.valueOf(Instant.now().getEpochSecond())).setMid(UUID.randomUUID().toString()).setActor(Telemetryservice.IdAndType.newBuilder().setId(this.opTokenManager.getOperatorId()).setType(this.opTokenManager.getUserType().name()).build()).setContext(Telemetryservice.Context.newBuilder().setChannel(ConnectionTypeDetector.getConnectionType()).setEnv(ENV).setSid(this.sid).setPdata(Telemetryservice.Pdata.newBuilder().setId(this.clientInformation.getMachineCode()).setVer(this.clientInformation.getVersion()).setPlatform(ConnectionTypeDetector.getPlatform())).build()).putEdata("uc_" + url + "_" + metrics.name().toLowerCase(), val).build();
    }

    private Telemetryservice.LogRequest createDebugLogRequest(String debugMessage, String XServingDcValue) {
        return Telemetryservice.LogRequest.newBuilder().setEid(this.getTransactionId()).setVer(VERSION).setEts(String.valueOf(Instant.now().getEpochSecond())).setMid(UUID.randomUUID().toString()).setType("DEBUG").setDc(XServingDcValue).setMessage(debugMessage).setActor(Telemetryservice.IdAndType.newBuilder().setId(this.opTokenManager.getOperatorId()).setType(this.opTokenManager.getUserType().name()).build()).setContext(Telemetryservice.Context.newBuilder().setChannel(ConnectionTypeDetector.getConnectionType()).setEnv(ENV).setSid(this.sid).setPdata(Telemetryservice.Pdata.newBuilder().setId(this.clientInformation.getMachineCode()).setVer(this.clientInformation.getVersion()).setPlatform(ConnectionTypeDetector.getPlatform())).build()).build();
    }

    private Telemetryservice.SendMetricsRequest createMetricsRequestForCPUAndMemoryUtilization() {
        OperatingSystemMXBean osBean = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);
        return Telemetryservice.SendMetricsRequest.newBuilder().setEid(this.getTransactionId()).setVer(VERSION).setEts(String.valueOf(Instant.now().getEpochSecond())).setMid(UUID.randomUUID().toString()).setActor(Telemetryservice.IdAndType.newBuilder().setId(this.opTokenManager.getOperatorId()).setType(this.opTokenManager.getUserType().name()).build()).setContext(Telemetryservice.Context.newBuilder().setChannel(ConnectionTypeDetector.getConnectionType()).setEnv(ENV).setSid(this.sid).setPdata(Telemetryservice.Pdata.newBuilder().setId(this.clientInformation.getMachineCode()).setVer(this.clientInformation.getVersion()).setPlatform(ConnectionTypeDetector.getPlatform())).build()).putEdata("uc_allocated_memory_mb", Runtime.getRuntime().totalMemory() / 0x100000L).putEdata("uc_used_memory_mb", (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 0x100000L).putEdata("uc_process_cpu_load_percent", (long)(osBean.getProcessCpuLoad() * 100.0)).putEdata("uc_system_cpu_load_percent", (long)(osBean.getSystemCpuLoad() * 100.0)).build();
    }

    public void setOpTokenManager(TokenManager opTokenManager) {
        this.opTokenManager = opTokenManager;
    }

    public void setClientInformation(ClientInformation clientInformation) {
        this.clientInformation = clientInformation;
    }

    public void setGatewayPreference(IGatewayPreference gatewayPreference) {
        this.gatewayPreference = gatewayPreference;
    }

    private TokenManager getOpTokenManager() {
        return this.opTokenManager;
    }

    private String getTransactionId() {
        if (Strings.isNullOrEmpty((String)this.transactionId)) {
            this.transactionId = !Strings.isNullOrEmpty((String)this.opTokenManager.getBioLoginTransactionId()) ? this.opTokenManager.getBioLoginTransactionId() : UUID.randomUUID().toString();
        }
        return this.transactionId;
    }
}

