/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.telemetry;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import com.google.protobuf.Message;
import in.gov.uidai.ec.grpc.LibGrpcResponse;
import in.gov.uidai.ec.oauthapi.exception.ErrorCodes;
import in.gov.uidai.ec.oauthapi.json.UosResponse;
import in.gov.uidai.ec.security.impl.SecureCommunicationBridge;
import in.gov.uidai.ec.telemetry.protobuf.Telemetryservice;
import java.util.Base64;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TelemetryUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(TelemetryUtil.class);
    private static final String SERVICE_NAME = "uos.UniversalOrchestrationService";
    private static final String ENV = "Prod";
    private static final String VERSION = "3.0";

    public static void sendTelemetry(String methodName, Message request, String metadataJson, Consumer<Telemetryservice.TelemetryRespose> onSuccess, Consumer<UosResponse> onError) {
        block7: {
            try {
                String response = SecureCommunicationBridge.getInstance().sendGrpcRequestWithDefaultValues(SERVICE_NAME, methodName, request.toByteArray(), metadataJson);
                ObjectMapper OM = new ObjectMapper();
                LibGrpcResponse grpcResponse = (LibGrpcResponse)OM.readValue(response, LibGrpcResponse.class);
                if (grpcResponse.success) {
                    byte[] payloadBytes = Base64.getDecoder().decode(grpcResponse.payload_base64);
                    Telemetryservice.TelemetryRespose parsed = Telemetryservice.TelemetryRespose.parseFrom(payloadBytes);
                    onSuccess.accept(parsed);
                    break block7;
                }
                UosResponse error = null;
                if (!Strings.isNullOrEmpty((String)grpcResponse.grpc_message)) {
                    try {
                        error = (UosResponse)OM.readValue(grpcResponse.grpc_message, UosResponse.class);
                        error.setErrorCode("TELEMETRY_ERROR");
                    }
                    catch (JsonProcessingException e) {
                        LOGGER.warn("Failed to parse gRPC message", (Throwable)e);
                    }
                }
                if (error == null) {
                    error = new UosResponse();
                    error.setErrorCode(ErrorCodes.UC_GEN_190.getErrorCode());
                    error.setError(grpcResponse.error != null ? grpcResponse.error : "Unknown gRPC bridge call failure");
                    error.setStatus("failure");
                }
                onError.accept(error);
            }
            catch (Exception e) {
                LOGGER.error("Telemetry bridge call failed", (Throwable)e);
            }
        }
    }
}

