/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.litef.beans;

import in.gov.uidai.litef.devapi.IVisualExecutionContext;
import in.gov.uidai.swing.TransparentBox;
import in.gov.uidai.swing.l10n.L10nDecorator;
import in.gov.uidai.swing.painter.LinearGradientBackground;
import in.gov.uidai.swing.table.TableLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;

public class ModalVisualExecutionContext
implements IVisualExecutionContext {
    private JComponent comp;
    private boolean allowCancel;
    private boolean initFlag;
    private JDialog theWin;
    private JLabel msgArea;
    private JProgressBar progress;
    private boolean cancel;
    private L10nDecorator ldeco;

    public ModalVisualExecutionContext(JComponent comp, boolean allowCancel) {
        this.comp = comp;
        this.allowCancel = allowCancel;
        this.initFlag = false;
    }

    public ModalVisualExecutionContext(JComponent comp, boolean allowCancel, L10nDecorator deco) {
        this(comp, allowCancel);
        this.ldeco = deco;
    }

    public ModalVisualExecutionContext(Component comp, boolean allowCancel, L10nDecorator deco) {
        this((JComponent)comp, allowCancel);
        this.ldeco = deco;
    }

    public void setL10nDecorator(L10nDecorator deco) {
        this.ldeco = deco;
    }

    private synchronized void checkAndPrepare() {
        if (this.initFlag) {
            return;
        }
        this.initFlag = true;
        this.theWin = this.comp == null ? new JDialog() : new JDialog(SwingUtilities.getWindowAncestor(this.comp));
        this.theWin.setModal(true);
        this.theWin.setUndecorated(true);
        this.theWin.setResizable(true);
        this.theWin.getRootPane().setBorder(new LineBorder(Color.YELLOW, 1, true));
        this.msgArea = new JLabel();
        this.progress = new JProgressBar();
        JButton cancelBut = new JButton("Cancel");
        TransparentBox cntPane = new TransparentBox();
        this.theWin.setContentPane(cntPane);
        LinearGradientBackground lgb = new LinearGradientBackground().borderSize(0.0f).direction(1).gradientColors("#f5f5b5, #f5f5dc, #f5f5b5").gradientStops("0, 0.8, 1").roundingSize(0, 0);
        cntPane.setBackground(lgb);
        if (this.allowCancel) {
            double[][] guides = new double[][]{{10.0, -2.0, 10.0}, {10.0, -2.0, 5.0, 20.0, 5.0, 22.0, 10.0}};
            cntPane.setLayout(new TableLayout(guides));
            cntPane.add((Component)this.msgArea, "1, 1, full, full");
            cntPane.add((Component)this.progress, "1, 3, full, full");
            cntPane.add((Component)cancelBut, "1, 5, center, full");
            cancelBut.addActionListener(evt -> this.cancel());
        } else {
            double[][] guides = new double[][]{{10.0, -2.0, 10.0}, {10.0, -2.0, 5.0, 20.0, 10.0}};
            cntPane.setLayout(new TableLayout(guides));
            cntPane.add((Component)this.msgArea, "1, 1, full, full");
            cntPane.add((Component)this.progress, "1, 3, full, full");
        }
        this.theWin.pack();
    }

    @Override
    public void reset() {
        this.checkAndPrepare();
        this.progress.setValue(0);
        this.cancel = false;
        this.progress.setIndeterminate(true);
        Rectangle rect = this.theWin.getGraphicsConfiguration().getBounds();
        Dimension winDim = this.theWin.getSize();
        int x = rect.x + rect.width / 2 - winDim.width / 2;
        int y = rect.y + rect.height / 2 - winDim.height / 2;
        this.theWin.setLocation(x, y);
        SwingUtilities.invokeLater(() -> this.theWin.setVisible(true));
    }

    @Override
    public void cancel() {
        this.checkAndPrepare();
        this.progress.setValue(0);
        this.cancel = true;
        SwingUtilities.invokeLater(() -> this.theWin.setVisible(false));
    }

    @Override
    public void complete() {
        this.checkAndPrepare();
        this.progress.setValue(this.progress.getMaximum());
        this.cancel = false;
    }

    @Override
    public boolean isCancelled() {
        return this.cancel;
    }

    @Override
    public void incrementMajor() {
    }

    @Override
    public void incrementMinor() {
        this.checkAndPrepare();
        int value = this.progress.getValue();
        if (value < this.progress.getMaximum()) {
            this.progress.setValue(value + 1);
        }
    }

    @Override
    public void setMessage(String msg) {
        this.checkAndPrepare();
        this.msgArea.setPreferredSize(null);
        this.msgArea.setText(msg);
        if (this.ldeco != null) {
            this.ldeco.localize(this.msgArea, (Object)msg, new Object[0]);
        }
        Dimension dim = this.msgArea.getPreferredSize();
        dim.width = Math.max(dim.width, 300);
        this.msgArea.setPreferredSize(dim);
        SwingUtilities.invokeLater(() -> {
            this.theWin.invalidate();
            this.theWin.pack();
        });
    }

    @Override
    public void setMinorRange(int range) {
        this.checkAndPrepare();
        this.progress.setMinimum(0);
        this.progress.setMaximum(range);
    }
}

