/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.litef.beans;

import in.gov.uidai.litef.devapi.IEventContext;
import in.gov.uidai.litef.devapi.ILiteScaffold;
import in.gov.uidai.litef.devapi.IOnScreenDisplay;
import in.gov.uidai.litef.devapi.IOnScreenDisplayAware;
import in.gov.uidai.litef.devapi.IScaffoldPeer;
import in.gov.uidai.litef.devapi.IViewElement;
import in.gov.uidai.litef.devapi.IViewPeer;
import in.gov.uidai.litef.devapi.IVisualExecutionContext;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import java.net.URL;
import java.security.SecureRandom;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanNameAware;

public class SimpleDialogPeer
implements IScaffoldPeer,
BeanNameAware,
IOnScreenDisplayAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleDialogPeer.class);
    private String id;
    private String parentId;
    private String type;
    private JDialog theWin;
    private IViewPeer vpeer;
    private String title;
    private String iconPath;
    private String winListenerId;
    private String escListenerId;
    private boolean resizeFlag = true;
    private boolean modalFlag;
    private boolean decorateFlag = true;
    private boolean alwaysOnTopFlag;
    private boolean closeOnEscFlag;
    private boolean actionOnEscFlag;
    private IEventContext evtCtxt;
    private WindowListener winHandler;
    private ActionListener escHandler;
    private ILiteScaffold scaffold = new SimpleDialogScaffold();
    private IVisualExecutionContext exeCtxt;
    private IOnScreenDisplay osd;

    @Override
    public final void populateOnScreenDisplay(IOnScreenDisplay osd) {
        this.osd = osd;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("osd populated");
        }
    }

    public final void setBeanName(String name) {
        SecureRandom random = new SecureRandom();
        this.type = name;
        this.id = this.type + ":" + System.currentTimeMillis() + ":" + random.nextInt() * 1000;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("bean name set to " + this.id);
        }
    }

    protected IVisualExecutionContext createVisualExecuionContext() {
        return null;
    }

    @Override
    public final void setEventContext(IEventContext ctxt) {
        this.evtCtxt = ctxt;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("event context set");
        }
    }

    @Override
    public final void setParent(String scaffoldId) {
        this.parentId = scaffoldId;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("parent scaffold set to " + this.parentId);
        }
    }

    @Override
    public final void addView(IViewPeer vpeer, String position) {
        this.setView(vpeer);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("view added " + vpeer.getView().getId());
        }
    }

    @Override
    public final void removeAllViews() {
        this.removeView(null);
    }

    @Override
    public final ILiteScaffold getScaffold() {
        return this.scaffold;
    }

    @Override
    public final Window getWindow() {
        return this.theWin;
    }

    @Override
    public final void prepare() {
        ClassLoader cl;
        Window parentWin = this.osd.getWindowForScaffold(this.parentId);
        this.theWin = parentWin != null ? new JDialog(parentWin) : new JDialog();
        this.theWin.setDefaultCloseOperation(0);
        if (this.title != null) {
            this.theWin.setTitle(this.title);
        }
        if ((cl = Thread.currentThread().getContextClassLoader()) == null) {
            cl = this.getClass().getClassLoader();
        }
        try {
            URL iconLoc = cl.getResource(this.iconPath);
            ImageIcon icon = new ImageIcon(iconLoc);
            this.theWin.setIconImage(icon.getImage());
        }
        catch (Exception iconLoc) {
            // empty catch block
        }
        this.theWin.setResizable(this.resizeFlag);
        this.theWin.setModal(this.modalFlag);
        this.theWin.setUndecorated(!this.decorateFlag);
        this.theWin.setAlwaysOnTop(this.alwaysOnTopFlag);
        this.exeCtxt = this.createVisualExecuionContext();
        if (this.winHandler == null && !StringUtils.isBlank((String)this.winListenerId)) {
            this.winHandler = this.evtCtxt.getEventListener(this.winListenerId, WindowListener.class);
            this.theWin.addWindowListener(this.winHandler);
        }
        if (this.closeOnEscFlag || this.actionOnEscFlag) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("setting up close on ESC behavior");
            }
            ActionMap axnMap = this.theWin.getRootPane().getActionMap();
            InputMap inputMap = this.theWin.getRootPane().getInputMap(1);
            AbstractAction action = this.closeOnEscFlag ? new CloseOnEscAction() : new OnEscAction();
            axnMap.put("CloseOnEscKey", action);
            inputMap.put(KeyStroke.getKeyStroke("ESCAPE"), "CloseOnEscKey");
            if (this.escHandler == null && !StringUtils.isBlank((String)this.escListenerId)) {
                this.escHandler = this.evtCtxt.getEventListener(this.escListenerId, ActionListener.class);
            }
        }
        this.afterPrepare();
    }

    @Override
    public final void removeView(String viewId) {
        this.theWin.setContentPane(new JPanel());
        this.theWin.getRootPane().setDefaultButton(null);
        this.theWin.invalidate();
        this.theWin.repaint();
        this.vpeer = null;
    }

    @Override
    public final void setView(IViewPeer vpeer) {
        if (this.vpeer != null) {
            IVisualExecutionContext eCtxt = this.vpeer.getView().getVisualExecutionContext();
            if (eCtxt != null) {
                eCtxt.cancel();
            }
            this.vpeer.dispose();
        }
        this.vpeer = vpeer;
        String vTitle = vpeer.getView().getTitle();
        if (StringUtils.isNotBlank((String)vTitle)) {
            this.theWin.setTitle(vTitle);
        }
        this.theWin.setContentPane(vpeer.getContentPane());
        this.theWin.setJMenuBar(vpeer.getMenuBar());
        this.theWin.getRootPane().setDefaultButton(vpeer.getDefaultButton());
        this.theWin.validate();
        JComponent defComp = vpeer.getDefaultComponent();
        if (defComp != null) {
            defComp.requestFocusInWindow();
        }
    }

    public final void setTitle(String title) {
        this.title = title;
    }

    public final void setIcon(String iconPath) {
        this.iconPath = iconPath;
    }

    public final void setWindowListenerId(String id) {
        this.winListenerId = id;
    }

    public final void setWindowEscListenerId(String id) {
        this.escListenerId = id;
    }

    public final void setResizable(boolean flag) {
        this.resizeFlag = flag;
    }

    public final void setModal(boolean flag) {
        this.modalFlag = flag;
    }

    public void setDecorated(boolean flag) {
        this.decorateFlag = flag;
    }

    public final void setAlwaysOnTop(boolean flag) {
        this.alwaysOnTopFlag = flag;
    }

    public final void setCloseOnEscKey(boolean flag) {
        this.closeOnEscFlag = flag;
    }

    public final void setActionOnEscKey(boolean flag) {
        this.actionOnEscFlag = flag;
    }

    protected final JComponent getRootPane() {
        return this.theWin.getRootPane();
    }

    protected void afterPrepare() {
    }

    private class OnEscAction
    extends AbstractAction {
        private OnEscAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (SimpleDialogPeer.this.escHandler != null) {
                SimpleDialogPeer.this.escHandler.actionPerformed(evt);
            }
        }
    }

    private class CloseOnEscAction
    extends AbstractAction {
        private CloseOnEscAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (SimpleDialogPeer.this.escHandler != null) {
                SimpleDialogPeer.this.escHandler.actionPerformed(evt);
            }
            SimpleDialogPeer.this.osd.dispose(SimpleDialogPeer.this.id);
        }
    }

    private class SimpleDialogScaffold
    implements ILiteScaffold {
        private SimpleDialogScaffold() {
        }

        @Override
        public String getId() {
            return SimpleDialogPeer.this.id;
        }

        @Override
        public String getParentId() {
            return SimpleDialogPeer.this.parentId;
        }

        @Override
        public String getType() {
            return SimpleDialogPeer.this.type;
        }

        @Override
        public String getViewId() {
            if (SimpleDialogPeer.this.vpeer == null) {
                return null;
            }
            return SimpleDialogPeer.this.vpeer.getView().getId();
        }

        @Override
        public String getViewId(String position) {
            return this.getViewId();
        }

        @Override
        public Map<String, IViewElement> getElementMap() {
            return null;
        }

        @Override
        public void switchView(String position) {
        }

        @Override
        public IVisualExecutionContext getVisualExecutionContext() {
            return SimpleDialogPeer.this.exeCtxt;
        }
    }
}

