/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.litef.beans.stdview;

import in.gov.uidai.litef.beans.stdview.ExportViewElement;
import in.gov.uidai.litef.beans.stdview.IViewElementComposite;
import in.gov.uidai.litef.beans.stdview.IViewElementFactory;
import in.gov.uidai.litef.devapi.IViewElement;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public class ElementMapBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElementMapBuilder.class);
    private Map<String, IViewElement> elementMap = new HashMap<String, IViewElement>();

    public ElementMapBuilder(IViewElementComposite target) {
        this.retrieveElementMap(target, target.getClass());
    }

    public Map<String, IViewElement> getElementMap() {
        return this.elementMap;
    }

    private void retrieveElementMap(Object peer, Class<?> type) {
        Field[] fieldList;
        if (type == null) {
            return;
        }
        for (Field field : fieldList = type.getDeclaredFields()) {
            Class<? extends IViewElementFactory> vefCls;
            String elementName;
            if (IViewElementComposite.class.isAssignableFrom(field.getType())) {
                try {
                    boolean oldStat = field.isAccessible();
                    ReflectionUtils.makeAccessible((Field)field);
                    IViewElementComposite value = (IViewElementComposite)field.get(peer);
                    field.setAccessible(oldStat);
                    if (value == null) continue;
                    this.retrieveElementMap(value, value.getClass());
                }
                catch (Exception exep) {
                    if (!LOGGER.isWarnEnabled()) continue;
                    LOGGER.warn("unable to retrieve value for: " + field.getName(), (Throwable)exep);
                }
                continue;
            }
            ExportViewElement eve = field.getAnnotation(ExportViewElement.class);
            if (eve == null || StringUtils.isBlank((String)(elementName = eve.as())) || (vefCls = eve.using()) == null) continue;
            IViewElementFactory vef = null;
            try {
                vef = vefCls.newInstance();
            }
            catch (Exception exep) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn("unable to instantiate view element factory for " + elementName);
                continue;
            }
            Object component = null;
            try {
                boolean oldStat = field.isAccessible();
                ReflectionUtils.makeAccessible((Field)field);
                component = field.get(peer);
            }
            catch (Exception exep) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn("unable to retrieve value for: " + elementName, (Throwable)exep);
                continue;
            }
            try {
                IViewElement ve = vef.get(component, elementName);
                this.elementMap.put(elementName, ve);
            }
            catch (Exception exep) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn("unable to create view element for: " + elementName, (Throwable)exep);
            }
        }
        this.retrieveElementMap(peer, type.getSuperclass());
    }
}

