/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.litef.beans.stdview;

import in.gov.uidai.ec.service.IStandardViewLoadListener;
import in.gov.uidai.litef.beans.stdview.ElementMapBuilder;
import in.gov.uidai.litef.beans.stdview.IViewElementComposite;
import in.gov.uidai.litef.devapi.IEventContext;
import in.gov.uidai.litef.devapi.ILiteView;
import in.gov.uidai.litef.devapi.IViewElement;
import in.gov.uidai.litef.devapi.IViewPeer;
import in.gov.uidai.litef.devapi.IVisualExecutionContext;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import javafx.embed.swing.JFXPanel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.springframework.beans.factory.BeanNameAware;

public abstract class StandardViewPeer
implements IViewPeer,
BeanNameAware,
IViewElementComposite {
    private JComponent contentPane;
    private JMenuBar menuBar;
    private JButton defBut;
    private JComponent defComp;
    public IEventContext evtCtxt;
    private String id;
    private String type;
    private String title;
    private DefaultView theView;
    private boolean validFlag;
    private IVisualExecutionContext exeCtxt;
    private Map<String, IViewElement> elementMap;
    private Map<String, Object> extraDataMap;
    protected IStandardViewLoadListener standardViewLoadListener;
    private JFXPanel jfxPanel = new JFXPanel();

    protected StandardViewPeer() {
        this.contentPane = new JPanel();
        this.menuBar = new JMenuBar();
        this.theView = new DefaultView();
        this.extraDataMap = new HashMap<String, Object>();
    }

    public void setBeanName(String name) {
        SecureRandom random = new SecureRandom();
        this.id = name + ":" + System.currentTimeMillis() + ":" + random.nextInt() * 1000;
        this.type = name;
    }

    protected abstract void prepareImpl();

    protected abstract void enableImpl(boolean var1);

    protected abstract void disposeImpl();

    protected final IEventContext getEventContext() {
        return this.evtCtxt;
    }

    protected final void setTitle(String title) {
        this.title = title;
    }

    protected final void setContentPane(JComponent cntPane) {
        this.contentPane = cntPane;
    }

    protected final void setJfxPanel(JFXPanel jfxPanel) {
        this.jfxPanel = jfxPanel;
    }

    protected final void setDefaultButton(JButton but) {
        this.defBut = but;
    }

    protected final void setDefaultComponent(JComponent comp) {
        this.defComp = comp;
    }

    protected final void setMenuBar(JMenuBar mb) {
        this.menuBar = mb;
    }

    protected final void setVisualExecutionContext(IVisualExecutionContext ctxt) {
        this.exeCtxt = ctxt;
    }

    @Override
    public final JComponent getContentPane() {
        return this.contentPane;
    }

    @Override
    public final JMenuBar getMenuBar() {
        return this.menuBar;
    }

    @Override
    public final JButton getDefaultButton() {
        return this.defBut;
    }

    @Override
    public final JComponent getDefaultComponent() {
        return this.defComp;
    }

    @Override
    public final ILiteView getView() {
        return this.theView;
    }

    @Override
    public final void setEventContext(IEventContext ctxt) {
        if (this.evtCtxt == null) {
            this.evtCtxt = ctxt;
        }
    }

    @Override
    public final void prepare() {
        this.prepareImpl();
        ElementMapBuilder emb = new ElementMapBuilder(this);
        this.elementMap = emb.getElementMap();
        this.validFlag = true;
        if (this.standardViewLoadListener != null) {
            this.standardViewLoadListener.fireViewLoadComplete();
        }
    }

    @Override
    public final void dispose() {
        this.validFlag = false;
        Runnable runnable = () -> {
            this.disposeImpl();
            this.defBut = null;
            this.defComp = null;
            if (this.elementMap != null) {
                this.elementMap.clear();
            }
            this.elementMap = null;
            if (this.extraDataMap != null) {
                this.extraDataMap.clear();
            }
            this.extraDataMap = null;
            this.exeCtxt = null;
            if (this.menuBar != null) {
                this.menuBar.invalidate();
            }
            this.menuBar = null;
            if (this.contentPane != null) {
                this.contentPane.removeAll();
            }
            this.contentPane = null;
        };
        SwingUtilities.invokeLater(runnable);
    }

    protected void setStandardViewListener(IStandardViewLoadListener standardViewLoadListener) {
        this.standardViewLoadListener = standardViewLoadListener;
    }

    public JFXPanel getJfxPanel() {
        return this.jfxPanel;
    }

    private final class DefaultView
    implements ILiteView {
        private DefaultView() {
        }

        @Override
        public Map<String, IViewElement> getElementMap() {
            return StandardViewPeer.this.elementMap;
        }

        @Override
        public String getId() {
            return StandardViewPeer.this.id;
        }

        @Override
        public String getTitle() {
            return StandardViewPeer.this.title;
        }

        @Override
        public String getType() {
            return StandardViewPeer.this.type;
        }

        @Override
        public IVisualExecutionContext getVisualExecutionContext() {
            return StandardViewPeer.this.exeCtxt;
        }

        @Override
        public void setEnabled(boolean flag) {
            StandardViewPeer.this.enableImpl(flag);
        }

        @Override
        public boolean isValid() {
            return StandardViewPeer.this.validFlag;
        }

        @Override
        public Map<String, Object> getExtraDataMap() {
            return StandardViewPeer.this.extraDataMap;
        }
    }
}

