/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.litef.beans.tsb;

import in.gov.uidai.litef.beans.tsb.ITsbDecorator;
import in.gov.uidai.litef.beans.tsb.SessionTimeoutListener;
import in.gov.uidai.litef.beans.tsb.TsbFrame;
import in.gov.uidai.litef.devapi.IEventContext;
import in.gov.uidai.litef.devapi.ILiteScaffold;
import in.gov.uidai.litef.devapi.IScaffoldPeer;
import in.gov.uidai.litef.devapi.IViewElement;
import in.gov.uidai.litef.devapi.IViewPeer;
import in.gov.uidai.litef.devapi.IVisualExecutionContext;
import in.gov.uidai.swing.l10n.L10nOptionPaneBuilder;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowListener;
import java.security.SecureRandom;
import java.util.Map;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;

public class TsbFramePeer
implements IScaffoldPeer,
BeanNameAware,
InitializingBean {
    private static final int sessionTimeOut = 60;
    private String id;
    private String type;
    private TsbFrame theWin;
    private IViewPeer vpeer;
    private String title;
    private String iconPath;
    private String winListenerId;
    private boolean resizeFlag = true;
    private boolean decorateFlag = true;
    private IEventContext evtCtxt;
    private ILiteScaffold scaffold;
    private ITsbDecorator tsbDecorator;
    private IVisualExecutionContext exeCtxt;
    private SessionTimeoutListener sessionTimeoutListener;

    public void setBeanName(String name) {
        SecureRandom random = new SecureRandom();
        this.type = name;
        this.id = this.type + ":" + System.currentTimeMillis() + ":" + random.nextInt() * 1000;
    }

    public void afterPropertiesSet() {
        ClassLoader cl;
        this.theWin = new TsbFrame();
        this.theWin.setDefaultCloseOperation(0);
        if (this.title != null) {
            this.theWin.setTitle(this.title);
        }
        if ((cl = Thread.currentThread().getContextClassLoader()) == null) {
            cl = this.getClass().getClassLoader();
        }
        try {
            this.theWin.setIconImage(new ImageIcon(Objects.requireNonNull(cl.getResource(this.iconPath))).getImage());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.theWin.setResizable(this.resizeFlag);
        this.theWin.setUndecorated(!this.decorateFlag);
        this.scaffold = new SimpleFrameScaffold();
        this.exeCtxt = this.createVisualExecutionContext();
        AbstractAction logout = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                L10nOptionPaneBuilder.getInstance().showError("<html> <Font size=\"3\">You're being timed out due to inactivity for more than 60 minutes.<br> And now you will be logged off automatically.</Font?></html>", SwingUtilities.getWindowAncestor((TsbFrame)e.getSource()), new Object[0]);
                TsbFramePeer.this.sessionTimeoutListener.stop();
                System.exit(0);
            }
        };
        this.sessionTimeoutListener = new SessionTimeoutListener(this.theWin, logout, 60);
        this.sessionTimeoutListener.start();
    }

    protected IVisualExecutionContext createVisualExecutionContext() {
        return null;
    }

    @Override
    public final void setEventContext(IEventContext ctxt) {
        this.evtCtxt = ctxt;
    }

    @Override
    public final void setParent(String scaffoldId) {
    }

    @Override
    public final void addView(IViewPeer vpeer, String position) {
        this.setView(vpeer);
    }

    @Override
    public final void removeAllViews() {
        this.removeView(null);
    }

    @Override
    public final ILiteScaffold getScaffold() {
        return this.scaffold;
    }

    @Override
    public final Window getWindow() {
        return this.theWin;
    }

    @Override
    public final void prepare() {
        if (!StringUtils.isEmpty((String)this.winListenerId)) {
            this.theWin.addWindowListener(this.evtCtxt.getEventListener(this.winListenerId, WindowListener.class));
        }
        if (this.tsbDecorator != null) {
            JComponent statusBar;
            this.tsbDecorator.setEventContext(this.evtCtxt);
            this.tsbDecorator.prepare();
            JToolBar toolBar = this.tsbDecorator.getToolBar();
            if (toolBar != null) {
                this.theWin.setToolBar(toolBar);
            }
            if ((statusBar = this.tsbDecorator.getStatusBar()) != null) {
                this.theWin.setStatusBar(statusBar);
            }
        }
        this.theWin.validate();
    }

    @Override
    public final void removeView(String viewId) {
        this.theWin.setContentPane(new JPanel());
        this.theWin.getRootPane().setDefaultButton(null);
        this.theWin.invalidate();
        this.theWin.repaint();
        this.vpeer = null;
    }

    @Override
    public final void setView(IViewPeer vpeer) {
        if (this.vpeer != null) {
            IVisualExecutionContext eCtxt = this.vpeer.getView().getVisualExecutionContext();
            if (eCtxt != null) {
                eCtxt.cancel();
            }
            this.vpeer.dispose();
        }
        this.vpeer = vpeer;
        this.theWin.setContentPane(vpeer.getContentPane());
        this.theWin.setJMenuBar(vpeer.getMenuBar());
        this.theWin.getRootPane().setDefaultButton(vpeer.getDefaultButton());
        this.theWin.validate();
        JComponent defComp = vpeer.getDefaultComponent();
        if (defComp != null) {
            defComp.requestFocusInWindow();
        }
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setIcon(String iconPath) {
        this.iconPath = iconPath;
    }

    public void setWindowListenerId(String id) {
        this.winListenerId = id;
    }

    public void setResizable(boolean flag) {
        this.resizeFlag = flag;
    }

    public void setDecorated(boolean flag) {
        this.decorateFlag = flag;
    }

    public void setDecorator(ITsbDecorator deco) {
        this.tsbDecorator = deco;
    }

    private class SimpleFrameScaffold
    implements ILiteScaffold {
        private SimpleFrameScaffold() {
        }

        @Override
        public String getId() {
            return TsbFramePeer.this.id;
        }

        @Override
        public String getParentId() {
            return null;
        }

        @Override
        public String getType() {
            return TsbFramePeer.this.type;
        }

        @Override
        public String getViewId() {
            return TsbFramePeer.this.vpeer != null ? TsbFramePeer.this.vpeer.getView().getId() : null;
        }

        @Override
        public String getViewId(String position) {
            return this.getViewId();
        }

        @Override
        public Map<String, IViewElement> getElementMap() {
            return TsbFramePeer.this.tsbDecorator != null ? TsbFramePeer.this.tsbDecorator.getElementMap() : null;
        }

        @Override
        public void switchView(String position) {
        }

        @Override
        public IVisualExecutionContext getVisualExecutionContext() {
            return TsbFramePeer.this.exeCtxt;
        }
    }
}

