/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.litef.kernel;

import in.gov.uidai.ec.icas.logging.TimeLineMap;
import in.gov.uidai.litef.devapi.IEventContext;
import in.gov.uidai.litef.kernel.EventHandlerRegistry;
import in.gov.uidai.litef.kernel._EventContext;
import in.gov.uidai.litef.kernel._EventContextThreadFactory;
import in.gov.uidai.litef.kernel._LiteEvent;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class EventContextFactory
implements InitializingBean,
DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventContextFactory.class);
    private ThreadPoolExecutor executor;
    private EventHandlerRegistry registry;

    public void setEventHandlerRegistry(EventHandlerRegistry reg) {
        this.registry = reg;
        LOGGER.debug("event handler registry set");
    }

    public IEventContext createContext() {
        _EventContext result = new _EventContext();
        result.setEventContextFactory(this);
        return result;
    }

    public synchronized void executeEvent(TimeLineMap tlm, String hId, _LiteEvent evt) {
        EventTask task = new EventTask(tlm, hId, evt);
        this.executor.execute(task);
    }

    public synchronized void executeGenericEvent(TimeLineMap tlm, String hId, Object ... params) {
        GenericEventTask task = new GenericEventTask(tlm, hId, params);
        this.executor.execute(task);
    }

    public void afterPropertiesSet() {
        _EventContextThreadFactory thrdFactory = new _EventContextThreadFactory();
        this.executor = new ThreadPoolExecutor(10, 10, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), thrdFactory);
        this.executor.allowCoreThreadTimeOut(true);
        LOGGER.debug("created");
    }

    public void destroy() {
        this.executor.shutdownNow();
        LOGGER.debug("stopped");
    }

    private class GenericEventTask
    implements Runnable {
        private String handlerId;
        private Object[] parameters;
        private TimeLineMap tlm;

        private GenericEventTask(TimeLineMap tlm, String hId, Object[] params) {
            this.handlerId = hId;
            this.parameters = params;
            this.tlm = tlm;
        }

        @Override
        public void run() {
            LOGGER.debug("delegating to generic handlerId: {}", (Object)this.handlerId);
            TimeLineMap.setInst((TimeLineMap)this.tlm);
            EventContextFactory.this.registry.handleGenericEvent(this.handlerId, this.parameters);
        }
    }

    private class EventTask
    implements Runnable {
        private String handlerId;
        private _LiteEvent event;
        private TimeLineMap tlm;

        private EventTask(TimeLineMap tlm, String hId, _LiteEvent evt) {
            this.handlerId = hId;
            this.event = evt;
            this.tlm = tlm;
        }

        @Override
        public void run() {
            LOGGER.debug("delegating to handlerId: {}", (Object)this.handlerId);
            TimeLineMap.setInst((TimeLineMap)this.tlm);
            EventContextFactory.this.registry.handleEvent(this.handlerId, this.event);
        }
    }
}

