/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.litef.kernel;

import in.gov.uidai.litef.devapi.EventHandler;
import in.gov.uidai.litef.devapi.GenericEventHandler;
import in.gov.uidai.litef.devapi.ILiteEvent;
import in.gov.uidai.litef.kernel._LiteEvent;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class EventHandlerRegistry
implements ApplicationContextAware,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventHandlerRegistry.class);
    private ApplicationContext appCtxt;
    private Map<String, String> genHndlrBeanMap = new HashMap<String, String>();
    private Map<String, String> hndlrBeanMap = new HashMap<String, String>();
    private Map<String, String> hndlrMethodMap = new HashMap<String, String>();

    public EventHandlerRegistry() {
        LOGGER.debug("created");
    }

    public void setApplicationContext(ApplicationContext ctxt) {
        this.appCtxt = ctxt;
        LOGGER.debug("spring application context set");
    }

    public void afterPropertiesSet() {
        String[] allBeans;
        for (String beanId : allBeans = this.appCtxt.getBeanDefinitionNames()) {
            Class beanCls = this.appCtxt.getType(beanId);
            this.findGenericEventHandlers(beanId, beanCls);
            this.findEventHandlers(beanId, beanCls);
        }
    }

    public void handleEvent(String handlerId, _LiteEvent evt) {
        String hId = handlerId.toLowerCase() + ":" + (StringUtils.isEmpty((String)evt.getMethodName()) ? "*" : evt.getMethodName().toLowerCase());
        String beanId = this.hndlrBeanMap.get(hId);
        if (beanId == null) {
            return;
        }
        String methodName = this.hndlrMethodMap.get(hId);
        Class beanCls = this.appCtxt.getType(beanId);
        Method mthd = null;
        try {
            mthd = beanCls.getMethod(methodName, new Class[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (mthd == null) {
            try {
                mthd = beanCls.getMethod(methodName, ILiteEvent.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (mthd == null) {
            return;
        }
        try {
            mthd.invoke(this.appCtxt.getBean(beanId), evt);
        }
        catch (Exception exep) {
            LOGGER.error("handler execution failed " + methodName + beanId, (Throwable)exep);
        }
    }

    public void handleGenericEvent(String handlerId, Object ... params) {
        Method[] methods;
        String hId = handlerId.toLowerCase();
        String beanId = this.genHndlrBeanMap.get(hId);
        if (beanId == null) {
            return;
        }
        Class beanCls = this.appCtxt.getType(beanId);
        for (Method mthd : methods = beanCls.getMethods()) {
            String ghId;
            GenericEventHandler geh;
            Class<?> retCls = mthd.getReturnType();
            if (retCls != null && !retCls.equals(Void.TYPE) || (geh = mthd.getAnnotation(GenericEventHandler.class)) == null || !StringUtils.equalsIgnoreCase((String)(ghId = geh.value()), (String)hId)) continue;
            try {
                mthd.invoke(this.appCtxt.getBean(beanId), params);
            }
            catch (Exception exep) {
                LOGGER.error("generic handler execution failed " + mthd.getName() + " " + beanId, (Throwable)exep);
            }
            break;
        }
    }

    private void findGenericEventHandlers(String beanId, Class<?> rootCls) {
        Method[] mthdList;
        if (rootCls == null) {
            return;
        }
        for (Method method : mthdList = rootCls.getDeclaredMethods()) {
            GenericEventHandler geh;
            Class<?> retCls;
            int modifiers = method.getModifiers();
            if (!Modifier.isPublic(modifiers) || Modifier.isStatic(modifiers) || Modifier.isAbstract(modifiers) || (retCls = method.getReturnType()) != null && !retCls.equals(Void.TYPE) || (geh = method.getAnnotation(GenericEventHandler.class)) == null) continue;
            String handlerId = geh.value().toLowerCase();
            this.genHndlrBeanMap.put(handlerId, beanId);
        }
        this.findGenericEventHandlers(beanId, rootCls.getSuperclass());
    }

    private void findEventHandlers(String beanId, Class<?> rootCls) {
        Method[] mthdList;
        if (rootCls == null) {
            return;
        }
        for (Method method : mthdList = rootCls.getDeclaredMethods()) {
            EventHandler eh;
            Class<?>[] paramTypes;
            Class<?> retCls;
            int modifiers = method.getModifiers();
            if (!Modifier.isPublic(modifiers) || Modifier.isStatic(modifiers) || Modifier.isAbstract(modifiers) || (retCls = method.getReturnType()) != null && !retCls.equals(Void.TYPE) || (paramTypes = method.getParameterTypes()) != null && paramTypes.length > 0 && (paramTypes.length != 1 || !paramTypes[0].equals(ILiteEvent.class)) || (eh = method.getAnnotation(EventHandler.class)) == null) continue;
            String handlerId = eh.name().toLowerCase() + ":" + (StringUtils.isEmpty((String)eh.method()) ? "*" : eh.method().toLowerCase());
            this.hndlrBeanMap.put(handlerId, beanId);
            this.hndlrMethodMap.put(handlerId, method.getName());
        }
        this.findEventHandlers(beanId, rootCls.getSuperclass());
    }
}

