/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.litef.kernel;

import in.gov.uidai.litef.devapi.IEventContext;
import in.gov.uidai.litef.devapi.ILiteScaffold;
import in.gov.uidai.litef.devapi.ILiteView;
import in.gov.uidai.litef.devapi.IOnScreenDisplay;
import in.gov.uidai.litef.devapi.IScaffoldPeer;
import in.gov.uidai.litef.devapi.IViewPeer;
import in.gov.uidai.litef.devapi.ScaffoldPlacement;
import in.gov.uidai.litef.kernel.EventContextFactory;
import in.gov.uidai.litef.kernel.WeakValueMap;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class OnScreenDisplay
implements IOnScreenDisplay,
ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(OnScreenDisplay.class);
    private final Map<String, IScaffoldPeer> scaffoldPeerMap = new WeakValueMap<String, IScaffoldPeer>();
    private final Map<String, IScaffoldPeer> globalScaffoldPeerMap = new WeakValueMap<String, IScaffoldPeer>();
    private final Map<String, IViewPeer> viewPeerMap = new WeakValueMap<String, IViewPeer>();
    private final Map<String, String> viewScaffoldMap = new HashMap<String, String>();
    private ApplicationContext appCtxt;
    private EventContextFactory ecfac;

    OnScreenDisplay() {
    }

    public void setApplicationContext(ApplicationContext ctxt) {
        this.appCtxt = ctxt;
    }

    public void setEventContextFactory(EventContextFactory ecf) {
        this.ecfac = ecf;
    }

    @Override
    public String compose(String scaffoldType, String viewType) {
        return this.compose(null, scaffoldType, viewType);
    }

    @Override
    public String compose(String parentScaffoldId, String scaffoldType, String viewType) {
        LOGGER.debug("composing with pId: {}, scaffold peer {}, view peer {} ", new Object[]{parentScaffoldId, scaffoldType, viewType});
        if (!StringUtils.isBlank((String)parentScaffoldId) && !this.appCtxt.isPrototype(scaffoldType)) {
            LOGGER.error("scaffold peer bean must be a prototype to take a parent id");
            return null;
        }
        if (!this.appCtxt.isPrototype(viewType)) {
            LOGGER.error("view peer bean must be a prototype");
            return null;
        }
        IScaffoldPeer speer = (IScaffoldPeer)this.appCtxt.getBean(scaffoldType, IScaffoldPeer.class);
        IEventContext sEvtCtxt = this.ecfac.createContext();
        sEvtCtxt.setScaffoldId(speer.getScaffold().getId());
        speer.setEventContext(sEvtCtxt);
        if (this.appCtxt.isSingleton(scaffoldType)) {
            if (!this.globalScaffoldPeerMap.values().contains(speer)) {
                speer.prepare();
                this.globalScaffoldPeerMap.put(speer.getScaffold().getId(), speer);
            }
        } else {
            speer.setParent(parentScaffoldId);
            speer.prepare();
            this.scaffoldPeerMap.put(speer.getScaffold().getId(), speer);
        }
        IEventContext vEvtCtxt = this.ecfac.createContext();
        vEvtCtxt.setScaffoldId(speer.getScaffold().getId());
        IViewPeer vpeer = (IViewPeer)this.appCtxt.getBean(viewType, IViewPeer.class);
        vEvtCtxt.setViewId(vpeer.getView().getId());
        vpeer.setEventContext(vEvtCtxt);
        vpeer.prepare();
        speer.setView(vpeer);
        this.viewPeerMap.put(vpeer.getView().getId(), vpeer);
        this.viewScaffoldMap.put(vpeer.getView().getId(), speer.getScaffold().getId());
        return speer.getScaffold().getId();
    }

    @Override
    public String recompose(String scaffoldId, String viewType, String position) {
        if (!this.appCtxt.isPrototype(viewType)) {
            LOGGER.error("view peer bean must be a prototype");
            return null;
        }
        IScaffoldPeer speer = this.scaffoldPeerMap.get(scaffoldId);
        if (speer == null) {
            speer = this.globalScaffoldPeerMap.get(scaffoldId);
        }
        if (speer == null) {
            LOGGER.warn("scaffold id: {} not found to recompose", (Object)scaffoldId);
            return null;
        }
        IEventContext evtCtxt = this.ecfac.createContext();
        evtCtxt.setScaffoldId(speer.getScaffold().getId());
        IViewPeer vpeer = (IViewPeer)this.appCtxt.getBean(viewType, IViewPeer.class);
        evtCtxt.setViewId(vpeer.getView().getId());
        vpeer.setEventContext(evtCtxt);
        vpeer.prepare();
        if (StringUtils.isBlank((String)position)) {
            speer.setView(vpeer);
        } else {
            speer.addView(vpeer, position);
        }
        this.viewPeerMap.remove(vpeer.getView().getId());
        this.viewScaffoldMap.remove(vpeer.getView().getId());
        this.viewPeerMap.put(vpeer.getView().getId(), vpeer);
        this.viewScaffoldMap.put(vpeer.getView().getId(), speer.getScaffold().getId());
        return speer.getScaffold().getId();
    }

    @Override
    public String recompose(String scaffoldId, String viewType) {
        return this.recompose(scaffoldId, viewType, null);
    }

    @Override
    public void display(String scaffoldId, ScaffoldPlacement placement) {
        IScaffoldPeer speer = this.globalScaffoldPeerMap.get(scaffoldId);
        if (speer != null) {
            if (speer.getWindow().isVisible()) {
                speer.getWindow().toFront();
                return;
            }
        } else {
            speer = this.scaffoldPeerMap.get(scaffoldId);
            if (speer == null) {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error("scaffold peer not found for id: " + scaffoldId);
                }
                return;
            }
        }
        speer.getWindow().pack();
        if (placement == null) {
            speer.getWindow().setVisible(true);
            return;
        }
        switch (placement) {
            case FULL_SCREEN: {
                GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
                if (!gd.isFullScreenSupported()) break;
                gd.setFullScreenWindow(speer.getWindow());
                break;
            }
            case MAXIMIZED: {
                if (!(speer.getWindow() instanceof Frame)) break;
                Frame frm = (Frame)speer.getWindow();
                frm.setExtendedState(6);
                break;
            }
            case MINIMIZED: {
                if (!(speer.getWindow() instanceof Frame)) break;
                Frame frm = (Frame)speer.getWindow();
                frm.setExtendedState(1);
                break;
            }
            case CENTERED: {
                Dimension winDim = speer.getWindow().getSize();
                String pId = speer.getScaffold().getParentId();
                if (!StringUtils.isBlank((String)pId)) {
                    IScaffoldPeer parentPeer = this.scaffoldPeerMap.get(pId);
                    if (parentPeer == null) {
                        parentPeer = this.globalScaffoldPeerMap.get(pId);
                    }
                    if (parentPeer != null) {
                        Dimension prnDim = parentPeer.getWindow().getSize();
                        Point prnLoc = parentPeer.getWindow().getLocationOnScreen();
                        int x = prnDim.width / 2 - winDim.width / 2 + prnLoc.x;
                        int y = prnDim.height / 2 - winDim.height / 2 + prnLoc.y;
                        speer.getWindow().setLocation(x, y);
                        break;
                    }
                    if (!LOGGER.isDebugEnabled()) break;
                    LOGGER.debug("parent scaffold not found - " + pId);
                    break;
                }
                Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
                int x = screenDim.width / 2 - winDim.width / 2;
                int y = screenDim.height / 2 - winDim.height / 2;
                speer.getWindow().setLocation(x, y);
            }
        }
        new WinDisplayThread(speer.getWindow()).start();
    }

    @Override
    public void dispose(String scaffoldId) {
        ArrayList<String> delViewIdList = new ArrayList<String>();
        Set<String> viewIdList = this.viewScaffoldMap.keySet();
        for (String viewId : viewIdList) {
            String scafId = this.viewScaffoldMap.get(viewId);
            if (StringUtils.isBlank((String)scafId) || !scafId.equalsIgnoreCase(scaffoldId)) continue;
            delViewIdList.add(viewId);
        }
        IScaffoldPeer speer = this.globalScaffoldPeerMap.get(scaffoldId);
        if (speer != null) {
            speer.removeAllViews();
            speer.getWindow().dispose();
        } else {
            speer = this.scaffoldPeerMap.get(scaffoldId);
            if (speer != null) {
                speer.getWindow().setVisible(false);
                speer.getWindow().dispose();
            }
            this.scaffoldPeerMap.remove(scaffoldId);
        }
        for (String viewId : delViewIdList) {
            this.viewPeerMap.remove(viewId);
            this.viewScaffoldMap.remove(viewId);
        }
    }

    @Override
    public void disposeView(String viewId) {
    }

    @Override
    public ILiteScaffold getScaffold(String id) {
        IScaffoldPeer speer = this.scaffoldPeerMap.get(id);
        if (speer == null) {
            speer = this.globalScaffoldPeerMap.get(id);
        }
        if (speer == null) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("scaffold peer not found for id: " + id);
            }
            return null;
        }
        return speer.getScaffold();
    }

    @Override
    public ILiteScaffold getScaffoldForView(String id) {
        String scaffoldId = this.viewScaffoldMap.get(id);
        if (scaffoldId == null) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("scaffold id not found for view id: " + id);
            }
            return null;
        }
        IScaffoldPeer speer = this.scaffoldPeerMap.get(scaffoldId);
        if (speer == null) {
            speer = this.globalScaffoldPeerMap.get(scaffoldId);
        }
        if (speer == null) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("scaffold peer not found for id: " + id);
            }
            return null;
        }
        return speer.getScaffold();
    }

    @Override
    public ILiteView getView(String id) {
        IViewPeer vpeer = this.viewPeerMap.get(id);
        if (vpeer == null) {
            LOGGER.error("view peer not found for id: " + id);
            return null;
        }
        return vpeer.getView();
    }

    @Override
    public Window getWindowForScaffold(String id) {
        if (!StringUtils.isBlank((String)id)) {
            IScaffoldPeer speer = this.scaffoldPeerMap.get(id);
            if (speer == null) {
                speer = this.globalScaffoldPeerMap.get(id);
            }
            if (speer == null) {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error("scaffold peer not found for id: " + id);
                }
                return null;
            }
            return speer.getWindow();
        }
        return null;
    }

    private class WinDisplayThread
    extends Thread {
        private Window win;

        public WinDisplayThread(Window win) {
            super("window display thread");
            this.setDaemon(true);
            this.win = win;
        }

        @Override
        public void run() {
            this.win.setVisible(true);
        }
    }
}

