/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.litef.kernel;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class WeakValueMap<K, V>
implements Map<K, V> {
    private HashMap<K, WeakReference<V>> theMap = new HashMap();
    private ReferenceQueue<V> refQueue = new ReferenceQueue();
    private Thread gcThrd;

    public WeakValueMap() {
        Runnable gc = new Runnable(){

            @Override
            public void run() {
                WeakValueMap.this.runImpl();
            }
        };
        this.gcThrd = new Thread(gc, "WeakHashMap GC");
        this.gcThrd.setDaemon(true);
        this.gcThrd.start();
    }

    @Override
    public void clear() {
        this.theMap.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.theMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        Iterator<WeakReference<V>> iter = this.theMap.values().iterator();
        while (iter.hasNext()) {
            Object val = iter.next().get();
            if (val == null || !val.equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        if (this.theMap.containsKey(key)) {
            return (V)this.theMap.get(key).get();
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.theMap.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.theMap.keySet();
    }

    @Override
    public V put(K key, V value) {
        WeakReference<V> oldVal = this.theMap.put(key, new WeakReference<V>(value));
        if (oldVal != null) {
            return (V)oldVal.get();
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (K key : map.keySet()) {
            V value = map.get(key);
            this.put(key, value);
        }
    }

    @Override
    public V remove(Object key) {
        WeakReference<V> value = this.theMap.remove(key);
        if (value != null) {
            return (V)value.get();
        }
        return null;
    }

    @Override
    public int size() {
        return this.theMap.size();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Iterator<Map.Entry<K, WeakReference<V>>> iter = this.theMap.entrySet().iterator();
        HashSet<Map.Entry<K, V>> result = new HashSet<Map.Entry<K, V>>();
        while (iter.hasNext()) {
            Object value;
            Map.Entry<K, WeakReference<V>> entry = iter.next();
            if (entry.getValue() == null || (value = entry.getValue().get()) == null) continue;
            AbstractMap.SimpleEntry rentry = new AbstractMap.SimpleEntry(entry.getKey(), value);
            result.add(rentry);
        }
        return result;
    }

    @Override
    public Collection<V> values() {
        ArrayList result = new ArrayList();
        Iterator<WeakReference<V>> iter = this.theMap.values().iterator();
        while (iter.hasNext()) {
            Object value = iter.next().get();
            if (value == null) continue;
            result.add(value);
        }
        return result;
    }

    protected void finalize() throws Throwable {
        this.gcThrd.interrupt();
        super.finalize();
    }

    /*
     * Unable to fully structure code
     */
    private void runImpl() {
        value = null;
        block2: while (true) {
            try {
                value = this.refQueue.remove(10000L);
            }
            catch (InterruptedException exep) {
                break;
            }
            if (value == null) continue;
            value = null;
            iter = this.theMap.keySet().iterator();
            while (true) {
                if (iter.hasNext()) ** break;
                continue block2;
                key = iter.next();
                if (this.get(key) != null) continue;
                this.theMap.remove(key);
            }
            break;
        }
    }
}

