/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.litef.widgets;

import in.gov.uidai.litef.devapi.IViewElement;
import in.gov.uidai.litef.widgets.BeanTableModel;
import in.gov.uidai.litef.widgets.ViewElement;
import java.util.Arrays;
import java.util.List;
import javax.swing.JTable;
import org.apache.commons.lang.StringUtils;

public class BeanTableElement
extends ViewElement {
    public static final String KEY_VALUE = "value";
    public static final String KEY_SELECTED_ROWS = "selectedRows";
    private final transient JTable theTable;
    private final transient BeanTableModel theModel;

    public BeanTableElement(JTable table, BeanTableModel model, String name) {
        super(table, name);
        this.theTable = table;
        this.theModel = model;
    }

    @Override
    public IViewElement set(String key, Object value) {
        if (StringUtils.isBlank((String)key)) {
            return this;
        }
        if (key.equalsIgnoreCase(KEY_VALUE)) {
            this.theModel.setValues((List)value);
            this.theModel.fireTableDataChanged();
            this.theTable.validate();
        } else {
            super.set(key, value);
        }
        return this;
    }

    @Override
    public Object get(String key) {
        if (StringUtils.isBlank((String)key)) {
            return null;
        }
        if (key.equalsIgnoreCase(KEY_SELECTED_ROWS)) {
            int[] selRows = this.theTable.getSelectedRows();
            Integer[] selRows1 = new Integer[selRows.length];
            for (int i = 0; i < selRows.length; ++i) {
                selRows1[i] = new Integer(selRows[i]);
            }
            return Arrays.asList(selRows1);
        }
        return super.get(key);
    }
}

