/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.litef.widgets;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.beanutils.PropertyUtils;

public class BeanTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -3864331754350934939L;
    private List<String> columnBeanPropertyNames = new ArrayList<String>();
    private List<String> columnNames = new ArrayList<String>();
    private List<Class<?>> columnClasses = new ArrayList();
    private List<?> valueList = new ArrayList();

    public void addColumn(String colName, String beanPropName, Class<?> colCls) {
        this.columnNames.add(colName);
        this.columnBeanPropertyNames.add(beanPropName);
        if (colCls != null) {
            this.columnClasses.add(colCls);
        } else {
            this.columnClasses.add(Object.class);
        }
    }

    public void setValues(List<?> values) {
        this.valueList = values;
    }

    @Override
    public int findColumn(String name) {
        return this.columnNames.indexOf(name);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.columnClasses.get(columnIndex);
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.columnNames.get(columnIndex);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.size();
    }

    @Override
    public int getRowCount() {
        return this.valueList.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        String beanPropName = this.columnBeanPropertyNames.get(col);
        Object bean = this.valueList.get(row);
        try {
            return PropertyUtils.getProperty(bean, (String)beanPropName);
        }
        catch (Exception exep) {
            return null;
        }
    }
}

