/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.litef.widgets;

import in.gov.uidai.litef.devapi.IViewElement;
import in.gov.uidai.litef.widgets.ViewElement;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import org.apache.commons.lang.StringUtils;

public class ButtonElement
extends ViewElement {
    public static final String AXN_CLICK = "click";
    public static final String KEY_SELECTED_VALUE = "selValue";
    public static final String KEY_IS_SELECTED = "isSelected";
    public static final String KEY_TEXT = "text";
    public static final String KEY_SET_ACTION = "setAction";
    public static final String KEY_SET_SELECTED = "setSelected";
    private final AbstractButton theComp;

    protected ButtonElement(AbstractButton comp, String name) {
        super(comp, name);
        this.theComp = comp;
    }

    @Override
    public IViewElement set(String key, Object value) {
        if (StringUtils.isBlank((String)key) || value == null) {
            return this;
        }
        if (key.equalsIgnoreCase(KEY_TEXT)) {
            this.theComp.setText((String)value);
        } else if (key.equalsIgnoreCase(KEY_SET_ACTION)) {
            this.theComp.addActionListener((ActionListener)value);
        } else if (key.equalsIgnoreCase(KEY_SET_SELECTED)) {
            this.theComp.setSelected((Boolean)value);
        } else {
            super.set(key, value);
        }
        return this;
    }

    @Override
    public Object get(String key) {
        if (StringUtils.isBlank((String)key)) {
            return this;
        }
        if (key.equalsIgnoreCase(KEY_SELECTED_VALUE)) {
            return this.theComp.getName();
        }
        if (key.equalsIgnoreCase(KEY_IS_SELECTED)) {
            return this.theComp.isSelected();
        }
        if (key.equalsIgnoreCase(KEY_TEXT)) {
            return this.theComp.getText();
        }
        return super.get(key);
    }

    @Override
    public IViewElement call(String action) {
        if (StringUtils.isEmpty((String)action)) {
            return this;
        }
        if (action.equalsIgnoreCase(AXN_CLICK)) {
            this.theComp.doClick();
        } else {
            super.call(action);
        }
        return this;
    }
}

