/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.litef.widgets;

import in.gov.uidai.litef.devapi.IViewElement;
import in.gov.uidai.litef.widgets.VisualNotifyViewElement;
import in.gov.uidai.swing.combo.DropDownItem;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import org.apache.commons.lang.StringUtils;

public class ComboElement
extends VisualNotifyViewElement {
    public static final String KEY_EDITABLE = "editable";
    public static final String KEY_SELECTED_INDEX = "selectedIndex";
    public static final String KEY_SELECTED_ITEM = "selectedItem";
    public static final String KEY_SELECTED_VALUE = "selectedValue";
    public static final String KEY_OPTIONS = "options";
    private final JComboBox theComp;

    protected ComboElement(JComboBox comp, String name) {
        super(comp, name);
        this.theComp = comp;
    }

    @Override
    public IViewElement set(String key, Object value) {
        if (StringUtils.isBlank((String)key) || value == null) {
            return this;
        }
        if (key.equalsIgnoreCase(KEY_EDITABLE)) {
            boolean flag = Boolean.parseBoolean(value.toString());
            this.theComp.setEditable(flag);
        } else if (key.equalsIgnoreCase(KEY_SELECTED_INDEX)) {
            int index = 0;
            try {
                index = Integer.parseInt(value.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (index >= 0 && this.theComp.getItemCount() > 0) {
                this.theComp.setSelectedIndex(index);
            }
        } else if (key.equalsIgnoreCase(KEY_SELECTED_ITEM)) {
            this.theComp.setSelectedItem(value);
        } else if (key.equalsIgnoreCase(KEY_SELECTED_VALUE)) {
            for (int i = 0; i < this.theComp.getModel().getSize(); ++i) {
                Object itemAt = this.theComp.getItemAt(i);
                if (!((DropDownItem)itemAt).getValue().equals(value)) continue;
                this.theComp.setSelectedIndex(i);
                return this;
            }
        } else if (key.equalsIgnoreCase(KEY_OPTIONS)) {
            this.theComp.removeAllItems();
            List options = (List)value;
            for (Object option : options) {
                this.theComp.addItem(option);
            }
        } else {
            super.set(key, value);
        }
        return this;
    }

    @Override
    public Object get(String key) {
        if (StringUtils.isBlank((String)key)) {
            return null;
        }
        if (key.equalsIgnoreCase(KEY_SELECTED_INDEX)) {
            return this.theComp.getSelectedIndex();
        }
        if (key.equalsIgnoreCase(KEY_SELECTED_ITEM)) {
            return this.theComp.getSelectedItem();
        }
        if (key.equalsIgnoreCase(KEY_OPTIONS)) {
            ArrayList options = new ArrayList();
            int size = this.theComp.getModel().getSize();
            for (int i = 0; i < size; ++i) {
                options.add(this.theComp.getModel().getElementAt(i));
            }
            return options;
        }
        return super.get(key);
    }
}

